/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.extra.cglib;

import cn.hutool.core.lang.SimpleCache;
import cn.hutool.core.util.StrUtil;
import net.sf.cglib.beans.BeanCopier;
import net.sf.cglib.core.Converter;

public enum BeanCopierCache {
    INSTANCE;

    private final SimpleCache<String, BeanCopier> cache = new SimpleCache();

    public BeanCopier get(Class<?> srcClass, Class<?> targetClass, Converter converter) {
        return this.get(srcClass, targetClass, null != converter);
    }

    public BeanCopier get(Class<?> srcClass, Class<?> targetClass, boolean useConverter) {
        String key = this.genKey(srcClass, targetClass, useConverter);
        return this.cache.get(key, () -> BeanCopier.create((Class)srcClass, (Class)targetClass, (boolean)useConverter));
    }

    private String genKey(Class<?> srcClass, Class<?> targetClass, boolean useConverter) {
        StringBuilder key = StrUtil.builder().append(srcClass.getName()).append('#').append(targetClass.getName()).append('#').append(useConverter ? 1 : 0);
        return key.toString();
    }
}

