/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.json;

import cn.hutool.core.bean.BeanPath;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.lang.Filter;
import cn.hutool.core.lang.mutable.MutablePair;
import cn.hutool.core.map.CaseInsensitiveLinkedMap;
import cn.hutool.core.map.CaseInsensitiveMap;
import cn.hutool.core.map.CaseInsensitiveTreeMap;
import cn.hutool.core.map.MapWrapper;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.InternalJSONUtil;
import cn.hutool.json.JSON;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONConfig;
import cn.hutool.json.JSONConverter;
import cn.hutool.json.JSONException;
import cn.hutool.json.JSONGetter;
import cn.hutool.json.JSONTokener;
import cn.hutool.json.JSONUtil;
import cn.hutool.json.XML;
import cn.hutool.json.serialize.GlobalSerializeMapping;
import cn.hutool.json.serialize.JSONObjectSerializer;
import cn.hutool.json.serialize.JSONSerializer;
import cn.hutool.json.serialize.JSONWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TreeMap;

public class JSONObject
extends MapWrapper<String, Object>
implements JSON,
JSONGetter<String> {
    private static final long serialVersionUID = -330220388580734346L;
    public static final int DEFAULT_CAPACITY = 16;
    private JSONConfig config;

    public JSONObject() {
        this(16, false);
    }

    public JSONObject(boolean isOrder) {
        this(16, isOrder);
    }

    public JSONObject(int capacity, boolean isOrder) {
        this(capacity, false, isOrder);
    }

    @Deprecated
    public JSONObject(int capacity, boolean isIgnoreCase, boolean isOrder) {
        this(capacity, JSONConfig.create().setIgnoreCase(isIgnoreCase));
    }

    public JSONObject(JSONConfig config) {
        this(16, config);
    }

    public JSONObject(int capacity, JSONConfig config) {
        super(JSONObject.createRaw(capacity, config));
        this.config = config;
    }

    public JSONObject(Object source) {
        this(source, InternalJSONUtil.defaultIgnoreNullValue(source));
    }

    public JSONObject(Object source, boolean ignoreNullValue) {
        this(source, JSONConfig.create().setIgnoreNullValue(ignoreNullValue));
    }

    @Deprecated
    public JSONObject(Object source, boolean ignoreNullValue, boolean isOrder) {
        this(source, JSONConfig.create().setIgnoreCase(source instanceof CaseInsensitiveMap).setIgnoreNullValue(ignoreNullValue));
    }

    public JSONObject(Object source, JSONConfig config) {
        this(16, config);
        this.init(source);
    }

    public JSONObject(Object obj, String ... names) {
        this();
        if (ArrayUtil.isEmpty(names)) {
            this.init(obj);
            return;
        }
        if (obj instanceof Map) {
            for (String name : names) {
                Object value = ((Map)obj).get(name);
                this.putOnce(name, value);
            }
        } else {
            for (String name : names) {
                try {
                    this.putOpt(name, ReflectUtil.getFieldValue(obj, name));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    @Deprecated
    public JSONObject(CharSequence source, boolean isOrder) throws JSONException {
        this((Object)source, JSONConfig.create());
    }

    @Override
    public JSONConfig getConfig() {
        return this.config;
    }

    public JSONObject setDateFormat(String format) {
        this.config.setDateFormat(format);
        return this;
    }

    @Override
    public <T> T toBean(Type type) {
        return JSON.super.toBean(type, this.config.isIgnoreError());
    }

    public JSONArray toJSONArray(Collection<String> names) throws JSONException {
        if (CollectionUtil.isEmpty(names)) {
            return null;
        }
        JSONArray ja = new JSONArray(this.config);
        for (String name : names) {
            Object value = this.get(name);
            if (null == value) continue;
            ja.set(value);
        }
        return ja;
    }

    @Override
    public Object getObj(String key, Object defaultValue) {
        return this.getOrDefault(key, defaultValue);
    }

    @Override
    public Object getByPath(String expression) {
        return BeanPath.create(expression).get(this);
    }

    @Override
    public <T> T getByPath(String expression, Class<T> resultType) {
        return JSONConverter.jsonConvert(resultType, this.getByPath(expression), true);
    }

    @Override
    public void putByPath(String expression, Object value) {
        BeanPath.create(expression).set(this, value);
    }

    @Override
    @Deprecated
    public JSONObject put(String key, Object value) throws JSONException {
        return this.set(key, value);
    }

    public JSONObject set(String key, Object value) throws JSONException {
        if (null == key) {
            return this;
        }
        boolean ignoreNullValue = this.config.isIgnoreNullValue();
        if (ObjectUtil.isNull(value) && ignoreNullValue) {
            this.remove(key);
        } else {
            InternalJSONUtil.testValidity(value);
            super.put(key, JSONUtil.wrap(value, this.config));
        }
        return this;
    }

    public JSONObject putOnce(String key, Object value) throws JSONException {
        if (key != null) {
            if (this.containsKey(key)) {
                throw new JSONException("Duplicate key \"{}\"", key);
            }
            this.set(key, value);
        }
        return this;
    }

    public JSONObject putOpt(String key, Object value) throws JSONException {
        if (key != null && value != null) {
            this.set(key, value);
        }
        return this;
    }

    @Override
    public void putAll(Map<? extends String, ?> m) {
        for (Map.Entry<String, ?> entry : m.entrySet()) {
            this.set(entry.getKey(), entry.getValue());
        }
    }

    public JSONObject accumulate(String key, Object value) throws JSONException {
        InternalJSONUtil.testValidity(value);
        Object object = this.getObj(key);
        if (object == null) {
            this.set(key, value);
        } else if (object instanceof JSONArray) {
            ((JSONArray)object).set(value);
        } else {
            this.set(key, JSONUtil.createArray(this.config).set(object).set(value));
        }
        return this;
    }

    public JSONObject append(String key, Object value) throws JSONException {
        InternalJSONUtil.testValidity(value);
        Object object = this.getObj(key);
        if (object == null) {
            this.set(key, new JSONArray(this.config).set(value));
        } else if (object instanceof JSONArray) {
            this.set(key, ((JSONArray)object).set(value));
        } else {
            throw new JSONException("JSONObject [" + key + "] is not a JSONArray.");
        }
        return this;
    }

    public JSONObject increment(String key) throws JSONException {
        Object value = this.getObj(key);
        if (value == null) {
            this.set(key, 1);
        } else if (value instanceof BigInteger) {
            this.set(key, ((BigInteger)value).add(BigInteger.ONE));
        } else if (value instanceof BigDecimal) {
            this.set(key, ((BigDecimal)value).add(BigDecimal.ONE));
        } else if (value instanceof Integer) {
            this.set(key, (Integer)value + 1);
        } else if (value instanceof Long) {
            this.set(key, (Long)value + 1L);
        } else if (value instanceof Double) {
            this.set(key, (Double)value + 1.0);
        } else if (value instanceof Float) {
            this.set(key, Float.valueOf(((Float)value).floatValue() + 1.0f));
        } else {
            throw new JSONException("Unable to increment [" + JSONUtil.quote(key) + "].");
        }
        return this;
    }

    @Override
    public String toString() {
        return this.toJSONString(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toJSONString(int indentFactor, Filter<MutablePair<String, Object>> filter) {
        StringWriter sw = new StringWriter();
        StringBuffer stringBuffer = sw.getBuffer();
        synchronized (stringBuffer) {
            return this.write(sw, indentFactor, 0, filter).toString();
        }
    }

    @Override
    public Writer write(Writer writer, int indentFactor, int indent) throws JSONException {
        return this.write(writer, indentFactor, indent, null);
    }

    public Writer write(Writer writer, int indentFactor, int indent, Filter<MutablePair<String, Object>> filter) throws JSONException {
        JSONWriter jsonWriter = JSONWriter.of(writer, indentFactor, indent, this.config).beginObj();
        this.forEach((? super K key, ? super V value) -> {
            if (null != filter) {
                MutablePair<String, Object> pair = new MutablePair<String, Object>((String)key, value);
                if (filter.accept(pair)) {
                    jsonWriter.writeField((String)pair.getKey(), pair.getValue());
                }
            } else {
                jsonWriter.writeField((String)key, value);
            }
        });
        jsonWriter.end();
        return writer;
    }

    @Override
    public JSONObject clone() throws CloneNotSupportedException {
        JSONObject clone = (JSONObject)super.clone();
        clone.config = this.config;
        return clone;
    }

    private void populateMap(Object bean) {
        BeanUtil.beanToMap(bean, this, InternalJSONUtil.toCopyOptions(this.config));
    }

    private void init(Object source) {
        if (null == source) {
            return;
        }
        JSONSerializer<JSON, ?> serializer = GlobalSerializeMapping.getSerializer(source.getClass());
        if (serializer instanceof JSONObjectSerializer) {
            serializer.serialize(this, source);
            return;
        }
        if (ArrayUtil.isArray(source) || source instanceof JSONArray) {
            throw new JSONException("Unsupported type [{}] to JSONObject!", source.getClass());
        }
        if (source instanceof Map) {
            for (Map.Entry e : ((Map)source).entrySet()) {
                this.set(Convert.toStr(e.getKey()), e.getValue());
            }
        } else if (source instanceof Map.Entry) {
            Map.Entry entry = (Map.Entry)source;
            this.set(Convert.toStr(entry.getKey()), entry.getValue());
        } else if (source instanceof CharSequence) {
            this.init((CharSequence)source);
        } else if (source instanceof JSONTokener) {
            this.init((JSONTokener)source);
        } else if (source instanceof ResourceBundle) {
            this.init((ResourceBundle)source);
        } else if (BeanUtil.isReadableBean(source.getClass())) {
            this.populateMap(source);
        } else {
            throw new JSONException("Unsupported type [{}] to JSONObject!", source.getClass());
        }
    }

    private void init(ResourceBundle bundle) {
        Enumeration<String> keys = bundle.getKeys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            if (key == null) continue;
            InternalJSONUtil.propertyPut(this, key, bundle.getString(key));
        }
    }

    private void init(CharSequence source) {
        String jsonStr = StrUtil.trim(source);
        if (StrUtil.startWith((CharSequence)jsonStr, '<')) {
            XML.toJSONObject(this, jsonStr, false);
            return;
        }
        this.init(new JSONTokener(StrUtil.trim(source), this.config));
    }

    private void init(JSONTokener x) {
        if (x.nextClean() != '{') {
            throw x.syntaxError("A JSONObject text must begin with '{'");
        }
        block8: while (true) {
            char c = x.nextClean();
            switch (c) {
                case '\u0000': {
                    throw x.syntaxError("A JSONObject text must end with '}'");
                }
                case '}': {
                    return;
                }
            }
            x.back();
            String key = x.nextValue().toString();
            c = x.nextClean();
            if (c != ':') {
                throw x.syntaxError("Expected a ':' after a key");
            }
            this.putOnce(key, x.nextValue());
            switch (x.nextClean()) {
                case ',': 
                case ';': {
                    if (x.nextClean() == '}') {
                        return;
                    }
                    x.back();
                    continue block8;
                }
                case '}': {
                    return;
                }
            }
            break;
        }
        throw x.syntaxError("Expected a ',' or '}'");
    }

    private static Map<String, Object> createRaw(int capacity, JSONConfig config) {
        if (null == config) {
            config = JSONConfig.create();
        }
        Comparator<String> keyComparator = config.getKeyComparator();
        Map rawHashMap = config.isIgnoreCase() ? (null != keyComparator ? new CaseInsensitiveTreeMap(keyComparator) : new CaseInsensitiveLinkedMap(capacity)) : (null != keyComparator ? new TreeMap(keyComparator) : new LinkedHashMap(capacity));
        return rawHashMap;
    }
}

