/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.lang;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.lang.Console;
import cn.hutool.core.util.StrUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ConsoleTable {
    private static final char ROW_LINE = '\uff0d';
    private static final char COLUMN_LINE = '|';
    private static final char CORNER = '+';
    private static final char SPACE = '\u3000';
    private static final char LF = '\n';
    private final List<List<String>> headerList = new ArrayList<List<String>>();
    private final List<List<String>> bodyList = new ArrayList<List<String>>();
    private List<Integer> columnCharNumber;

    public static ConsoleTable create() {
        return new ConsoleTable();
    }

    public ConsoleTable addHeader(String ... titles) {
        if (this.columnCharNumber == null) {
            this.columnCharNumber = new ArrayList<Integer>(Collections.nCopies(titles.length, 0));
        }
        ArrayList<String> l = new ArrayList<String>();
        this.fillColumns(l, titles);
        this.headerList.add(l);
        return this;
    }

    public ConsoleTable addBody(String ... values) {
        ArrayList<String> l = new ArrayList<String>();
        this.bodyList.add(l);
        this.fillColumns(l, values);
        return this;
    }

    private void fillColumns(List<String> l, String[] columns) {
        for (int i = 0; i < columns.length; ++i) {
            String column = columns[i];
            column = Convert.toSBC(column);
            l.add(column);
            int width = column.length();
            if (width <= this.columnCharNumber.get(i)) continue;
            this.columnCharNumber.set(i, width);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.fillBorder(sb);
        this.fillRow(sb, this.headerList);
        this.fillBorder(sb);
        this.fillRow(sb, this.bodyList);
        this.fillBorder(sb);
        return sb.toString();
    }

    private void fillRow(StringBuilder sb, List<List<String>> list) {
        for (List<String> row : list) {
            for (int i = 0; i < row.size(); ++i) {
                if (i == 0) {
                    sb.append('|');
                }
                String value = row.get(i);
                sb.append('\u3000');
                sb.append(value);
                sb.append('\u3000');
                int length = value.length();
                int maxLength = this.columnCharNumber.get(i);
                if (maxLength > length) {
                    for (int j = 0; j < maxLength - length; ++j) {
                        sb.append('\u3000');
                    }
                }
                sb.append('|');
            }
            sb.append('\n');
        }
    }

    private void fillBorder(StringBuilder sb) {
        sb.append('+');
        for (Integer width : this.columnCharNumber) {
            sb.append(Convert.toSBC(StrUtil.fillAfter("", '\uff0d', width + 2)));
            sb.append('+');
        }
        sb.append('\n');
    }

    public void print() {
        Console.print(this.toString());
    }
}

