/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.extra.ftp;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.StrUtil;
import java.io.Closeable;
import java.io.File;
import java.nio.charset.Charset;
import java.util.List;

public abstract class AbstractFtp
implements Closeable {
    public static final Charset DEFAULT_CHARSET = CharsetUtil.CHARSET_UTF_8;
    protected Charset charset;

    public abstract boolean cd(String var1);

    public boolean toParent() {
        return this.cd("..");
    }

    public abstract String pwd();

    public abstract boolean mkdir(String var1);

    public boolean exist(String path) {
        String fileName = FileUtil.getName((String)path);
        String dir = StrUtil.removeSuffix((CharSequence)path, (CharSequence)fileName);
        List<String> names = this.ls(dir);
        return AbstractFtp.containsIgnoreCase(names, fileName);
    }

    public abstract List<String> ls(String var1);

    public abstract boolean delFile(String var1);

    public abstract boolean delDir(String var1);

    public void mkDirs(String dir) {
        String[] dirs = dir.split("[\\\\/]");
        String now = this.pwd();
        this.cd("/");
        for (int i = 0; i < dirs.length; ++i) {
            if (!StrUtil.isNotEmpty((CharSequence)dirs[i]) || this.cd(dirs[i])) continue;
            this.mkdir(dirs[i]);
            this.cd(dirs[i]);
        }
        this.cd(now);
    }

    public abstract boolean upload(String var1, File var2);

    public abstract void download(String var1, File var2);

    private static boolean containsIgnoreCase(List<String> names, String nameToFind) {
        if (CollUtil.isEmpty(names)) {
            return false;
        }
        if (StrUtil.isEmpty((CharSequence)nameToFind)) {
            return false;
        }
        for (String name : names) {
            if (!nameToFind.equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }
}

