/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.analysis;

import co.elastic.clients.elasticsearch._types.analysis.EdgeNGramSide;
import co.elastic.clients.elasticsearch._types.analysis.TokenFilterBase;
import co.elastic.clients.elasticsearch._types.analysis.TokenFilterDefinition;
import co.elastic.clients.elasticsearch._types.analysis.TokenFilterDefinitionVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class EdgeNGramTokenFilter
extends TokenFilterBase
implements TokenFilterDefinitionVariant {
    @Nullable
    private final Integer maxGram;
    @Nullable
    private final Integer minGram;
    @Nullable
    private final EdgeNGramSide side;
    @Nullable
    private final Boolean preserveOriginal;
    public static final JsonpDeserializer<EdgeNGramTokenFilter> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, EdgeNGramTokenFilter::setupEdgeNGramTokenFilterDeserializer);

    private EdgeNGramTokenFilter(Builder builder) {
        super(builder);
        this.maxGram = builder.maxGram;
        this.minGram = builder.minGram;
        this.side = builder.side;
        this.preserveOriginal = builder.preserveOriginal;
    }

    public static EdgeNGramTokenFilter of(Function<Builder, ObjectBuilder<EdgeNGramTokenFilter>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public TokenFilterDefinition.Kind _tokenFilterDefinitionKind() {
        return TokenFilterDefinition.Kind.EdgeNgram;
    }

    @Nullable
    public final Integer maxGram() {
        return this.maxGram;
    }

    @Nullable
    public final Integer minGram() {
        return this.minGram;
    }

    @Nullable
    public final EdgeNGramSide side() {
        return this.side;
    }

    @Nullable
    public final Boolean preserveOriginal() {
        return this.preserveOriginal;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "edge_ngram");
        super.serializeInternal(generator, mapper);
        if (this.maxGram != null) {
            generator.writeKey("max_gram");
            generator.write(this.maxGram.intValue());
        }
        if (this.minGram != null) {
            generator.writeKey("min_gram");
            generator.write(this.minGram.intValue());
        }
        if (this.side != null) {
            generator.writeKey("side");
            this.side.serialize(generator, mapper);
        }
        if (this.preserveOriginal != null) {
            generator.writeKey("preserve_original");
            generator.write(this.preserveOriginal.booleanValue());
        }
    }

    protected static void setupEdgeNGramTokenFilterDeserializer(ObjectDeserializer<Builder> op) {
        TokenFilterBase.setupTokenFilterBaseDeserializer(op);
        op.add(Builder::maxGram, JsonpDeserializer.integerDeserializer(), "max_gram");
        op.add(Builder::minGram, JsonpDeserializer.integerDeserializer(), "min_gram");
        op.add(Builder::side, EdgeNGramSide._DESERIALIZER, "side");
        op.add(Builder::preserveOriginal, JsonpDeserializer.booleanDeserializer(), "preserve_original");
        op.ignore("type");
    }

    public static class Builder
    extends TokenFilterBase.AbstractBuilder<Builder>
    implements ObjectBuilder<EdgeNGramTokenFilter> {
        @Nullable
        private Integer maxGram;
        @Nullable
        private Integer minGram;
        @Nullable
        private EdgeNGramSide side;
        @Nullable
        private Boolean preserveOriginal;

        public final Builder maxGram(@Nullable Integer value) {
            this.maxGram = value;
            return this;
        }

        public final Builder minGram(@Nullable Integer value) {
            this.minGram = value;
            return this;
        }

        public final Builder side(@Nullable EdgeNGramSide value) {
            this.side = value;
            return this;
        }

        public final Builder preserveOriginal(@Nullable Boolean value) {
            this.preserveOriginal = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public EdgeNGramTokenFilter build() {
            this._checkSingleUse();
            return new EdgeNGramTokenFilter(this);
        }
    }
}

