/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.Refresh;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.security.ApplicationPrivileges;
import co.elastic.clients.elasticsearch.security.IndicesPrivileges;
import co.elastic.clients.elasticsearch.security.PutRoleResponse;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class PutRoleRequest
extends RequestBase
implements JsonpSerializable {
    private final List<ApplicationPrivileges> applications;
    private final List<String> cluster;
    private final Map<String, JsonData> global;
    private final List<IndicesPrivileges> indices;
    private final Map<String, JsonData> metadata;
    private final String name;
    @Nullable
    private final Refresh refresh;
    private final List<String> runAs;
    private final Map<String, JsonData> transientMetadata;
    public static final JsonpDeserializer<PutRoleRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PutRoleRequest::setupPutRoleRequestDeserializer);
    public static final Endpoint<PutRoleRequest, PutRoleResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<PutRoleRequest, PutRoleResponse>("es/security.put_role", request -> "PUT", request -> {
        boolean _name = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_security");
            buf.append("/role");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.name, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _name = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            params.put("name", request.name);
        }
        return params;
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.refresh != null) {
            params.put("refresh", request.refresh.jsonValue());
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, PutRoleResponse._DESERIALIZER);

    private PutRoleRequest(Builder builder) {
        this.applications = ApiTypeHelper.unmodifiable(builder.applications);
        this.cluster = ApiTypeHelper.unmodifiable(builder.cluster);
        this.global = ApiTypeHelper.unmodifiable(builder.global);
        this.indices = ApiTypeHelper.unmodifiable(builder.indices);
        this.metadata = ApiTypeHelper.unmodifiable(builder.metadata);
        this.name = ApiTypeHelper.requireNonNull(builder.name, this, "name");
        this.refresh = builder.refresh;
        this.runAs = ApiTypeHelper.unmodifiable(builder.runAs);
        this.transientMetadata = ApiTypeHelper.unmodifiable(builder.transientMetadata);
    }

    public static PutRoleRequest of(Function<Builder, ObjectBuilder<PutRoleRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<ApplicationPrivileges> applications() {
        return this.applications;
    }

    public final List<String> cluster() {
        return this.cluster;
    }

    public final Map<String, JsonData> global() {
        return this.global;
    }

    public final List<IndicesPrivileges> indices() {
        return this.indices;
    }

    public final Map<String, JsonData> metadata() {
        return this.metadata;
    }

    public final String name() {
        return this.name;
    }

    @Nullable
    public final Refresh refresh() {
        return this.refresh;
    }

    public final List<String> runAs() {
        return this.runAs;
    }

    public final Map<String, JsonData> transientMetadata() {
        return this.transientMetadata;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.applications)) {
            generator.writeKey("applications");
            generator.writeStartArray();
            for (ApplicationPrivileges applicationPrivileges : this.applications) {
                applicationPrivileges.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.cluster)) {
            generator.writeKey("cluster");
            generator.writeStartArray();
            for (String string : this.cluster) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.global)) {
            generator.writeKey("global");
            generator.writeStartObject();
            for (Map.Entry entry : this.global.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((JsonData)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.indices)) {
            generator.writeKey("indices");
            generator.writeStartArray();
            for (IndicesPrivileges indicesPrivileges : this.indices) {
                indicesPrivileges.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.metadata)) {
            generator.writeKey("metadata");
            generator.writeStartObject();
            for (Map.Entry entry : this.metadata.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((JsonData)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.runAs)) {
            generator.writeKey("run_as");
            generator.writeStartArray();
            for (String string : this.runAs) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.transientMetadata)) {
            generator.writeKey("transient_metadata");
            generator.writeStartObject();
            for (Map.Entry entry : this.transientMetadata.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((JsonData)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupPutRoleRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::applications, JsonpDeserializer.arrayDeserializer(ApplicationPrivileges._DESERIALIZER), "applications");
        op.add(Builder::cluster, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "cluster");
        op.add(Builder::global, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "global");
        op.add(Builder::indices, JsonpDeserializer.arrayDeserializer(IndicesPrivileges._DESERIALIZER), "indices");
        op.add(Builder::metadata, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "metadata");
        op.add(Builder::runAs, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "run_as");
        op.add(Builder::transientMetadata, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "transient_metadata");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<PutRoleRequest> {
        @Nullable
        private List<ApplicationPrivileges> applications;
        @Nullable
        private List<String> cluster;
        @Nullable
        private Map<String, JsonData> global;
        @Nullable
        private List<IndicesPrivileges> indices;
        @Nullable
        private Map<String, JsonData> metadata;
        private String name;
        @Nullable
        private Refresh refresh;
        @Nullable
        private List<String> runAs;
        @Nullable
        private Map<String, JsonData> transientMetadata;

        public final Builder applications(List<ApplicationPrivileges> list) {
            this.applications = Builder._listAddAll(this.applications, list);
            return this;
        }

        public final Builder applications(ApplicationPrivileges value, ApplicationPrivileges ... values) {
            this.applications = Builder._listAdd(this.applications, value, values);
            return this;
        }

        public final Builder applications(Function<ApplicationPrivileges.Builder, ObjectBuilder<ApplicationPrivileges>> fn) {
            return this.applications(fn.apply(new ApplicationPrivileges.Builder()).build(), new ApplicationPrivileges[0]);
        }

        public final Builder cluster(List<String> list) {
            this.cluster = Builder._listAddAll(this.cluster, list);
            return this;
        }

        public final Builder cluster(String value, String ... values) {
            this.cluster = Builder._listAdd(this.cluster, value, values);
            return this;
        }

        public final Builder global(Map<String, JsonData> map) {
            this.global = Builder._mapPutAll(this.global, map);
            return this;
        }

        public final Builder global(String key, JsonData value) {
            this.global = Builder._mapPut(this.global, key, value);
            return this;
        }

        public final Builder indices(List<IndicesPrivileges> list) {
            this.indices = Builder._listAddAll(this.indices, list);
            return this;
        }

        public final Builder indices(IndicesPrivileges value, IndicesPrivileges ... values) {
            this.indices = Builder._listAdd(this.indices, value, values);
            return this;
        }

        public final Builder indices(Function<IndicesPrivileges.Builder, ObjectBuilder<IndicesPrivileges>> fn) {
            return this.indices(fn.apply(new IndicesPrivileges.Builder()).build(), new IndicesPrivileges[0]);
        }

        public final Builder metadata(Map<String, JsonData> map) {
            this.metadata = Builder._mapPutAll(this.metadata, map);
            return this;
        }

        public final Builder metadata(String key, JsonData value) {
            this.metadata = Builder._mapPut(this.metadata, key, value);
            return this;
        }

        public final Builder name(String value) {
            this.name = value;
            return this;
        }

        public final Builder refresh(@Nullable Refresh value) {
            this.refresh = value;
            return this;
        }

        public final Builder runAs(List<String> list) {
            this.runAs = Builder._listAddAll(this.runAs, list);
            return this;
        }

        public final Builder runAs(String value, String ... values) {
            this.runAs = Builder._listAdd(this.runAs, value, values);
            return this;
        }

        public final Builder transientMetadata(Map<String, JsonData> map) {
            this.transientMetadata = Builder._mapPutAll(this.transientMetadata, map);
            return this;
        }

        public final Builder transientMetadata(String key, JsonData value) {
            this.transientMetadata = Builder._mapPut(this.transientMetadata, key, value);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public PutRoleRequest build() {
            this._checkSingleUse();
            return new PutRoleRequest(this);
        }
    }
}

