/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.aggregations.Aggregate;
import co.elastic.clients.json.ExternallyTaggedUnion;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

public abstract class MultiBucketBase
implements JsonpSerializable {
    private final Map<String, Aggregate> aggregations;
    private final long docCount;

    protected MultiBucketBase(AbstractBuilder<?> builder) {
        this.aggregations = ApiTypeHelper.unmodifiable(builder.aggregations);
        this.docCount = ApiTypeHelper.requireNonNull(((AbstractBuilder)builder).docCount, this, "docCount");
    }

    public final Map<String, Aggregate> aggregations() {
        return this.aggregations;
    }

    public final long docCount() {
        return this.docCount;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        ExternallyTaggedUnion.serializeTypedKeysInner(this.aggregations, generator, mapper);
        generator.writeKey("doc_count");
        generator.write(this.docCount);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupMultiBucketBaseDeserializer(ObjectDeserializer<BuilderT> op) {
        op.add(AbstractBuilder::docCount, JsonpDeserializer.longDeserializer(), "doc_count");
        op.setUnknownFieldHandler((builder, name, parser, mapper) -> {
            if (builder.aggregations == null) {
                builder.aggregations = new HashMap<String, Aggregate>();
            }
            Aggregate._TYPED_KEYS_DESERIALIZER.deserializeEntry((String)name, (JsonParser)parser, (JsonpMapper)mapper, builder.aggregations);
        });
    }

    public static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>>
    extends WithJsonObjectBuilderBase<BuilderT> {
        @Nullable
        protected Map<String, Aggregate> aggregations = new HashMap<String, Aggregate>();
        private Long docCount;

        public final BuilderT aggregations(Map<String, Aggregate> map) {
            this.aggregations = AbstractBuilder._mapPutAll(this.aggregations, map);
            return (BuilderT)this.self();
        }

        public final BuilderT aggregations(String key, Aggregate value) {
            this.aggregations = AbstractBuilder._mapPut(this.aggregations, key, value);
            return (BuilderT)this.self();
        }

        public final BuilderT aggregations(String key, Function<Aggregate.Builder, ObjectBuilder<Aggregate>> fn) {
            return this.aggregations(key, fn.apply(new Aggregate.Builder()).build());
        }

        public final BuilderT docCount(long value) {
            this.docCount = value;
            return (BuilderT)this.self();
        }

        @Override
        protected abstract BuilderT self();
    }
}

