/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.snapshot;

import co.elastic.clients.elasticsearch.snapshot.RepositorySettingsBase;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class AzureRepositorySettings
extends RepositorySettingsBase {
    @Nullable
    private final String client;
    @Nullable
    private final String container;
    @Nullable
    private final String basePath;
    @Nullable
    private final Boolean readonly;
    @Nullable
    private final String locationMode;
    public static final JsonpDeserializer<AzureRepositorySettings> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, AzureRepositorySettings::setupAzureRepositorySettingsDeserializer);

    private AzureRepositorySettings(Builder builder) {
        super(builder);
        this.client = builder.client;
        this.container = builder.container;
        this.basePath = builder.basePath;
        this.readonly = builder.readonly;
        this.locationMode = builder.locationMode;
    }

    public static AzureRepositorySettings of(Function<Builder, ObjectBuilder<AzureRepositorySettings>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String client() {
        return this.client;
    }

    @Nullable
    public final String container() {
        return this.container;
    }

    @Nullable
    public final String basePath() {
        return this.basePath;
    }

    @Nullable
    public final Boolean readonly() {
        return this.readonly;
    }

    @Nullable
    public final String locationMode() {
        return this.locationMode;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.client != null) {
            generator.writeKey("client");
            generator.write(this.client);
        }
        if (this.container != null) {
            generator.writeKey("container");
            generator.write(this.container);
        }
        if (this.basePath != null) {
            generator.writeKey("base_path");
            generator.write(this.basePath);
        }
        if (this.readonly != null) {
            generator.writeKey("readonly");
            generator.write(this.readonly.booleanValue());
        }
        if (this.locationMode != null) {
            generator.writeKey("location_mode");
            generator.write(this.locationMode);
        }
    }

    protected static void setupAzureRepositorySettingsDeserializer(ObjectDeserializer<Builder> op) {
        RepositorySettingsBase.setupRepositorySettingsBaseDeserializer(op);
        op.add(Builder::client, JsonpDeserializer.stringDeserializer(), "client");
        op.add(Builder::container, JsonpDeserializer.stringDeserializer(), "container");
        op.add(Builder::basePath, JsonpDeserializer.stringDeserializer(), "base_path");
        op.add(Builder::readonly, JsonpDeserializer.booleanDeserializer(), "readonly");
        op.add(Builder::locationMode, JsonpDeserializer.stringDeserializer(), "location_mode");
    }

    public static class Builder
    extends RepositorySettingsBase.AbstractBuilder<Builder>
    implements ObjectBuilder<AzureRepositorySettings> {
        @Nullable
        private String client;
        @Nullable
        private String container;
        @Nullable
        private String basePath;
        @Nullable
        private Boolean readonly;
        @Nullable
        private String locationMode;

        public final Builder client(@Nullable String value) {
            this.client = value;
            return this;
        }

        public final Builder container(@Nullable String value) {
            this.container = value;
            return this;
        }

        public final Builder basePath(@Nullable String value) {
            this.basePath = value;
            return this;
        }

        public final Builder readonly(@Nullable Boolean value) {
            this.readonly = value;
            return this;
        }

        public final Builder locationMode(@Nullable String value) {
            this.locationMode = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public AzureRepositorySettings build() {
            this._checkSingleUse();
            return new AzureRepositorySettings(this);
        }
    }
}

