/*************************************************************************
 * 
 * ADOBE CONFIDENTIAL
 * __________________
 * 
 *  [2002] - [2007] Adobe Systems Incorporated 
 *  All Rights Reserved.
 * 
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated
 * and its suppliers and may be covered by U.S. and Foreign Patents,
 * patents in process, and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 */
package flex.messaging.util.concurrent;

/**
 * This interface defines a callback that can be registered with an {@link Executor}
 * to be notified when execution of a <code>Runnable</code> has failed.
 */
public interface FailedExecutionHandler
{
    /**
     * Invoked when a <code>Runnable</code> has failed to execute.
     * This is most commonly invoked when the <code>Runnable</code> can not be queued
     * for execution, but may also be invoked if an uncaught <code>Exception</code> was
     * thrown and the <code>Executor</code> implementation has support for catching this
     * and notifying via this callback.
     * 
     * @param command The <code>Runnable</code> command that failed to execute.
     * @param executor The <code>Executor</code> that was unable to execute the command.
     * @param exception The <code>Exception</code> identifying why the command failed to execute.
     */
    void failedExecution(Runnable command, Executor executor, Exception exception);
}
