/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib;

import java.util.ArrayList;
import java.util.List;
import org.jf.dexlib.ClassDataItem;
import org.jf.dexlib.Code.Format.Instruction20t;
import org.jf.dexlib.Code.Format.Instruction21c;
import org.jf.dexlib.Code.Format.Instruction30t;
import org.jf.dexlib.Code.Format.Instruction31c;
import org.jf.dexlib.Code.Instruction;
import org.jf.dexlib.Code.InstructionIterator;
import org.jf.dexlib.Code.MultiOffsetInstruction;
import org.jf.dexlib.Code.OffsetInstruction;
import org.jf.dexlib.Code.Opcode;
import org.jf.dexlib.Debug.DebugInstructionIterator;
import org.jf.dexlib.Debug.DebugOpcode;
import org.jf.dexlib.DebugInfoItem;
import org.jf.dexlib.DexFile;
import org.jf.dexlib.Item;
import org.jf.dexlib.ItemType;
import org.jf.dexlib.ReadContext;
import org.jf.dexlib.TypeIdItem;
import org.jf.dexlib.Util.AlignmentUtils;
import org.jf.dexlib.Util.AnnotatedOutput;
import org.jf.dexlib.Util.ByteArrayInput;
import org.jf.dexlib.Util.DebugInfoBuilder;
import org.jf.dexlib.Util.ExceptionWithContext;
import org.jf.dexlib.Util.Input;
import org.jf.dexlib.Util.Leb128Utils;
import org.jf.dexlib.Util.SparseArray;
import org.jf.dexlib.Util.SparseIntArray;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CodeItem
extends Item<CodeItem> {
    private int registerCount;
    private int inWords;
    private int outWords;
    private DebugInfoItem debugInfo;
    private Instruction[] instructions;
    private TryItem[] tries;
    private EncodedCatchHandler[] encodedCatchHandlers;
    private ClassDataItem.EncodedMethod parent;

    public CodeItem(DexFile dexFile) {
        super(dexFile);
    }

    private CodeItem(DexFile dexFile, int registerCount, int inWords, int outWords, DebugInfoItem debugInfo, Instruction[] instructions, TryItem[] tries, EncodedCatchHandler[] encodedCatchHandlers) {
        super(dexFile);
        this.registerCount = registerCount;
        this.inWords = inWords;
        this.outWords = outWords;
        this.debugInfo = debugInfo;
        if (debugInfo != null) {
            debugInfo.setParent(this);
        }
        this.instructions = instructions;
        this.tries = tries;
        this.encodedCatchHandlers = encodedCatchHandlers;
    }

    public static CodeItem internCodeItem(DexFile dexFile, int registerCount, int inWords, int outWords, DebugInfoItem debugInfo, List<Instruction> instructions, List<TryItem> tries, List<EncodedCatchHandler> encodedCatchHandlers) {
        TryItem[] triesArray = null;
        EncodedCatchHandler[] encodedCatchHandlersArray = null;
        Instruction[] instructionsArray = null;
        if (tries != null && tries.size() > 0) {
            triesArray = new TryItem[tries.size()];
            tries.toArray(triesArray);
        }
        if (encodedCatchHandlers != null && encodedCatchHandlers.size() > 0) {
            encodedCatchHandlersArray = new EncodedCatchHandler[encodedCatchHandlers.size()];
            encodedCatchHandlers.toArray(encodedCatchHandlersArray);
        }
        if (instructions != null && instructions.size() > 0) {
            instructionsArray = new Instruction[instructions.size()];
            instructions.toArray(instructionsArray);
        }
        CodeItem codeItem = new CodeItem(dexFile, registerCount, inWords, outWords, debugInfo, instructionsArray, triesArray, encodedCatchHandlersArray);
        return dexFile.CodeItemsSection.intern(codeItem);
    }

    @Override
    protected void readItem(Input in, ReadContext readContext) {
        this.registerCount = in.readShort();
        this.inWords = in.readShort();
        this.outWords = in.readShort();
        int triesCount = in.readShort();
        this.debugInfo = (DebugInfoItem)readContext.getOptionalOffsettedItemByOffset(ItemType.TYPE_DEBUG_INFO_ITEM, in.readInt());
        if (this.debugInfo != null) {
            this.debugInfo.setParent(this);
        }
        int instructionCount = in.readInt();
        final ArrayList instructionList = new ArrayList();
        byte[] encodedInstructions = in.readBytes(instructionCount * 2);
        InstructionIterator.IterateInstructions(this.dexFile, encodedInstructions, new InstructionIterator.ProcessInstructionDelegate(){

            public void ProcessInstruction(int codeAddress, Instruction instruction) {
                instructionList.add(instruction);
            }
        });
        this.instructions = new Instruction[instructionList.size()];
        instructionList.toArray(this.instructions);
        if (triesCount > 0) {
            in.alignTo(4);
            int triesOffset = in.getCursor();
            in.setCursor(triesOffset + 8 * triesCount);
            int encodedHandlerStart = in.getCursor();
            int handlerCount = in.readUnsignedLeb128();
            SparseArray<EncodedCatchHandler> handlerMap = new SparseArray<EncodedCatchHandler>(handlerCount);
            this.encodedCatchHandlers = new EncodedCatchHandler[handlerCount];
            for (int i = 0; i < handlerCount; ++i) {
                try {
                    int position = in.getCursor() - encodedHandlerStart;
                    this.encodedCatchHandlers[i] = new EncodedCatchHandler(this.dexFile, in);
                    handlerMap.append(position, this.encodedCatchHandlers[i]);
                    continue;
                }
                catch (Exception ex) {
                    throw ExceptionWithContext.withContext(ex, "Error while reading EncodedCatchHandler at index " + i);
                }
            }
            int codeItemEnd = in.getCursor();
            in.setCursor(triesOffset);
            this.tries = new TryItem[triesCount];
            for (int i = 0; i < triesCount; ++i) {
                try {
                    this.tries[i] = new TryItem(in, handlerMap);
                    continue;
                }
                catch (Exception ex) {
                    throw ExceptionWithContext.withContext(ex, "Error while reading TryItem at index " + i);
                }
            }
            in.setCursor(codeItemEnd);
        }
    }

    @Override
    protected int placeItem(int offset) {
        offset += 16 + this.getInstructionsLength() * 2;
        if (this.tries != null && this.tries.length > 0) {
            offset = AlignmentUtils.alignOffset(offset, 4);
            int encodedCatchHandlerBaseOffset = offset += this.tries.length * 8;
            offset += Leb128Utils.unsignedLeb128Size(this.encodedCatchHandlers.length);
            for (EncodedCatchHandler encodedCatchHandler : this.encodedCatchHandlers) {
                offset = encodedCatchHandler.place(offset, encodedCatchHandlerBaseOffset);
            }
        }
        return offset;
    }

    @Override
    protected void writeItem(AnnotatedOutput out) {
        block16: {
            int instructionsLength = this.getInstructionsLength();
            if (out.annotates()) {
                out.annotate(0, this.parent.method.getMethodString());
                out.annotate(2, "registers_size: 0x" + Integer.toHexString(this.registerCount) + " (" + this.registerCount + ")");
                out.annotate(2, "ins_size: 0x" + Integer.toHexString(this.inWords) + " (" + this.inWords + ")");
                out.annotate(2, "outs_size: 0x" + Integer.toHexString(this.outWords) + " (" + this.outWords + ")");
                int triesLength = this.tries == null ? 0 : this.tries.length;
                out.annotate(2, "tries_size: 0x" + Integer.toHexString(triesLength) + " (" + triesLength + ")");
                if (this.debugInfo == null) {
                    out.annotate(4, "debug_info_off:");
                } else {
                    out.annotate(4, "debug_info_off: 0x" + this.debugInfo.getOffset());
                }
                out.annotate(4, "insns_size: 0x" + Integer.toHexString(instructionsLength) + " (" + instructionsLength + ")");
            }
            out.writeShort(this.registerCount);
            out.writeShort(this.inWords);
            out.writeShort(this.outWords);
            if (this.tries == null) {
                out.writeShort(0);
            } else {
                out.writeShort(this.tries.length);
            }
            if (this.debugInfo == null) {
                out.writeInt(0);
            } else {
                out.writeInt(this.debugInfo.getOffset());
            }
            out.writeInt(instructionsLength);
            int currentCodeAddress = 0;
            for (Instruction instruction : this.instructions) {
                currentCodeAddress = instruction.write(out, currentCodeAddress);
            }
            if (this.tries == null || this.tries.length <= 0) break block16;
            if (out.annotates()) {
                if (currentCodeAddress % 2 != 0) {
                    out.annotate("padding");
                    out.writeShort(0);
                }
                int index = 0;
                for (TryItem tryItem : this.tries) {
                    out.annotate(0, "[0x" + Integer.toHexString(index++) + "] try_item");
                    out.indent();
                    tryItem.writeTo(out);
                    out.deindent();
                }
                out.annotate("handler_count: 0x" + Integer.toHexString(this.encodedCatchHandlers.length) + "(" + this.encodedCatchHandlers.length + ")");
                out.writeUnsignedLeb128(this.encodedCatchHandlers.length);
                index = 0;
                for (EncodedCatchHandler encodedCatchHandler : this.encodedCatchHandlers) {
                    out.annotate(0, "[" + Integer.toHexString(index++) + "] encoded_catch_handler");
                    out.indent();
                    encodedCatchHandler.writeTo(out);
                    out.deindent();
                }
            } else {
                if (currentCodeAddress % 2 != 0) {
                    out.writeShort(0);
                }
                for (TryItem tryItem : this.tries) {
                    tryItem.writeTo(out);
                }
                out.writeUnsignedLeb128(this.encodedCatchHandlers.length);
                for (EncodedCatchHandler encodedCatchHandler : this.encodedCatchHandlers) {
                    encodedCatchHandler.writeTo(out);
                }
            }
        }
    }

    @Override
    public ItemType getItemType() {
        return ItemType.TYPE_CODE_ITEM;
    }

    @Override
    public String getConciseIdentity() {
        if (this.parent == null) {
            return "code_item @0x" + Integer.toHexString(this.getOffset());
        }
        return "code_item @0x" + Integer.toHexString(this.getOffset()) + " (" + this.parent.method.getMethodString() + ")";
    }

    @Override
    public int compareTo(CodeItem other) {
        if (this.parent == null) {
            if (other.parent == null) {
                return 0;
            }
            return -1;
        }
        if (other.parent == null) {
            return 1;
        }
        return this.parent.method.compareTo(other.parent.method);
    }

    public int getRegisterCount() {
        return this.registerCount;
    }

    public Instruction[] getInstructions() {
        return this.instructions;
    }

    public TryItem[] getTries() {
        return this.tries;
    }

    public EncodedCatchHandler[] getHandlers() {
        return this.encodedCatchHandlers;
    }

    public DebugInfoItem getDebugInfo() {
        return this.debugInfo;
    }

    protected void setParent(ClassDataItem.EncodedMethod encodedMethod) {
        this.parent = encodedMethod;
    }

    public ClassDataItem.EncodedMethod getParent() {
        return this.parent;
    }

    public void updateCode(Instruction[] newInstructions) {
        this.instructions = newInstructions;
    }

    private int getInstructionsLength() {
        int currentCodeAddress = 0;
        for (Instruction instruction : this.instructions) {
            currentCodeAddress += instruction.getSize(currentCodeAddress);
        }
        return currentCodeAddress;
    }

    public void fixInstructions(boolean fixStringConst, boolean fixGoto) {
        try {
            boolean didSomething = false;
            block4: do {
                didSomething = false;
                int currentCodeAddress = 0;
                for (int i = 0; i < this.instructions.length; ++i) {
                    Instruction instruction = this.instructions[i];
                    try {
                        Instruction21c constStringInstruction;
                        if (fixGoto && instruction.opcode == Opcode.GOTO) {
                            int codeAddress = ((OffsetInstruction)((Object)instruction)).getTargetAddressOffset();
                            if ((byte)codeAddress != codeAddress) {
                                if ((short)codeAddress == codeAddress) {
                                    this.replaceInstructionAtAddress(currentCodeAddress, new Instruction20t(Opcode.GOTO_16, codeAddress));
                                } else {
                                    this.replaceInstructionAtAddress(currentCodeAddress, new Instruction30t(Opcode.GOTO_32, codeAddress));
                                }
                                didSomething = true;
                                continue block4;
                            }
                        } else if (fixGoto && instruction.opcode == Opcode.GOTO_16) {
                            int codeAddress = ((OffsetInstruction)((Object)instruction)).getTargetAddressOffset();
                            if ((short)codeAddress != codeAddress) {
                                this.replaceInstructionAtAddress(currentCodeAddress, new Instruction30t(Opcode.GOTO_32, codeAddress));
                                didSomething = true;
                                continue block4;
                            }
                        } else if (fixStringConst && instruction.opcode == Opcode.CONST_STRING && (constStringInstruction = (Instruction21c)instruction).getReferencedItem().getIndex() > 65535) {
                            this.replaceInstructionAtAddress(currentCodeAddress, new Instruction31c(Opcode.CONST_STRING_JUMBO, (short)constStringInstruction.getRegisterA(), constStringInstruction.getReferencedItem()));
                            didSomething = true;
                            continue block4;
                        }
                        currentCodeAddress += instruction.getSize(currentCodeAddress);
                        continue;
                    }
                    catch (Exception ex) {
                        throw ExceptionWithContext.withContext(ex, "Error while attempting to fix " + instruction.opcode.name + " instruction at address " + currentCodeAddress);
                    }
                }
            } while (didSomething);
        }
        catch (Exception ex) {
            throw this.addExceptionContext(ex);
        }
    }

    private void replaceInstructionAtAddress(int codeAddress, Instruction replacementInstruction) {
        int i;
        Instruction originalInstruction = null;
        int[] originalInstructionCodeAddresses = new int[this.instructions.length + 1];
        SparseIntArray originalSwitchAddressByOriginalSwitchDataAddress = new SparseIntArray();
        int currentCodeAddress = 0;
        int instructionIndex = 0;
        for (i = 0; i < this.instructions.length; ++i) {
            OffsetInstruction offsetInstruction;
            int switchDataAddress;
            Instruction instruction = this.instructions[i];
            if (currentCodeAddress == codeAddress) {
                originalInstruction = instruction;
                instructionIndex = i;
            }
            if ((instruction.opcode == Opcode.PACKED_SWITCH || instruction.opcode == Opcode.SPARSE_SWITCH) && originalSwitchAddressByOriginalSwitchDataAddress.indexOfKey(switchDataAddress = currentCodeAddress + (offsetInstruction = (OffsetInstruction)((Object)instruction)).getTargetAddressOffset()) < 0) {
                originalSwitchAddressByOriginalSwitchDataAddress.put(switchDataAddress, currentCodeAddress);
            }
            originalInstructionCodeAddresses[i] = currentCodeAddress;
            currentCodeAddress += instruction.getSize(currentCodeAddress);
        }
        originalInstructionCodeAddresses[i] = currentCodeAddress;
        if (originalInstruction == null) {
            throw new RuntimeException("There is no instruction at address " + codeAddress);
        }
        this.instructions[instructionIndex] = replacementInstruction;
        if (originalInstruction.getSize(codeAddress) == replacementInstruction.getSize(codeAddress)) {
            return;
        }
        SparseIntArray originalAddressByNewAddress = new SparseIntArray();
        SparseIntArray newAddressByOriginalAddress = new SparseIntArray();
        currentCodeAddress = 0;
        for (i = 0; i < this.instructions.length; ++i) {
            Instruction instruction = this.instructions[i];
            int originalAddress = originalInstructionCodeAddresses[i];
            originalAddressByNewAddress.append(currentCodeAddress, originalAddress);
            newAddressByOriginalAddress.append(originalAddress, currentCodeAddress);
            currentCodeAddress += instruction.getSize(currentCodeAddress);
        }
        originalAddressByNewAddress.append(currentCodeAddress, originalInstructionCodeAddresses[i]);
        newAddressByOriginalAddress.append(originalInstructionCodeAddresses[i], currentCodeAddress);
        currentCodeAddress = 0;
        for (i = 0; i < this.instructions.length; ++i) {
            Instruction instruction = this.instructions[i];
            if (instruction instanceof OffsetInstruction) {
                OffsetInstruction offsetInstruction = (OffsetInstruction)((Object)instruction);
                assert (originalAddressByNewAddress.indexOfKey(currentCodeAddress) >= 0);
                int originalAddress = originalAddressByNewAddress.get(currentCodeAddress);
                int originalInstructionTarget = originalAddress + offsetInstruction.getTargetAddressOffset();
                assert (newAddressByOriginalAddress.indexOfKey(originalInstructionTarget) >= 0);
                int newInstructionTarget = newAddressByOriginalAddress.get(originalInstructionTarget);
                int newCodeAddress = newInstructionTarget - currentCodeAddress;
                if (newCodeAddress != offsetInstruction.getTargetAddressOffset()) {
                    offsetInstruction.updateTargetAddressOffset(newCodeAddress);
                }
            } else if (instruction instanceof MultiOffsetInstruction) {
                MultiOffsetInstruction multiOffsetInstruction = (MultiOffsetInstruction)((Object)instruction);
                assert (originalAddressByNewAddress.indexOfKey(currentCodeAddress) >= 0);
                int originalDataAddress = originalAddressByNewAddress.get(currentCodeAddress);
                int originalSwitchAddress = originalSwitchAddressByOriginalSwitchDataAddress.get(originalDataAddress, -1);
                if (originalSwitchAddress == -1) {
                    throw new RuntimeException("This method contains an unreferenced switch data block at address " + currentCodeAddress + " and can't be automatically fixed.");
                }
                assert (newAddressByOriginalAddress.indexOfKey(originalSwitchAddress) >= 0);
                int newSwitchAddress = newAddressByOriginalAddress.get(originalSwitchAddress);
                int[] targets = multiOffsetInstruction.getTargets();
                for (int t = 0; t < targets.length; ++t) {
                    int originalTargetCodeAddress = originalSwitchAddress + targets[t];
                    assert (newAddressByOriginalAddress.indexOfKey(originalTargetCodeAddress) >= 0);
                    int newTargetCodeAddress = newAddressByOriginalAddress.get(originalTargetCodeAddress);
                    int newCodeAddress = newTargetCodeAddress - newSwitchAddress;
                    if (newCodeAddress == targets[t]) continue;
                    multiOffsetInstruction.updateTarget(t, newCodeAddress);
                }
            }
            currentCodeAddress += instruction.getSize(currentCodeAddress);
        }
        if (this.debugInfo != null) {
            byte[] encodedDebugInfo = this.debugInfo.getEncodedDebugInfo();
            ByteArrayInput debugInput = new ByteArrayInput(encodedDebugInfo);
            DebugInstructionFixer debugInstructionFixer = new DebugInstructionFixer(encodedDebugInfo, newAddressByOriginalAddress);
            DebugInstructionIterator.IterateInstructions(debugInput, debugInstructionFixer);
            if (debugInstructionFixer.result != null) {
                this.debugInfo.setEncodedDebugInfo(debugInstructionFixer.result);
            }
        }
        if (this.encodedCatchHandlers != null) {
            for (EncodedCatchHandler encodedCatchHandler : this.encodedCatchHandlers) {
                if (encodedCatchHandler.catchAllHandlerAddress != -1) {
                    assert (newAddressByOriginalAddress.indexOfKey(encodedCatchHandler.catchAllHandlerAddress) >= 0);
                    encodedCatchHandler.catchAllHandlerAddress = newAddressByOriginalAddress.get(encodedCatchHandler.catchAllHandlerAddress);
                }
                for (EncodedTypeAddrPair handler : encodedCatchHandler.handlers) {
                    assert (newAddressByOriginalAddress.indexOfKey(handler.handlerAddress) >= 0);
                    handler.handlerAddress = newAddressByOriginalAddress.get(handler.handlerAddress);
                }
            }
        }
        if (this.tries != null) {
            for (TryItem tryItem : this.tries) {
                int startAddress = tryItem.startCodeAddress;
                int endAddress = tryItem.startCodeAddress + tryItem.tryLength;
                assert (newAddressByOriginalAddress.indexOfKey(startAddress) >= 0);
                tryItem.startCodeAddress = newAddressByOriginalAddress.get(startAddress);
                assert (newAddressByOriginalAddress.indexOfKey(endAddress) >= 0);
                tryItem.tryLength = newAddressByOriginalAddress.get(endAddress) - tryItem.startCodeAddress;
            }
        }
    }

    public static class EncodedTypeAddrPair {
        public final TypeIdItem exceptionType;
        private int handlerAddress;

        public EncodedTypeAddrPair(TypeIdItem exceptionType, int handlerAddress) {
            this.exceptionType = exceptionType;
            this.handlerAddress = handlerAddress;
        }

        private EncodedTypeAddrPair(DexFile dexFile, Input in) {
            this.exceptionType = dexFile.TypeIdsSection.getItemByIndex(in.readUnsignedLeb128());
            this.handlerAddress = in.readUnsignedLeb128();
        }

        private int getSize() {
            return Leb128Utils.unsignedLeb128Size(this.exceptionType.getIndex()) + Leb128Utils.unsignedLeb128Size(this.handlerAddress);
        }

        private void writeTo(AnnotatedOutput out) {
            if (out.annotates()) {
                out.annotate("exception_type: " + this.exceptionType.getTypeDescriptor());
                out.writeUnsignedLeb128(this.exceptionType.getIndex());
                out.annotate("handler_addr: 0x" + Integer.toHexString(this.handlerAddress));
                out.writeUnsignedLeb128(this.handlerAddress);
            } else {
                out.writeUnsignedLeb128(this.exceptionType.getIndex());
                out.writeUnsignedLeb128(this.handlerAddress);
            }
        }

        public int getHandlerAddress() {
            return this.handlerAddress;
        }

        public int hashCode() {
            return this.exceptionType.hashCode() * 31 + this.handlerAddress;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !this.getClass().equals(o.getClass())) {
                return false;
            }
            EncodedTypeAddrPair other = (EncodedTypeAddrPair)o;
            return this.exceptionType == other.exceptionType && this.handlerAddress == other.handlerAddress;
        }
    }

    public static class EncodedCatchHandler {
        public final EncodedTypeAddrPair[] handlers;
        private int catchAllHandlerAddress;
        private int baseOffset;
        private int offset;

        public EncodedCatchHandler(EncodedTypeAddrPair[] handlers, int catchAllHandlerAddress) {
            this.handlers = handlers;
            this.catchAllHandlerAddress = catchAllHandlerAddress;
        }

        private EncodedCatchHandler(DexFile dexFile, Input in) {
            int handlerCount = in.readSignedLeb128();
            this.handlers = handlerCount < 0 ? new EncodedTypeAddrPair[-1 * handlerCount] : new EncodedTypeAddrPair[handlerCount];
            for (int i = 0; i < this.handlers.length; ++i) {
                try {
                    this.handlers[i] = new EncodedTypeAddrPair(dexFile, in);
                    continue;
                }
                catch (Exception ex) {
                    throw ExceptionWithContext.withContext(ex, "Error while reading EncodedTypeAddrPair at index " + i);
                }
            }
            this.catchAllHandlerAddress = handlerCount <= 0 ? in.readUnsignedLeb128() : -1;
        }

        public int getCatchAllHandlerAddress() {
            return this.catchAllHandlerAddress;
        }

        private int getOffsetInList() {
            return this.offset - this.baseOffset;
        }

        private int place(int offset, int baseOffset) {
            this.offset = offset;
            this.baseOffset = baseOffset;
            int size = this.handlers.length;
            if (this.catchAllHandlerAddress > -1) {
                size *= -1;
                offset += Leb128Utils.unsignedLeb128Size(this.catchAllHandlerAddress);
            }
            offset += Leb128Utils.signedLeb128Size(size);
            for (EncodedTypeAddrPair handler : this.handlers) {
                offset += handler.getSize();
            }
            return offset;
        }

        private void writeTo(AnnotatedOutput out) {
            if (out.annotates()) {
                out.annotate("size: 0x" + Integer.toHexString(this.handlers.length) + " (" + this.handlers.length + ")");
                int size = this.handlers.length;
                if (this.catchAllHandlerAddress > -1) {
                    size *= -1;
                }
                out.writeSignedLeb128(size);
                int index = 0;
                for (EncodedTypeAddrPair handler : this.handlers) {
                    out.annotate(0, "[" + index++ + "] encoded_type_addr_pair");
                    out.indent();
                    handler.writeTo(out);
                    out.deindent();
                }
                if (this.catchAllHandlerAddress > -1) {
                    out.annotate("catch_all_addr: 0x" + Integer.toHexString(this.catchAllHandlerAddress));
                    out.writeUnsignedLeb128(this.catchAllHandlerAddress);
                }
            } else {
                int size = this.handlers.length;
                if (this.catchAllHandlerAddress > -1) {
                    size *= -1;
                }
                out.writeSignedLeb128(size);
                for (EncodedTypeAddrPair handler : this.handlers) {
                    handler.writeTo(out);
                }
                if (this.catchAllHandlerAddress > -1) {
                    out.writeUnsignedLeb128(this.catchAllHandlerAddress);
                }
            }
        }

        public int hashCode() {
            int hash = 0;
            for (EncodedTypeAddrPair handler : this.handlers) {
                hash = hash * 31 + handler.hashCode();
            }
            hash = hash * 31 + this.catchAllHandlerAddress;
            return hash;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !this.getClass().equals(o.getClass())) {
                return false;
            }
            EncodedCatchHandler other = (EncodedCatchHandler)o;
            if (this.handlers.length != other.handlers.length || this.catchAllHandlerAddress != other.catchAllHandlerAddress) {
                return false;
            }
            for (int i = 0; i < this.handlers.length; ++i) {
                if (this.handlers[i].equals(other.handlers[i])) continue;
                return false;
            }
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TryItem {
        private int startCodeAddress;
        private int tryLength;
        public final EncodedCatchHandler encodedCatchHandler;

        public TryItem(int startCodeAddress, int tryLength, EncodedCatchHandler encodedCatchHandler) {
            this.startCodeAddress = startCodeAddress;
            this.tryLength = tryLength;
            this.encodedCatchHandler = encodedCatchHandler;
        }

        private TryItem(Input in, SparseArray<EncodedCatchHandler> encodedCatchHandlers) {
            this.startCodeAddress = in.readInt();
            this.tryLength = in.readShort();
            this.encodedCatchHandler = encodedCatchHandlers.get(in.readShort());
            if (this.encodedCatchHandler == null) {
                throw new RuntimeException("Could not find the EncodedCatchHandler referenced by this TryItem");
            }
        }

        private void writeTo(AnnotatedOutput out) {
            if (out.annotates()) {
                out.annotate(4, "start_addr: 0x" + Integer.toHexString(this.startCodeAddress));
                out.annotate(2, "try_length: 0x" + Integer.toHexString(this.tryLength) + " (" + this.tryLength + ")");
                out.annotate(2, "handler_off: 0x" + Integer.toHexString(this.encodedCatchHandler.getOffsetInList()));
            }
            out.writeInt(this.startCodeAddress);
            out.writeShort(this.tryLength);
            out.writeShort(this.encodedCatchHandler.getOffsetInList());
        }

        public int getStartCodeAddress() {
            return this.startCodeAddress;
        }

        public int getTryLength() {
            return this.tryLength;
        }
    }

    private class DebugInstructionFixer
    extends DebugInstructionIterator.ProcessRawDebugInstructionDelegate {
        private int currentCodeAddress = 0;
        private SparseIntArray newAddressByOriginalAddress;
        private final byte[] originalEncodedDebugInfo;
        public byte[] result = null;

        public DebugInstructionFixer(byte[] originalEncodedDebugInfo, SparseIntArray newAddressByOriginalAddress) {
            this.newAddressByOriginalAddress = newAddressByOriginalAddress;
            this.originalEncodedDebugInfo = originalEncodedDebugInfo;
        }

        public void ProcessAdvancePC(int startDebugOffset, int debugInstructionLength, int codeAddressDelta) {
            this.currentCodeAddress += codeAddressDelta;
            if (this.result != null) {
                return;
            }
            int newCodeAddress = this.newAddressByOriginalAddress.get(this.currentCodeAddress, -1);
            if (newCodeAddress == -1) {
                return;
            }
            if (newCodeAddress != this.currentCodeAddress) {
                int newCodeAddressDelta = newCodeAddress - (this.currentCodeAddress - codeAddressDelta);
                assert (newCodeAddressDelta > 0);
                int codeAddressDeltaLeb128Size = Leb128Utils.unsignedLeb128Size(newCodeAddressDelta);
                if (codeAddressDeltaLeb128Size + 1 == debugInstructionLength) {
                    this.result = this.originalEncodedDebugInfo;
                    Leb128Utils.writeUnsignedLeb128(newCodeAddressDelta, this.result, startDebugOffset + 1);
                } else {
                    this.result = new byte[this.originalEncodedDebugInfo.length + codeAddressDeltaLeb128Size - (debugInstructionLength - 1)];
                    System.arraycopy(this.originalEncodedDebugInfo, 0, this.result, 0, startDebugOffset);
                    this.result[startDebugOffset] = DebugOpcode.DBG_ADVANCE_PC.value;
                    Leb128Utils.writeUnsignedLeb128(newCodeAddressDelta, this.result, startDebugOffset + 1);
                    System.arraycopy(this.originalEncodedDebugInfo, startDebugOffset + debugInstructionLength, this.result, startDebugOffset + codeAddressDeltaLeb128Size + 1, this.originalEncodedDebugInfo.length - (startDebugOffset + codeAddressDeltaLeb128Size + 1));
                }
            }
        }

        public void ProcessSpecialOpcode(int startDebugOffset, int debugOpcode, int lineDelta, int codeAddressDelta) {
            this.currentCodeAddress += codeAddressDelta;
            if (this.result != null) {
                return;
            }
            int newCodeAddress = this.newAddressByOriginalAddress.get(this.currentCodeAddress, -1);
            assert (newCodeAddress != -1);
            if (newCodeAddress != this.currentCodeAddress) {
                int newCodeAddressDelta = newCodeAddress - (this.currentCodeAddress - codeAddressDelta);
                assert (newCodeAddressDelta > 0);
                if (lineDelta < 2 && newCodeAddressDelta > 16 || lineDelta > 1 && newCodeAddressDelta > 15) {
                    int additionalCodeAddressDelta = newCodeAddress - this.currentCodeAddress;
                    int additionalCodeAddressDeltaLeb128Size = Leb128Utils.signedLeb128Size(additionalCodeAddressDelta);
                    this.result = new byte[this.originalEncodedDebugInfo.length + additionalCodeAddressDeltaLeb128Size + 1];
                    System.arraycopy(this.originalEncodedDebugInfo, 0, this.result, 0, startDebugOffset);
                    this.result[startDebugOffset] = 1;
                    Leb128Utils.writeUnsignedLeb128(additionalCodeAddressDelta, this.result, startDebugOffset + 1);
                    System.arraycopy(this.originalEncodedDebugInfo, startDebugOffset, this.result, startDebugOffset + additionalCodeAddressDeltaLeb128Size + 1, this.result.length - (startDebugOffset + additionalCodeAddressDeltaLeb128Size + 1));
                } else {
                    this.result = this.originalEncodedDebugInfo;
                    this.result[startDebugOffset] = DebugInfoBuilder.calculateSpecialOpcode(lineDelta, newCodeAddressDelta);
                }
            }
        }
    }
}

