/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.svg;

import org.apache.batik.dom.svg.AbstractElement;
import org.apache.batik.dom.svg.AbstractSVGLength;
import org.apache.batik.dom.svg.LiveAttributeValue;
import org.apache.batik.dom.svg.SVGOMElement;
import org.w3c.dom.Attr;
import org.w3c.dom.svg.SVGAnimatedLength;
import org.w3c.dom.svg.SVGLength;

public abstract class AbstractSVGAnimatedLength
implements SVGAnimatedLength,
LiveAttributeValue {
    public static final short HORIZONTAL_LENGTH = 2;
    public static final short VERTICAL_LENGTH = 1;
    public static final short OTHER_LENGTH = 0;
    protected AbstractElement element;
    protected String namespaceURI;
    protected String localName;
    protected short direction;
    protected BaseSVGLength baseVal;
    protected boolean changing;

    protected AbstractSVGAnimatedLength(AbstractElement elt, String ns, String ln, short dir) {
        this.element = elt;
        this.namespaceURI = ns;
        this.localName = ln;
        this.direction = dir;
    }

    protected abstract String getDefaultValue();

    public SVGLength getBaseVal() {
        if (this.baseVal == null) {
            this.baseVal = new BaseSVGLength(this.direction);
        }
        return this.baseVal;
    }

    public SVGLength getAnimVal() {
        throw new RuntimeException("!!! TODO: getAnimVal()");
    }

    public void attrAdded(Attr node, String newv) {
        if (!this.changing && this.baseVal != null) {
            this.baseVal.invalidate();
        }
    }

    public void attrModified(Attr node, String oldv, String newv) {
        if (!this.changing && this.baseVal != null) {
            this.baseVal.invalidate();
        }
    }

    public void attrRemoved(Attr node, String oldv) {
        if (!this.changing && this.baseVal != null) {
            this.baseVal.invalidate();
        }
    }

    protected class BaseSVGLength
    extends AbstractSVGLength {
        protected boolean valid;

        public BaseSVGLength(short direction) {
            super(direction);
        }

        public void invalidate() {
            this.valid = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void reset() {
            try {
                AbstractSVGAnimatedLength.this.changing = true;
                String value = this.getValueAsString();
                AbstractSVGAnimatedLength.this.element.setAttributeNS(AbstractSVGAnimatedLength.this.namespaceURI, AbstractSVGAnimatedLength.this.localName, value);
            }
            finally {
                AbstractSVGAnimatedLength.this.changing = false;
            }
        }

        protected void revalidate() {
            if (this.valid) {
                return;
            }
            String s = null;
            Attr attr = AbstractSVGAnimatedLength.this.element.getAttributeNodeNS(AbstractSVGAnimatedLength.this.namespaceURI, AbstractSVGAnimatedLength.this.localName);
            s = attr == null ? AbstractSVGAnimatedLength.this.getDefaultValue() : attr.getValue();
            this.parse(s);
            this.valid = true;
        }

        protected SVGOMElement getAssociatedElement() {
            return (SVGOMElement)AbstractSVGAnimatedLength.this.element;
        }
    }
}

