/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.svg;

import org.apache.batik.css.engine.CSSEngine;
import org.apache.batik.css.engine.CSSStylableElement;
import org.apache.batik.dom.AbstractDocument;
import org.apache.batik.dom.svg.AbstractElement;
import org.apache.batik.dom.svg.LiveAttributeValue;
import org.apache.batik.dom.svg.SVGContext;
import org.apache.batik.dom.svg.SVGOMAnimatedEnumeration;
import org.apache.batik.dom.svg.SVGOMAnimatedInteger;
import org.apache.batik.dom.svg.SVGOMAnimatedLength;
import org.apache.batik.dom.svg.SVGOMAnimatedNumber;
import org.apache.batik.dom.svg.SVGOMAnimatedString;
import org.apache.batik.dom.svg.SVGOMException;
import org.apache.batik.dom.svg.XMLBaseSupport;
import org.apache.batik.dom.util.DOMUtilities;
import org.apache.batik.util.SVGConstants;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.svg.SVGAnimatedEnumeration;
import org.w3c.dom.svg.SVGAnimatedInteger;
import org.w3c.dom.svg.SVGAnimatedLength;
import org.w3c.dom.svg.SVGAnimatedNumber;
import org.w3c.dom.svg.SVGAnimatedString;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGException;
import org.w3c.dom.svg.SVGFitToViewBox;
import org.w3c.dom.svg.SVGSVGElement;

public abstract class SVGOMElement
extends AbstractElement
implements SVGElement,
SVGConstants {
    protected transient boolean readonly;
    protected String prefix;
    protected transient SVGContext svgContext;

    protected SVGOMElement() {
    }

    protected SVGOMElement(String prefix, AbstractDocument owner) {
        super(prefix, owner);
    }

    public String getId() {
        return this.getAttributeNS(null, "id");
    }

    public void setId(String id) {
        this.setAttributeNS(null, "id", id);
    }

    public String getXMLbase() {
        return XMLBaseSupport.getXMLBase((Element)((Object)this));
    }

    public void setXMLbase(String xmlbase) throws DOMException {
        this.setAttributeNS("http://www.w3.org/XML/1998/namespace", "xml:base", xmlbase);
    }

    public SVGSVGElement getOwnerSVGElement() {
        CSSStylableElement e = CSSEngine.getParentCSSStylableElement((Element)((Object)this));
        while (e != null) {
            if (e instanceof SVGSVGElement) {
                return (SVGSVGElement)e;
            }
            e = CSSEngine.getParentCSSStylableElement((Element)e);
        }
        return null;
    }

    public SVGElement getViewportElement() {
        CSSStylableElement e = CSSEngine.getParentCSSStylableElement((Element)((Object)this));
        while (e != null) {
            if (e instanceof SVGFitToViewBox) {
                return (SVGElement)e;
            }
            e = CSSEngine.getParentCSSStylableElement((Element)e);
        }
        return null;
    }

    public String getNodeName() {
        if (this.prefix == null || this.prefix.equals("")) {
            return this.getLocalName();
        }
        String ln = this.getLocalName();
        StringBuffer sb = new StringBuffer(this.prefix.length() + ln.length() + 1);
        sb.append(this.prefix).append(':').append(ln);
        return sb.toString();
    }

    public String getNamespaceURI() {
        return "http://www.w3.org/2000/svg";
    }

    public void setPrefix(String prefix) throws DOMException {
        if (this.isReadonly()) {
            throw this.createDOMException((short)7, "readonly.node", new Object[]{new Integer(this.getNodeType()), this.getNodeName()});
        }
        if (prefix != null && !prefix.equals("") && !DOMUtilities.isValidName((String)prefix)) {
            throw this.createDOMException((short)5, "prefix", new Object[]{new Integer(this.getNodeType()), this.getNodeName(), prefix});
        }
        this.prefix = prefix;
    }

    public void setSVGContext(SVGContext ctx) {
        this.svgContext = ctx;
    }

    public SVGContext getSVGContext() {
        return this.svgContext;
    }

    public SVGException createSVGException(short type, String key, Object[] args) {
        try {
            return new SVGOMException(type, this.getCurrentDocument().formatMessage(key, args));
        }
        catch (Exception e) {
            return new SVGOMException(type, key);
        }
    }

    public boolean isReadonly() {
        return this.readonly;
    }

    public void setReadonly(boolean v) {
        this.readonly = v;
    }

    protected SVGAnimatedString getAnimatedStringAttribute(String ns, String ln) {
        SVGAnimatedString result = (SVGAnimatedString)this.getLiveAttributeValue(ns, ln);
        if (result == null) {
            result = new SVGOMAnimatedString(this, ns, ln);
            this.putLiveAttributeValue(ns, ln, (LiveAttributeValue)result);
        }
        return result;
    }

    protected SVGAnimatedNumber getAnimatedNumberAttribute(String ns, String ln, float val) {
        SVGAnimatedNumber result = (SVGAnimatedNumber)this.getLiveAttributeValue(ns, ln);
        if (result == null) {
            result = new SVGOMAnimatedNumber(this, ns, ln, val);
            this.putLiveAttributeValue(ns, ln, (LiveAttributeValue)result);
        }
        return result;
    }

    protected SVGAnimatedInteger getAnimatedIntegerAttribute(String ns, String ln, int val) {
        SVGAnimatedInteger result = (SVGAnimatedInteger)this.getLiveAttributeValue(ns, ln);
        if (result == null) {
            result = new SVGOMAnimatedInteger(this, ns, ln, val);
            this.putLiveAttributeValue(ns, ln, (LiveAttributeValue)result);
        }
        return result;
    }

    protected SVGAnimatedEnumeration getAnimatedEnumerationAttribute(String ns, String ln, String[] val, short def) {
        SVGAnimatedEnumeration result = (SVGAnimatedEnumeration)this.getLiveAttributeValue(ns, ln);
        if (result == null) {
            result = new SVGOMAnimatedEnumeration(this, ns, ln, val, def);
            this.putLiveAttributeValue(ns, ln, (LiveAttributeValue)result);
        }
        return result;
    }

    protected SVGAnimatedLength getAnimatedLengthAttribute(String ns, String ln, String val, short dir) {
        SVGAnimatedLength result = (SVGAnimatedLength)this.getLiveAttributeValue(ns, ln);
        if (result == null) {
            result = new SVGOMAnimatedLength(this, ns, ln, val, dir);
            this.putLiveAttributeValue(ns, ln, (LiveAttributeValue)result);
        }
        return result;
    }

    protected Node export(Node n, AbstractDocument d) {
        super.export(n, d);
        SVGOMElement e = (SVGOMElement)((Object)n);
        e.prefix = this.prefix;
        return n;
    }

    protected Node deepExport(Node n, AbstractDocument d) {
        super.deepExport(n, d);
        SVGOMElement e = (SVGOMElement)((Object)n);
        e.prefix = this.prefix;
        return n;
    }

    protected Node copyInto(Node n) {
        super.copyInto(n);
        SVGOMElement e = (SVGOMElement)((Object)n);
        e.prefix = this.prefix;
        return n;
    }

    protected Node deepCopyInto(Node n) {
        super.deepCopyInto(n);
        SVGOMElement e = (SVGOMElement)((Object)n);
        e.prefix = this.prefix;
        return n;
    }
}

