/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib.Code.Format;

import org.jf.dexlib.Code.Format.Format;
import org.jf.dexlib.Code.Instruction;
import org.jf.dexlib.Code.OffsetInstruction;
import org.jf.dexlib.Code.Opcode;
import org.jf.dexlib.DexFile;
import org.jf.dexlib.Util.AnnotatedOutput;
import org.jf.dexlib.Util.NumberUtils;

public class Instruction20t
extends Instruction
implements OffsetInstruction {
    public static final Instruction.InstructionFactory Factory = new Factory();
    private int targetAddressOffset;

    public Instruction20t(Opcode opcode, int offA) {
        super(opcode);
        this.targetAddressOffset = offA;
        if (this.targetAddressOffset == 0) {
            throw new RuntimeException("The address offset cannot be 0. Use goto/32 instead.");
        }
    }

    private Instruction20t(Opcode opcode, byte[] buffer, int bufferIndex) {
        super(opcode);
        assert (buffer[bufferIndex] == opcode.value);
        this.targetAddressOffset = NumberUtils.decodeShort(buffer, bufferIndex + 2);
        assert (this.targetAddressOffset != 0);
    }

    protected void writeInstruction(AnnotatedOutput out, int currentCodeAddress) {
        if (this.targetAddressOffset == 0) {
            throw new RuntimeException("The address offset cannot be 0. Use goto/32 instead");
        }
        if (this.targetAddressOffset < Short.MIN_VALUE || this.targetAddressOffset > Short.MAX_VALUE) {
            throw new RuntimeException("The address offset is out of range. It must be in [-32768,-1] or [1, 32768]");
        }
        out.writeByte(this.opcode.value);
        out.writeByte(0);
        out.writeShort(this.targetAddressOffset);
    }

    public void updateTargetAddressOffset(int targetAddressOffset) {
        this.targetAddressOffset = targetAddressOffset;
    }

    public Format getFormat() {
        return Format.Format20t;
    }

    public int getTargetAddressOffset() {
        return this.targetAddressOffset;
    }

    private static class Factory
    implements Instruction.InstructionFactory {
        private Factory() {
        }

        public Instruction makeInstruction(DexFile dexFile, Opcode opcode, byte[] buffer, int bufferIndex) {
            return new Instruction20t(opcode, buffer, bufferIndex);
        }
    }
}

