/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib.Code;

import java.util.HashMap;
import org.jf.dexlib.Code.Format.Format;
import org.jf.dexlib.Code.ReferenceType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Opcode {
    NOP(0, "nop", ReferenceType.none, Format.Format10x, 4),
    MOVE(1, "move", ReferenceType.none, Format.Format12x, 20),
    MOVE_FROM16(2, "move/from16", ReferenceType.none, Format.Format22x, 20),
    MOVE_16(3, "move/16", ReferenceType.none, Format.Format32x, 20),
    MOVE_WIDE(4, "move-wide", ReferenceType.none, Format.Format12x, 52),
    MOVE_WIDE_FROM16(5, "move-wide/from16", ReferenceType.none, Format.Format22x, 52),
    MOVE_WIDE_16(6, "move-wide/16", ReferenceType.none, Format.Format32x, 52),
    MOVE_OBJECT(7, "move-object", ReferenceType.none, Format.Format12x, 20),
    MOVE_OBJECT_FROM16(8, "move-object/from16", ReferenceType.none, Format.Format22x, 20),
    MOVE_OBJECT_16(9, "move-object/16", ReferenceType.none, Format.Format32x, 20),
    MOVE_RESULT(10, "move-result", ReferenceType.none, Format.Format11x, 20),
    MOVE_RESULT_WIDE(11, "move-result-wide", ReferenceType.none, Format.Format11x, 52),
    MOVE_RESULT_OBJECT(12, "move-result-object", ReferenceType.none, Format.Format11x, 20),
    MOVE_EXCEPTION(13, "move-exception", ReferenceType.none, Format.Format11x, 20),
    RETURN_VOID(14, "return-void", ReferenceType.none, Format.Format10x),
    RETURN(15, "return", ReferenceType.none, Format.Format11x),
    RETURN_WIDE(16, "return-wide", ReferenceType.none, Format.Format11x),
    RETURN_OBJECT(17, "return-object", ReferenceType.none, Format.Format11x),
    CONST_4(18, "const/4", ReferenceType.none, Format.Format11n, 20),
    CONST_16(19, "const/16", ReferenceType.none, Format.Format21s, 20),
    CONST(20, "const", ReferenceType.none, Format.Format31i, 20),
    CONST_HIGH16(21, "const/high16", ReferenceType.none, Format.Format21h, 20),
    CONST_WIDE_16(22, "const-wide/16", ReferenceType.none, Format.Format21s, 52),
    CONST_WIDE_32(23, "const-wide/32", ReferenceType.none, Format.Format31i, 52),
    CONST_WIDE(24, "const-wide", ReferenceType.none, Format.Format51l, 52),
    CONST_WIDE_HIGH16(25, "const-wide/high16", ReferenceType.none, Format.Format21h, 52),
    CONST_STRING(26, "const-string", ReferenceType.string, Format.Format21c, 21),
    CONST_STRING_JUMBO(27, "const-string/jumbo", ReferenceType.string, Format.Format31c, 21),
    CONST_CLASS(28, "const-class", ReferenceType.type, Format.Format21c, 21),
    MONITOR_ENTER(29, "monitor-enter", ReferenceType.none, Format.Format11x, 5),
    MONITOR_EXIT(30, "monitor-exit", ReferenceType.none, Format.Format11x, 5),
    CHECK_CAST(31, "check-cast", ReferenceType.type, Format.Format21c, 21),
    INSTANCE_OF(32, "instance-of", ReferenceType.type, Format.Format22c, 21),
    ARRAY_LENGTH(33, "array-length", ReferenceType.none, Format.Format12x, 21),
    NEW_INSTANCE(34, "new-instance", ReferenceType.type, Format.Format21c, 21),
    NEW_ARRAY(35, "new-array", ReferenceType.type, Format.Format22c, 21),
    FILLED_NEW_ARRAY(36, "filled-new-array", ReferenceType.type, Format.Format35c, 13),
    FILLED_NEW_ARRAY_RANGE(37, "filled-new-array/range", ReferenceType.type, Format.Format3rc, 13),
    FILL_ARRAY_DATA(38, "fill-array-data", ReferenceType.none, Format.Format31t, 4),
    THROW(39, "throw", ReferenceType.none, Format.Format11x, 1),
    GOTO(40, "goto", ReferenceType.none, Format.Format10t),
    GOTO_16(41, "goto/16", ReferenceType.none, Format.Format20t),
    GOTO_32(42, "goto/32", ReferenceType.none, Format.Format30t),
    PACKED_SWITCH(43, "packed-switch", ReferenceType.none, Format.Format31t, 4),
    SPARSE_SWITCH(44, "sparse-switch", ReferenceType.none, Format.Format31t, 4),
    CMPL_FLOAT(45, "cmpl-float", ReferenceType.none, Format.Format23x, 20),
    CMPG_FLOAT(46, "cmpg-float", ReferenceType.none, Format.Format23x, 20),
    CMPL_DOUBLE(47, "cmpl-double", ReferenceType.none, Format.Format23x, 20),
    CMPG_DOUBLE(48, "cmpg-double", ReferenceType.none, Format.Format23x, 20),
    CMP_LONG(49, "cmp-long", ReferenceType.none, Format.Format23x, 20),
    IF_EQ(50, "if-eq", ReferenceType.none, Format.Format22t, 4),
    IF_NE(51, "if-ne", ReferenceType.none, Format.Format22t, 4),
    IF_LT(52, "if-lt", ReferenceType.none, Format.Format22t, 4),
    IF_GE(53, "if-ge", ReferenceType.none, Format.Format22t, 4),
    IF_GT(54, "if-gt", ReferenceType.none, Format.Format22t, 4),
    IF_LE(55, "if-le", ReferenceType.none, Format.Format22t, 4),
    IF_EQZ(56, "if-eqz", ReferenceType.none, Format.Format21t, 4),
    IF_NEZ(57, "if-nez", ReferenceType.none, Format.Format21t, 4),
    IF_LTZ(58, "if-ltz", ReferenceType.none, Format.Format21t, 4),
    IF_GEZ(59, "if-gez", ReferenceType.none, Format.Format21t, 4),
    IF_GTZ(60, "if-gtz", ReferenceType.none, Format.Format21t, 4),
    IF_LEZ(61, "if-lez", ReferenceType.none, Format.Format21t, 4),
    AGET(68, "aget", ReferenceType.none, Format.Format23x, 21),
    AGET_WIDE(69, "aget-wide", ReferenceType.none, Format.Format23x, 53),
    AGET_OBJECT(70, "aget-object", ReferenceType.none, Format.Format23x, 21),
    AGET_BOOLEAN(71, "aget-boolean", ReferenceType.none, Format.Format23x, 21),
    AGET_BYTE(72, "aget-byte", ReferenceType.none, Format.Format23x, 21),
    AGET_CHAR(73, "aget-char", ReferenceType.none, Format.Format23x, 21),
    AGET_SHORT(74, "aget-short", ReferenceType.none, Format.Format23x, 21),
    APUT(75, "aput", ReferenceType.none, Format.Format23x, 5),
    APUT_WIDE(76, "aput-wide", ReferenceType.none, Format.Format23x, 5),
    APUT_OBJECT(77, "aput-object", ReferenceType.none, Format.Format23x, 5),
    APUT_BOOLEAN(78, "aput-boolean", ReferenceType.none, Format.Format23x, 5),
    APUT_BYTE(79, "aput-byte", ReferenceType.none, Format.Format23x, 5),
    APUT_CHAR(80, "aput-char", ReferenceType.none, Format.Format23x, 5),
    APUT_SHORT(81, "aput-short", ReferenceType.none, Format.Format23x, 5),
    IGET(82, "iget", ReferenceType.field, Format.Format22c, 21),
    IGET_WIDE(83, "iget-wide", ReferenceType.field, Format.Format22c, 53),
    IGET_OBJECT(84, "iget-object", ReferenceType.field, Format.Format22c, 21),
    IGET_BOOLEAN(85, "iget-boolean", ReferenceType.field, Format.Format22c, 21),
    IGET_BYTE(86, "iget-byte", ReferenceType.field, Format.Format22c, 21),
    IGET_CHAR(87, "iget-char", ReferenceType.field, Format.Format22c, 21),
    IGET_SHORT(88, "iget-short", ReferenceType.field, Format.Format22c, 21),
    IPUT(89, "iput", ReferenceType.field, Format.Format22c, 5),
    IPUT_WIDE(90, "iput-wide", ReferenceType.field, Format.Format22c, 5),
    IPUT_OBJECT(91, "iput-object", ReferenceType.field, Format.Format22c, 5),
    IPUT_BOOLEAN(92, "iput-boolean", ReferenceType.field, Format.Format22c, 5),
    IPUT_BYTE(93, "iput-byte", ReferenceType.field, Format.Format22c, 5),
    IPUT_CHAR(94, "iput-char", ReferenceType.field, Format.Format22c, 5),
    IPUT_SHORT(95, "iput-short", ReferenceType.field, Format.Format22c, 5),
    SGET(96, "sget", ReferenceType.field, Format.Format21c, 21),
    SGET_WIDE(97, "sget-wide", ReferenceType.field, Format.Format21c, 53),
    SGET_OBJECT(98, "sget-object", ReferenceType.field, Format.Format21c, 21),
    SGET_BOOLEAN(99, "sget-boolean", ReferenceType.field, Format.Format21c, 21),
    SGET_BYTE(100, "sget-byte", ReferenceType.field, Format.Format21c, 21),
    SGET_CHAR(101, "sget-char", ReferenceType.field, Format.Format21c, 21),
    SGET_SHORT(102, "sget-short", ReferenceType.field, Format.Format21c, 21),
    SPUT(103, "sput", ReferenceType.field, Format.Format21c, 5),
    SPUT_WIDE(104, "sput-wide", ReferenceType.field, Format.Format21c, 5),
    SPUT_OBJECT(105, "sput-object", ReferenceType.field, Format.Format21c, 5),
    SPUT_BOOLEAN(106, "sput-boolean", ReferenceType.field, Format.Format21c, 5),
    SPUT_BYTE(107, "sput-byte", ReferenceType.field, Format.Format21c, 5),
    SPUT_CHAR(108, "sput-char", ReferenceType.field, Format.Format21c, 5),
    SPUT_SHORT(109, "sput-short", ReferenceType.field, Format.Format21c, 5),
    INVOKE_VIRTUAL(110, "invoke-virtual", ReferenceType.method, Format.Format35c, 13),
    INVOKE_SUPER(111, "invoke-super", ReferenceType.method, Format.Format35c, 13),
    INVOKE_DIRECT(112, "invoke-direct", ReferenceType.method, Format.Format35c, 13),
    INVOKE_STATIC(113, "invoke-static", ReferenceType.method, Format.Format35c, 13),
    INVOKE_INTERFACE(114, "invoke-interface", ReferenceType.method, Format.Format35c, 13),
    INVOKE_VIRTUAL_RANGE(116, "invoke-virtual/range", ReferenceType.method, Format.Format3rc, 13),
    INVOKE_SUPER_RANGE(117, "invoke-super/range", ReferenceType.method, Format.Format3rc, 13),
    INVOKE_DIRECT_RANGE(118, "invoke-direct/range", ReferenceType.method, Format.Format3rc, 13),
    INVOKE_STATIC_RANGE(119, "invoke-static/range", ReferenceType.method, Format.Format3rc, 13),
    INVOKE_INTERFACE_RANGE(120, "invoke-interface/range", ReferenceType.method, Format.Format3rc, 13),
    NEG_INT(123, "neg-int", ReferenceType.none, Format.Format12x, 20),
    NOT_INT(124, "not-int", ReferenceType.none, Format.Format12x, 20),
    NEG_LONG(125, "neg-long", ReferenceType.none, Format.Format12x, 52),
    NOT_LONG(126, "not-long", ReferenceType.none, Format.Format12x, 52),
    NEG_FLOAT(127, "neg-float", ReferenceType.none, Format.Format12x, 20),
    NEG_DOUBLE(-128, "neg-double", ReferenceType.none, Format.Format12x, 52),
    INT_TO_LONG(-127, "int-to-long", ReferenceType.none, Format.Format12x, 52),
    INT_TO_FLOAT(-126, "int-to-float", ReferenceType.none, Format.Format12x, 20),
    INT_TO_DOUBLE(-125, "int-to-double", ReferenceType.none, Format.Format12x, 52),
    LONG_TO_INT(-124, "long-to-int", ReferenceType.none, Format.Format12x, 20),
    LONG_TO_FLOAT(-123, "long-to-float", ReferenceType.none, Format.Format12x, 20),
    LONG_TO_DOUBLE(-122, "long-to-double", ReferenceType.none, Format.Format12x, 52),
    FLOAT_TO_INT(-121, "float-to-int", ReferenceType.none, Format.Format12x, 20),
    FLOAT_TO_LONG(-120, "float-to-long", ReferenceType.none, Format.Format12x, 52),
    FLOAT_TO_DOUBLE(-119, "float-to-double", ReferenceType.none, Format.Format12x, 52),
    DOUBLE_TO_INT(-118, "double-to-int", ReferenceType.none, Format.Format12x, 20),
    DOUBLE_TO_LONG(-117, "double-to-long", ReferenceType.none, Format.Format12x, 52),
    DOUBLE_TO_FLOAT(-116, "double-to-float", ReferenceType.none, Format.Format12x, 20),
    INT_TO_BYTE(-115, "int-to-byte", ReferenceType.none, Format.Format12x, 20),
    INT_TO_CHAR(-114, "int-to-char", ReferenceType.none, Format.Format12x, 20),
    INT_TO_SHORT(-113, "int-to-short", ReferenceType.none, Format.Format12x, 20),
    ADD_INT(-112, "add-int", ReferenceType.none, Format.Format23x, 20),
    SUB_INT(-111, "sub-int", ReferenceType.none, Format.Format23x, 20),
    MUL_INT(-110, "mul-int", ReferenceType.none, Format.Format23x, 20),
    DIV_INT(-109, "div-int", ReferenceType.none, Format.Format23x, 21),
    REM_INT(-108, "rem-int", ReferenceType.none, Format.Format23x, 21),
    AND_INT(-107, "and-int", ReferenceType.none, Format.Format23x, 20),
    OR_INT(-106, "or-int", ReferenceType.none, Format.Format23x, 20),
    XOR_INT(-105, "xor-int", ReferenceType.none, Format.Format23x, 20),
    SHL_INT(-104, "shl-int", ReferenceType.none, Format.Format23x, 20),
    SHR_INT(-103, "shr-int", ReferenceType.none, Format.Format23x, 20),
    USHR_INT(-102, "ushr-int", ReferenceType.none, Format.Format23x, 20),
    ADD_LONG(-101, "add-long", ReferenceType.none, Format.Format23x, 52),
    SUB_LONG(-100, "sub-long", ReferenceType.none, Format.Format23x, 52),
    MUL_LONG(-99, "mul-long", ReferenceType.none, Format.Format23x, 52),
    DIV_LONG(-98, "div-long", ReferenceType.none, Format.Format23x, 53),
    REM_LONG(-97, "rem-long", ReferenceType.none, Format.Format23x, 53),
    AND_LONG(-96, "and-long", ReferenceType.none, Format.Format23x, 52),
    OR_LONG(-95, "or-long", ReferenceType.none, Format.Format23x, 52),
    XOR_LONG(-94, "xor-long", ReferenceType.none, Format.Format23x, 52),
    SHL_LONG(-93, "shl-long", ReferenceType.none, Format.Format23x, 52),
    SHR_LONG(-92, "shr-long", ReferenceType.none, Format.Format23x, 52),
    USHR_LONG(-91, "ushr-long", ReferenceType.none, Format.Format23x, 52),
    ADD_FLOAT(-90, "add-float", ReferenceType.none, Format.Format23x, 20),
    SUB_FLOAT(-89, "sub-float", ReferenceType.none, Format.Format23x, 20),
    MUL_FLOAT(-88, "mul-float", ReferenceType.none, Format.Format23x, 20),
    DIV_FLOAT(-87, "div-float", ReferenceType.none, Format.Format23x, 20),
    REM_FLOAT(-86, "rem-float", ReferenceType.none, Format.Format23x, 20),
    ADD_DOUBLE(-85, "add-double", ReferenceType.none, Format.Format23x, 52),
    SUB_DOUBLE(-84, "sub-double", ReferenceType.none, Format.Format23x, 52),
    MUL_DOUBLE(-83, "mul-double", ReferenceType.none, Format.Format23x, 52),
    DIV_DOUBLE(-82, "div-double", ReferenceType.none, Format.Format23x, 52),
    REM_DOUBLE(-81, "rem-double", ReferenceType.none, Format.Format23x, 52),
    ADD_INT_2ADDR(-80, "add-int/2addr", ReferenceType.none, Format.Format12x, 20),
    SUB_INT_2ADDR(-79, "sub-int/2addr", ReferenceType.none, Format.Format12x, 20),
    MUL_INT_2ADDR(-78, "mul-int/2addr", ReferenceType.none, Format.Format12x, 20),
    DIV_INT_2ADDR(-77, "div-int/2addr", ReferenceType.none, Format.Format12x, 21),
    REM_INT_2ADDR(-76, "rem-int/2addr", ReferenceType.none, Format.Format12x, 21),
    AND_INT_2ADDR(-75, "and-int/2addr", ReferenceType.none, Format.Format12x, 20),
    OR_INT_2ADDR(-74, "or-int/2addr", ReferenceType.none, Format.Format12x, 20),
    XOR_INT_2ADDR(-73, "xor-int/2addr", ReferenceType.none, Format.Format12x, 20),
    SHL_INT_2ADDR(-72, "shl-int/2addr", ReferenceType.none, Format.Format12x, 20),
    SHR_INT_2ADDR(-71, "shr-int/2addr", ReferenceType.none, Format.Format12x, 20),
    USHR_INT_2ADDR(-70, "ushr-int/2addr", ReferenceType.none, Format.Format12x, 20),
    ADD_LONG_2ADDR(-69, "add-long/2addr", ReferenceType.none, Format.Format12x, 52),
    SUB_LONG_2ADDR(-68, "sub-long/2addr", ReferenceType.none, Format.Format12x, 52),
    MUL_LONG_2ADDR(-67, "mul-long/2addr", ReferenceType.none, Format.Format12x, 52),
    DIV_LONG_2ADDR(-66, "div-long/2addr", ReferenceType.none, Format.Format12x, 53),
    REM_LONG_2ADDR(-65, "rem-long/2addr", ReferenceType.none, Format.Format12x, 53),
    AND_LONG_2ADDR(-64, "and-long/2addr", ReferenceType.none, Format.Format12x, 52),
    OR_LONG_2ADDR(-63, "or-long/2addr", ReferenceType.none, Format.Format12x, 52),
    XOR_LONG_2ADDR(-62, "xor-long/2addr", ReferenceType.none, Format.Format12x, 52),
    SHL_LONG_2ADDR(-61, "shl-long/2addr", ReferenceType.none, Format.Format12x, 52),
    SHR_LONG_2ADDR(-60, "shr-long/2addr", ReferenceType.none, Format.Format12x, 52),
    USHR_LONG_2ADDR(-59, "ushr-long/2addr", ReferenceType.none, Format.Format12x, 52),
    ADD_FLOAT_2ADDR(-58, "add-float/2addr", ReferenceType.none, Format.Format12x, 20),
    SUB_FLOAT_2ADDR(-57, "sub-float/2addr", ReferenceType.none, Format.Format12x, 20),
    MUL_FLOAT_2ADDR(-56, "mul-float/2addr", ReferenceType.none, Format.Format12x, 20),
    DIV_FLOAT_2ADDR(-55, "div-float/2addr", ReferenceType.none, Format.Format12x, 20),
    REM_FLOAT_2ADDR(-54, "rem-float/2addr", ReferenceType.none, Format.Format12x, 20),
    ADD_DOUBLE_2ADDR(-53, "add-double/2addr", ReferenceType.none, Format.Format12x, 52),
    SUB_DOUBLE_2ADDR(-52, "sub-double/2addr", ReferenceType.none, Format.Format12x, 52),
    MUL_DOUBLE_2ADDR(-51, "mul-double/2addr", ReferenceType.none, Format.Format12x, 52),
    DIV_DOUBLE_2ADDR(-50, "div-double/2addr", ReferenceType.none, Format.Format12x, 52),
    REM_DOUBLE_2ADDR(-49, "rem-double/2addr", ReferenceType.none, Format.Format12x, 52),
    ADD_INT_LIT16(-48, "add-int/lit16", ReferenceType.none, Format.Format22s, 20),
    RSUB_INT(-47, "rsub-int", ReferenceType.none, Format.Format22s, 20),
    MUL_INT_LIT16(-46, "mul-int/lit16", ReferenceType.none, Format.Format22s, 20),
    DIV_INT_LIT16(-45, "div-int/lit16", ReferenceType.none, Format.Format22s, 21),
    REM_INT_LIT16(-44, "rem-int/lit16", ReferenceType.none, Format.Format22s, 21),
    AND_INT_LIT16(-43, "and-int/lit16", ReferenceType.none, Format.Format22s, 20),
    OR_INT_LIT16(-42, "or-int/lit16", ReferenceType.none, Format.Format22s, 20),
    XOR_INT_LIT16(-41, "xor-int/lit16", ReferenceType.none, Format.Format22s, 20),
    ADD_INT_LIT8(-40, "add-int/lit8", ReferenceType.none, Format.Format22b, 20),
    RSUB_INT_LIT8(-39, "rsub-int/lit8", ReferenceType.none, Format.Format22b, 20),
    MUL_INT_LIT8(-38, "mul-int/lit8", ReferenceType.none, Format.Format22b, 20),
    DIV_INT_LIT8(-37, "div-int/lit8", ReferenceType.none, Format.Format22b, 21),
    REM_INT_LIT8(-36, "rem-int/lit8", ReferenceType.none, Format.Format22b, 21),
    AND_INT_LIT8(-35, "and-int/lit8", ReferenceType.none, Format.Format22b, 20),
    OR_INT_LIT8(-34, "or-int/lit8", ReferenceType.none, Format.Format22b, 20),
    XOR_INT_LIT8(-33, "xor-int/lit8", ReferenceType.none, Format.Format22b, 20),
    SHL_INT_LIT8(-32, "shl-int/lit8", ReferenceType.none, Format.Format22b, 20),
    SHR_INT_LIT8(-31, "shr-int/lit8", ReferenceType.none, Format.Format22b, 20),
    USHR_INT_LIT8(-30, "ushr-int/lit8", ReferenceType.none, Format.Format22b, 20),
    EXECUTE_INLINE(-18, "execute-inline", ReferenceType.none, Format.Format35ms, 15),
    EXECUTE_INLINE_RANGE(-17, "execute-inline/range", ReferenceType.none, Format.Format3rms, 15),
    INVOKE_DIRECT_EMPTY(-16, "invoke-direct-empty", ReferenceType.method, Format.Format35s, 15),
    IGET_QUICK(-14, "iget-quick", ReferenceType.none, Format.Format22cs, 23),
    IGET_WIDE_QUICK(-13, "iget-wide-quick", ReferenceType.none, Format.Format22cs, 55),
    IGET_OBJECT_QUICK(-12, "iget-object-quick", ReferenceType.none, Format.Format22cs, 23),
    IPUT_QUICK(-11, "iput-quick", ReferenceType.none, Format.Format22cs, 7),
    IPUT_WIDE_QUICK(-10, "iput-wide-quick", ReferenceType.none, Format.Format22cs, 7),
    IPUT_OBJECT_QUICK(-9, "iput-object-quick", ReferenceType.none, Format.Format22cs, 7),
    INVOKE_VIRTUAL_QUICK(-8, "invoke-virtual-quick", ReferenceType.none, Format.Format35ms, 15),
    INVOKE_VIRTUAL_QUICK_RANGE(-7, "invoke-virtual-quick/range", ReferenceType.none, Format.Format3rms, 15),
    INVOKE_SUPER_QUICK(-6, "invoke-super-quick", ReferenceType.none, Format.Format35ms, 15),
    INVOKE_SUPER_QUICK_RANGE(-5, "invoke-super-quick/range", ReferenceType.none, Format.Format3rms, 15);

    private static Opcode[] opcodesByValue;
    private static HashMap<Integer, Opcode> opcodesByName;
    public static final int CAN_THROW = 1;
    public static final int ODEX_ONLY = 2;
    public static final int CAN_CONTINUE = 4;
    public static final int SETS_RESULT = 8;
    public static final int SETS_REGISTER = 16;
    public static final int SETS_WIDE_REGISTER = 32;
    public final byte value;
    public final String name;
    public final ReferenceType referenceType;
    public final Format format;
    public final int flags;

    public static Opcode getOpcodeByName(String opcodeName) {
        return opcodesByName.get(opcodeName.toLowerCase().hashCode());
    }

    public static Opcode getOpcodeByValue(byte opcodeValue) {
        return opcodesByValue[opcodeValue & 0xFF];
    }

    private Opcode(byte opcodeValue, String opcodeName, ReferenceType referenceType, Format format) {
        this(opcodeValue, opcodeName, referenceType, format, 0);
    }

    private Opcode(byte opcodeValue, String opcodeName, ReferenceType referenceType, Format format, int flags) {
        this.value = opcodeValue;
        this.name = opcodeName;
        this.referenceType = referenceType;
        this.format = format;
        this.flags = flags;
    }

    public final boolean canThrow() {
        return (this.flags & 1) != 0;
    }

    public final boolean odexOnly() {
        return (this.flags & 2) != 0;
    }

    public final boolean canContinue() {
        return (this.flags & 4) != 0;
    }

    public final boolean setsResult() {
        return (this.flags & 8) != 0;
    }

    public final boolean setsRegister() {
        return (this.flags & 0x10) != 0;
    }

    public final boolean setsWideRegister() {
        return (this.flags & 0x20) != 0;
    }

    static {
        opcodesByValue = new Opcode[256];
        opcodesByName = new HashMap();
        Opcode[] arr$ = Opcode.values();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Opcode opcode;
            Opcode.opcodesByValue[opcode.value & 0xFF] = opcode = arr$[i$];
            opcodesByName.put(opcode.name.hashCode(), opcode);
        }
    }
}

