/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib.Util;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import org.jf.dexlib.Util.AnnotatedOutput;
import org.jf.dexlib.Util.ByteArray;
import org.jf.dexlib.Util.ExceptionWithContext;
import org.jf.dexlib.Util.Hex;
import org.jf.dexlib.Util.TwoColumnOutput;

public final class ByteArrayAnnotatedOutput
implements AnnotatedOutput {
    private static final int DEFAULT_SIZE = 1000;
    private final boolean stretchy;
    private byte[] data;
    private int cursor;
    private boolean verbose;
    private ArrayList<Annotation> annotations;
    private int annotationWidth;
    private int hexCols;
    private int currentIndent = 0;
    private int indentAmount = 2;

    public ByteArrayAnnotatedOutput(byte[] data) {
        this(data, false);
    }

    public ByteArrayAnnotatedOutput() {
        this(new byte[1000], true);
    }

    private ByteArrayAnnotatedOutput(byte[] data, boolean stretchy) {
        if (data == null) {
            throw new NullPointerException("data == null");
        }
        this.stretchy = stretchy;
        this.data = data;
        this.cursor = 0;
        this.verbose = false;
        this.annotations = null;
        this.annotationWidth = 0;
        this.hexCols = 0;
    }

    public byte[] getArray() {
        return this.data;
    }

    public byte[] toByteArray() {
        byte[] result = new byte[this.cursor];
        System.arraycopy(this.data, 0, result, 0, this.cursor);
        return result;
    }

    public int getCursor() {
        return this.cursor;
    }

    public void assertCursor(int expectedCursor) {
        if (this.cursor != expectedCursor) {
            throw new ExceptionWithContext("expected cursor " + expectedCursor + "; actual value: " + this.cursor);
        }
    }

    public void writeByte(int value) {
        int writeAt = this.cursor;
        int end = writeAt + 1;
        if (this.stretchy) {
            this.ensureCapacity(end);
        } else if (end > this.data.length) {
            ByteArrayAnnotatedOutput.throwBounds();
            return;
        }
        this.data[writeAt] = (byte)value;
        this.cursor = end;
    }

    public void writeShort(int value) {
        int writeAt = this.cursor;
        int end = writeAt + 2;
        if (this.stretchy) {
            this.ensureCapacity(end);
        } else if (end > this.data.length) {
            ByteArrayAnnotatedOutput.throwBounds();
            return;
        }
        this.data[writeAt] = (byte)value;
        this.data[writeAt + 1] = (byte)(value >> 8);
        this.cursor = end;
    }

    public void writeInt(int value) {
        int writeAt = this.cursor;
        int end = writeAt + 4;
        if (this.stretchy) {
            this.ensureCapacity(end);
        } else if (end > this.data.length) {
            ByteArrayAnnotatedOutput.throwBounds();
            return;
        }
        this.data[writeAt] = (byte)value;
        this.data[writeAt + 1] = (byte)(value >> 8);
        this.data[writeAt + 2] = (byte)(value >> 16);
        this.data[writeAt + 3] = (byte)(value >> 24);
        this.cursor = end;
    }

    public void writeLong(long value) {
        int writeAt = this.cursor;
        int end = writeAt + 8;
        if (this.stretchy) {
            this.ensureCapacity(end);
        } else if (end > this.data.length) {
            ByteArrayAnnotatedOutput.throwBounds();
            return;
        }
        int half = (int)value;
        this.data[writeAt] = (byte)half;
        this.data[writeAt + 1] = (byte)(half >> 8);
        this.data[writeAt + 2] = (byte)(half >> 16);
        this.data[writeAt + 3] = (byte)(half >> 24);
        half = (int)(value >> 32);
        this.data[writeAt + 4] = (byte)half;
        this.data[writeAt + 5] = (byte)(half >> 8);
        this.data[writeAt + 6] = (byte)(half >> 16);
        this.data[writeAt + 7] = (byte)(half >> 24);
        this.cursor = end;
    }

    public int writeUnsignedLeb128(int value) {
        long remaining = ((long)value & 0xFFFFFFFFL) >> 7;
        long lValue = value;
        int count = 0;
        while (remaining != 0L) {
            this.writeByte((int)(lValue & 0x7FL) | 0x80);
            lValue = remaining;
            remaining >>= 7;
            ++count;
        }
        this.writeByte((int)(lValue & 0x7FL));
        return count + 1;
    }

    public int writeSignedLeb128(int value) {
        int end;
        int remaining = value >> 7;
        int count = 0;
        boolean hasMore = true;
        int n = end = (value & Integer.MIN_VALUE) == 0 ? 0 : -1;
        while (hasMore) {
            hasMore = remaining != end || (remaining & 1) != (value >> 6 & 1);
            this.writeByte(value & 0x7F | (hasMore ? 128 : 0));
            value = remaining;
            remaining >>= 7;
            ++count;
        }
        return count;
    }

    public void write(ByteArray bytes) {
        int blen = bytes.size();
        int writeAt = this.cursor;
        int end = writeAt + blen;
        if (this.stretchy) {
            this.ensureCapacity(end);
        } else if (end > this.data.length) {
            ByteArrayAnnotatedOutput.throwBounds();
            return;
        }
        bytes.getBytes(this.data, writeAt);
        this.cursor = end;
    }

    public void write(byte[] bytes, int offset, int length) {
        int writeAt = this.cursor;
        int end = writeAt + length;
        int bytesEnd = offset + length;
        if ((offset | length | end) < 0 || bytesEnd > bytes.length) {
            throw new IndexOutOfBoundsException("bytes.length " + bytes.length + "; " + offset + "..!" + end);
        }
        if (this.stretchy) {
            this.ensureCapacity(end);
        } else if (end > this.data.length) {
            ByteArrayAnnotatedOutput.throwBounds();
            return;
        }
        System.arraycopy(bytes, offset, this.data, writeAt, length);
        this.cursor = end;
    }

    public void write(byte[] bytes) {
        this.write(bytes, 0, bytes.length);
    }

    public void writeZeroes(int count) {
        if (count < 0) {
            throw new IllegalArgumentException("count < 0");
        }
        int end = this.cursor + count;
        if (this.stretchy) {
            this.ensureCapacity(end);
        } else if (end > this.data.length) {
            ByteArrayAnnotatedOutput.throwBounds();
            return;
        }
        this.cursor = end;
    }

    public void alignTo(int alignment) {
        int mask = alignment - 1;
        if (alignment < 0 || (mask & alignment) != 0) {
            throw new IllegalArgumentException("bogus alignment");
        }
        int end = this.cursor + mask & ~mask;
        if (this.stretchy) {
            this.ensureCapacity(end);
        } else if (end > this.data.length) {
            ByteArrayAnnotatedOutput.throwBounds();
            return;
        }
        this.cursor = end;
    }

    public boolean annotates() {
        return this.annotations != null;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void annotate(String msg) {
        if (this.annotations == null) {
            return;
        }
        this.endAnnotation();
        this.annotations.add(new Annotation(this.cursor, msg, this.currentIndent));
    }

    public void indent() {
        ++this.currentIndent;
    }

    public void deindent() {
        --this.currentIndent;
        if (this.currentIndent < 0) {
            this.currentIndent = 0;
        }
    }

    public void setIndentAmount(int indentAmount) {
        this.indentAmount = indentAmount;
    }

    public void annotate(int amt, String msg) {
        if (this.annotations == null) {
            return;
        }
        this.endAnnotation();
        int asz = this.annotations.size();
        int lastEnd = asz == 0 ? 0 : this.annotations.get(asz - 1).getEnd();
        int startAt = lastEnd <= this.cursor ? this.cursor : lastEnd;
        this.annotations.add(new Annotation(startAt, startAt + amt, msg, this.currentIndent));
    }

    public void endAnnotation() {
        if (this.annotations == null) {
            return;
        }
        int sz = this.annotations.size();
        if (sz != 0) {
            this.annotations.get(sz - 1).setEndIfUnset(this.cursor);
        }
    }

    public int getAnnotationWidth() {
        int leftWidth = 8 + this.hexCols * 2 + this.hexCols / 2;
        return this.annotationWidth - leftWidth;
    }

    public void enableAnnotations(int annotationWidth, boolean verbose) {
        if (this.annotations != null || this.cursor != 0) {
            throw new RuntimeException("cannot enable annotations");
        }
        if (annotationWidth < 40) {
            throw new IllegalArgumentException("annotationWidth < 40");
        }
        int hexCols = (annotationWidth - 7) / 15 + 1 & 0xFFFFFFFE;
        if (hexCols < 6) {
            hexCols = 6;
        } else if (hexCols > 10) {
            hexCols = 10;
        }
        this.annotations = new ArrayList(1000);
        this.annotationWidth = annotationWidth;
        this.hexCols = hexCols;
        this.verbose = verbose;
    }

    public void finishAnnotating() {
        this.endAnnotation();
        if (this.annotations != null) {
            for (int asz = this.annotations.size(); asz > 0; --asz) {
                Annotation last = this.annotations.get(asz - 1);
                if (last.getStart() > this.cursor) {
                    this.annotations.remove(asz - 1);
                    continue;
                }
                if (last.getEnd() <= this.cursor) break;
                last.setEnd(this.cursor);
                break;
            }
        }
    }

    public void writeAnnotationsTo(Writer out) throws IOException {
        int width2 = this.getAnnotationWidth();
        int width1 = this.annotationWidth - width2 - 1;
        StringBuilder padding = new StringBuilder();
        for (int i = 0; i < 1000; ++i) {
            padding.append(' ');
        }
        TwoColumnOutput twoc = new TwoColumnOutput(out, width1, width2, "|");
        Writer left = twoc.getLeft();
        Writer right = twoc.getRight();
        int leftAt = 0;
        int rightAt = 0;
        int rightSz = this.annotations.size();
        while (leftAt < this.cursor && rightAt < rightSz) {
            String text;
            int end;
            Annotation a = this.annotations.get(rightAt);
            int start = a.getStart();
            if (leftAt < start) {
                end = start;
                start = leftAt;
                text = "";
            } else {
                end = a.getEnd();
                text = padding.substring(0, a.getIndent() * this.indentAmount) + a.getText();
                ++rightAt;
            }
            left.write(Hex.dump(this.data, start, end - start, start, this.hexCols, 6));
            right.write(text);
            twoc.flush();
            leftAt = end;
        }
        if (leftAt < this.cursor) {
            left.write(Hex.dump(this.data, leftAt, this.cursor - leftAt, leftAt, this.hexCols, 6));
        }
        while (rightAt < rightSz) {
            right.write(this.annotations.get(rightAt).getText());
            ++rightAt;
        }
        twoc.flush();
    }

    private static void throwBounds() {
        throw new IndexOutOfBoundsException("attempt to write past the end");
    }

    private void ensureCapacity(int desiredSize) {
        if (this.data.length < desiredSize) {
            byte[] newData = new byte[desiredSize * 2 + 1000];
            System.arraycopy(this.data, 0, newData, 0, this.cursor);
            this.data = newData;
        }
    }

    private static class Annotation {
        private final int start;
        private int end;
        private final String text;
        private int indent;

        public Annotation(int start, int end, String text, int indent) {
            this.start = start;
            this.end = end;
            this.text = text;
            this.indent = indent;
        }

        public Annotation(int start, String text, int indent) {
            this(start, Integer.MAX_VALUE, text, indent);
        }

        public void setEndIfUnset(int end) {
            if (this.end == Integer.MAX_VALUE) {
                this.end = end;
            }
        }

        public void setEnd(int end) {
            this.end = end;
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }

        public String getText() {
            return this.text;
        }

        public int getIndent() {
            return this.indent;
        }
    }
}

