/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.crx2oak;

import com.adobe.granite.crx2oak.CoreComponents;
import com.adobe.granite.crx2oak.MigrationComponents;
import com.adobe.granite.crx2oak.cli.CRX2OakOption;
import com.adobe.granite.crx2oak.cli.CliTools;
import com.adobe.granite.crx2oak.cli.transformer.CommandLineTransformerEngine;
import com.adobe.granite.crx2oak.logging.LoggingLevelControllerFactory;
import com.adobe.granite.crx2oak.logging.RealSlf4jProvider;
import com.adobe.granite.crx2oak.model.Topics;
import com.adobe.granite.crx2oak.pipeline.PipeData;
import com.adobe.granite.crx2oak.pipeline.Pipeline;
import com.adobe.granite.crx2oak.pipeline.PipelineComponent;
import com.google.common.base.Optional;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.List;
import joptsimple.OptionParser;
import org.apache.jackrabbit.oak.upgrade.cli.parser.OptionParserFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CRX2Oak {
    public static final Logger LOGGER = LoggerFactory.getLogger(CRX2Oak.class);

    public static void main(String ... args) {
        CRX2Oak.processAppOutput(CRX2Oak.run(args));
    }

    public static PipeData run(String[] args) {
        LOGGER.info("started with args: {}", Arrays.asList(args));
        OptionParser parser = CRX2OakOption.passAllOptionsToParser(OptionParserFactory.create());
        PipeData input = PipeData.put(Topics.OPTION_PARSER, parser).put(Topics.CMD_LINE_ARGS, args).toPipe();
        return Pipeline.of(CRX2Oak.getAppComponents(parser)).run(input);
    }

    private static Iterable<PipelineComponent> getAppComponents(OptionParser parser) {
        LoggingLevelControllerFactory logLevelCtrlFactory = new LoggingLevelControllerFactory(new RealSlf4jProvider());
        CommandLineTransformerEngine cmdlineTransformer = CliTools.getCommandLineTransformerEngine();
        return Iterables.concat(CoreComponents.getCoreComponents(logLevelCtrlFactory, cmdlineTransformer, parser), MigrationComponents.getMigrationComponents(logLevelCtrlFactory, cmdlineTransformer));
    }

    private static void processAppOutput(PipeData output) {
        Optional<Integer> exitCode;
        Optional<List<String>> optionalWarnings = output.get(Topics.WARNINGS);
        if (optionalWarnings.isPresent()) {
            CRX2Oak.outputWarnings((List)optionalWarnings.get());
        }
        if ((exitCode = output.get(Topics.EXIT_CODE)).isPresent()) {
            System.exit((Integer)exitCode.get());
        }
    }

    private static void outputWarnings(List<String> strings) {
        for (String warning : strings) {
            System.out.println(warning);
            LOGGER.warn(warning);
        }
    }
}

