/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.crx2oak;

import com.adobe.granite.crx2oak.cli.transformer.CommandLineTransformerEngine;
import com.adobe.granite.crx2oak.core.DryModeBreaker;
import com.adobe.granite.crx2oak.core.HelpPrinter;
import com.adobe.granite.crx2oak.core.MigrationModeEvaluator;
import com.adobe.granite.crx2oak.core.StoreArgsProvider;
import com.adobe.granite.crx2oak.core.VersionOptChecker;
import com.adobe.granite.crx2oak.core.VersionPrinter;
import com.adobe.granite.crx2oak.logging.LoggingLevelControllerFactory;
import com.adobe.granite.crx2oak.logging.LoggingRedirector;
import com.adobe.granite.crx2oak.logging.RealSlf4jProvider;
import com.adobe.granite.crx2oak.logging.TraceLogsEnabler;
import com.adobe.granite.crx2oak.model.ModelInitializer;
import com.adobe.granite.crx2oak.pipeline.PipelineComponent;
import com.adobe.granite.crx2oak.profile.ProfileComponent;
import com.adobe.granite.crx2oak.profile.tags.CommandLineTagHandler;
import com.adobe.granite.crx2oak.sling.SlingHomeDetector;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import joptsimple.OptionParser;

final class CoreComponents {
    private CoreComponents() {
    }

    private static Iterable<PipelineComponent> getBasicComponents(LoggingLevelControllerFactory logLevCtrlFactory) {
        VersionPrinter versionPrinter = new VersionPrinter();
        PipelineComponent muter = logLevCtrlFactory.createMuteLoggingLevelProcessor("org.apache.jackrabbit.oak");
        return ImmutableList.of((Object)new ModelInitializer(), (Object)new SlingHomeDetector.SlingHomePipelineDetector(new SlingHomeDetector()), (Object)new TraceLogsEnabler(logLevCtrlFactory, muter), (Object)new LoggingRedirector(new RealSlf4jProvider()), (Object)new MigrationModeEvaluator(), (Object)new VersionOptChecker(versionPrinter), (Object)new HelpPrinter(versionPrinter), (Object)versionPrinter);
    }

    private static Iterable<PipelineComponent> getProfileComponents(OptionParser parser, CommandLineTransformerEngine cmdLineTransformer) {
        CommandLineTagHandler cmdLineTagHandler = new CommandLineTagHandler();
        return ImmutableList.of((Object)cmdLineTagHandler, (Object)ProfileComponent.create(cmdLineTransformer, parser, cmdLineTagHandler));
    }

    private static Iterable<PipelineComponent> getQuickstartComponents() {
        return ImmutableList.of((Object)new DryModeBreaker(), (Object)new StoreArgsProvider());
    }

    static Iterable<PipelineComponent> getCoreComponents(LoggingLevelControllerFactory logLevelCtrlFactory, CommandLineTransformerEngine cmdlineTransformer, OptionParser parser) {
        return Iterables.concat(CoreComponents.getBasicComponents(logLevelCtrlFactory), CoreComponents.getProfileComponents(parser, cmdlineTransformer), CoreComponents.getQuickstartComponents());
    }
}

