/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.crx2oak;

import com.adobe.granite.crx2oak.cli.transformer.CommandLineTransformerEngine;
import com.adobe.granite.crx2oak.core.DestinationDirectoryCreator;
import com.adobe.granite.crx2oak.core.DestinationRepositoryActivator;
import com.adobe.granite.crx2oak.core.MigrationSpecGenerator;
import com.adobe.granite.crx2oak.engine.MigrationRunner;
import com.adobe.granite.crx2oak.logging.LoggingLevelControllerFactory;
import com.adobe.granite.crx2oak.model.CliModelTransformer;
import com.adobe.granite.crx2oak.oldsegment.MigrationVerifier;
import com.adobe.granite.crx2oak.oldsegment.OldSegmentDetector;
import com.adobe.granite.crx2oak.oldsegment.OldSegmentMigrationPlanner;
import com.adobe.granite.crx2oak.pipeline.PipelineComponent;
import com.adobe.granite.crx2oak.sling.OsgiConfigurationsInstaller;
import com.adobe.granite.crx2oak.sling.RunModeRecommender;
import com.adobe.granite.crx2oak.sling.RunModesRewriter;
import com.adobe.granite.crx2oak.sling.SlingOptionsFileDeletionDelegator;
import com.adobe.granite.crx2oak.sling.SlingOptionsFileFinder;
import com.adobe.granite.crx2oak.util.FilesystemOps;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import org.apache.sling.settings.impl.SlingOptionsFileReader;
import org.apache.sling.settings.impl.SlingOptionsFileWriter;

final class MigrationComponents {
    static final String OAK_PACKAGE_LOGGER_NAME = "org.apache.jackrabbit.oak";

    private MigrationComponents() {
    }

    private static Iterable<PipelineComponent> getCRX2OakComponents(CommandLineTransformerEngine cmdLineTransformer) {
        SlingOptionsFileReader reader = new SlingOptionsFileReader();
        SlingOptionsFileWriter writer = new SlingOptionsFileWriter(reader);
        CliModelTransformer cliModelTransformer = new CliModelTransformer(cmdLineTransformer);
        SlingOptionsFileFinder finder = new SlingOptionsFileFinder();
        OldSegmentDetector oldSegmentDetector = new OldSegmentDetector(finder, reader);
        return ImmutableList.of((Object)new OldSegmentMigrationPlanner(oldSegmentDetector, cliModelTransformer), (Object)new OsgiConfigurationsInstaller(), (Object)new SlingOptionsFileDeletionDelegator(finder), (Object)new RunModesRewriter(finder, reader, writer), (Object)new RunModeRecommender(), (Object)new MigrationVerifier());
    }

    private static Iterable<PipelineComponent> getOakUpgradeComponents(LoggingLevelControllerFactory logLevelCtrlFactory, FilesystemOps filesystemOps) {
        return ImmutableList.of((Object)logLevelCtrlFactory.createUnmuteLoggingLevelProcessor(OAK_PACKAGE_LOGGER_NAME), (Object)new MigrationSpecGenerator(), (Object)new DestinationDirectoryCreator(filesystemOps), (Object)new DestinationRepositoryActivator(filesystemOps), (Object)new MigrationRunner());
    }

    static Iterable<PipelineComponent> getMigrationComponents(LoggingLevelControllerFactory logLevelCtrlFactory, CommandLineTransformerEngine cmdlineTransformer) {
        FilesystemOps filesystemOps = new FilesystemOps();
        return Iterables.concat(MigrationComponents.getCRX2OakComponents(cmdlineTransformer), MigrationComponents.getOakUpgradeComponents(logLevelCtrlFactory, filesystemOps));
    }
}

