/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.crx2oak.auth;

import java.util.HashMap;
import java.util.Map;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.plugins.nodetype.TypePredicate;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.DefaultEditor;
import org.apache.jackrabbit.oak.spi.commit.Editor;
import org.apache.jackrabbit.oak.spi.commit.EditorHook;
import org.apache.jackrabbit.oak.spi.commit.EditorProvider;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UniquePrincipalNameHook
extends EditorHook {
    private static final Logger log = LoggerFactory.getLogger(UniquePrincipalNameHook.class);

    public UniquePrincipalNameHook() {
        super(new EditorProvider(){

            public Editor getRootEditor(NodeState before, NodeState after, NodeBuilder builder, CommitInfo info) throws CommitFailedException {
                return new UniquePrincipalNameEditor(builder, after);
            }

            public String toString() {
                return "UniquePrincipalNameEditorProvider";
            }
        });
    }

    public static class UniquePrincipalNameEditor
    extends DefaultEditor {
        private final Map<String, Integer> names;
        private final NodeBuilder builder;
        private final TypePredicate isAuthorizable;
        private final TypePredicate isAuthorizableFolder;

        public UniquePrincipalNameEditor(NodeBuilder rootBuilder, NodeState rootState) {
            this.builder = rootBuilder;
            this.names = new HashMap<String, Integer>();
            this.isAuthorizable = new TypePredicate(rootState, "rep:Authorizable");
            this.isAuthorizableFolder = new TypePredicate(rootState, "rep:AuthorizableFolder");
        }

        public UniquePrincipalNameEditor(UniquePrincipalNameEditor editor, NodeBuilder builder) {
            this.builder = builder;
            this.names = editor.names;
            this.isAuthorizable = editor.isAuthorizable;
            this.isAuthorizableFolder = editor.isAuthorizableFolder;
        }

        public Editor childNodeAdded(String name, NodeState after) throws CommitFailedException {
            if (this.isAuthorizableFolder.apply(after)) {
                return new UniquePrincipalNameEditor(this, this.builder.getChildNode(name));
            }
            if (this.isAuthorizable.apply(after)) {
                int index;
                String principalName = after.getString("rep:principalName");
                if (principalName == null) {
                    return null;
                }
                if (this.names.containsKey(principalName)) {
                    index = this.names.get(principalName) + 1;
                    String newPrincipalName = String.format("%s-%d", principalName, index);
                    this.builder.getChildNode(name).setProperty("rep:principalName", (Object)newPrincipalName);
                    log.info("Found duplicated principal name {}. Renamed it to {}.", (Object)principalName, (Object)newPrincipalName);
                } else {
                    index = 1;
                }
                this.names.put(principalName, index);
            }
            return null;
        }
    }
}

