/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.crx2oak.cli;

import com.adobe.granite.crx2oak.cli.CmdLineOptionArgSpec;
import com.adobe.granite.crx2oak.cli.CmdLineOptionCategory;
import com.adobe.granite.crx2oak.util.CliUtils;
import com.google.common.base.Preconditions;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpecBuilder;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;

public enum CRX2OakOption {
    LDAP("ldap", "Create rep:externalId properties for LDAP principals", CmdLineOptionCategory.CRX_UPGRADE, CmdLineOptionArgSpec.NO_ARGS){

        @Override
        public void logWhenEnabled(Logger log, OptionSet optionSet) {
            log.info("rep:externalId properties will be created for LDAP principals");
        }
    }
    ,
    LDAP_CONFIG("ldapconfig", "Use given ldap_login.conf to create LDAP principals", CmdLineOptionCategory.CRX_UPGRADE, CmdLineOptionArgSpec.ONE_STRING),
    DISABLE_INDEXES("disable-indexes", "Comma separated list of index names that need to be disabled", CmdLineOptionCategory.CRX_UPGRADE, CmdLineOptionArgSpec.ONE_STRING){

        @Override
        public void logWhenEnabled(Logger log, OptionSet optionSet) {
            log.info("Migration will disable following indexes {}.", CliUtils.getOptionValuesAsStrings(this.option, optionSet));
        }
    }
    ,
    VERSION("version", "Print the version of this tool", CmdLineOptionCategory.GENERAL, CmdLineOptionArgSpec.NO_ARGS),
    MIGRATE("migrate", "Forces migration with default or given profile\nif you haven't specified any command line option", CmdLineOptionCategory.QUICKSTART_EXTENSION, CmdLineOptionArgSpec.NO_ARGS),
    REPLACE("replace", "Renames destination to source repository\nafter successful migration (if possible)", CmdLineOptionCategory.GENERAL, CmdLineOptionArgSpec.NO_ARGS),
    LOG_LEVEL("log-level", "Log level option for quickstart extension logs", CmdLineOptionCategory.QUICKSTART_EXTENSION, CmdLineOptionArgSpec.ONE_STRING){

        @Override
        public void logWhenEnabled(Logger log, OptionSet optionSet) {
            log.info("The migration will be logged with {} level.", CliUtils.getOptionValuesAsStrings(this.option, optionSet));
        }
    }
    ,
    TRACE_LOGGING("trace", String.format("The option is handled immediately (earlier than %s)\n", CRX2OakOption.LOG_LEVEL.dashedOption) + "and enables tracing the application execution in detail", CmdLineOptionCategory.GENERAL, CmdLineOptionArgSpec.NO_ARGS),
    DELETE_SLING_OPTIONS_FILE("delete-sling-opt-file", "Deletes sling.options.file after migration\nthat stores outdated run modes", CmdLineOptionCategory.QUICKSTART_EXTENSION, CmdLineOptionArgSpec.NO_ARGS),
    DETECT_OLD_SEGMENT("detect-old-segment", "Detects old segment file and prepares migration for it", CmdLineOptionCategory.QUICKSTART_EXTENSION, CmdLineOptionArgSpec.NO_ARGS),
    PROMOTE_RUN_MODE("promote-runmode", "Activates the given run mode in AEM if it hasn't been already activated.\nThe option might be used multiple time to activate more than one run mode.", CmdLineOptionCategory.QUICKSTART_EXTENSION, CmdLineOptionArgSpec.ONE_STRING),
    DROP_RUN_MODE("drop-runmode", "Deactivate the given run mode in AEM if it has been already activated.\nThe first other run mode will be activated instead.\nThe option might be used multiple time to deactivate more than one run mode.", CmdLineOptionCategory.QUICKSTART_EXTENSION, CmdLineOptionArgSpec.ONE_STRING),
    INSTALL_RUN_MODE("install-runmode", "Install the given persistence related new run mode in AEM.\nThe option might be used multiple time but only one mode can be installed for persistence group.", CmdLineOptionCategory.QUICKSTART_EXTENSION, CmdLineOptionArgSpec.ONE_STRING),
    CRX2_DATA_STORE("tag-crx2-datastore-as", "Provides a CRX2 DataStore path as a specified tag name.\nUse the same tag name specified here for your OSGi\nconfigurations in your profile.", CmdLineOptionCategory.QUICKSTART_EXTENSION, CmdLineOptionArgSpec.ONE_STRING),
    OAK_FILE_DATA_STORE("tag-oak-datastore-as", "Provides an OAK File DataStore path as a specified tag name.\nUse the same tag name specified here for your OSGi\nconfigurations in your profile.", CmdLineOptionCategory.QUICKSTART_EXTENSION, CmdLineOptionArgSpec.ONE_STRING),
    CUSTOM_SOURCE("custom-src", "Use your argument as source repo.\nDestination repo will be detected (if possible).", CmdLineOptionCategory.REPOSITORY_DETECTION, CmdLineOptionArgSpec.NO_ARGS),
    CUSTOM_DESTINATION("custom-dst", "Use your argument as destination repo.\nSource repo will be detected (if possible).", CmdLineOptionCategory.REPOSITORY_DETECTION, CmdLineOptionArgSpec.NO_ARGS),
    DRY("dry", "Actually does not allow to perform migration in real", CmdLineOptionCategory.GENERAL, CmdLineOptionArgSpec.NO_ARGS),
    SAVE_PROFILE("save-profile", "Save a currently loaded profile to a specified path", CmdLineOptionCategory.PROFILES, CmdLineOptionArgSpec.ONE_STRING),
    LOAD_PROFILE("load-profile", String.format("Load a migration profile specified by path.\nHint: Use both '--load-profile example'\nand '%s' example options to save a special\nexisting 'example' built-in profile that\nshould clarify how the profile needs to be\ndefined.", CRX2OakOption.SAVE_PROFILE.dashedOption), CmdLineOptionCategory.PROFILES, CmdLineOptionArgSpec.ONE_STRING),
    COMMENT("comment", "Provides a comment option that will be completely ignored.\nUseful in profiles only.", CmdLineOptionCategory.GENERAL, CmdLineOptionArgSpec.ONE_STRING),
    TAG_NAME("tag-name", "Specify additional template tag name (tags used in the profile\nwith that name like: {{tagname}} will be replaced and applied to\nthe command line and OSGi configurations provided by profile)\nTags (both names and values) can be defined also in profiles.", CmdLineOptionCategory.PROFILES, CmdLineOptionArgSpec.ONE_STRING),
    TAG_VALUE("tag-value", "Supply a concrete template tag value for a specified\ntemplate tag name." + String.format("Use with %s in pairs.", CRX2OakOption.TAG_NAME.dashedOption), CmdLineOptionCategory.PROFILES, CmdLineOptionArgSpec.ONE_STRING),
    TAG_DEFINITION("T", String.format("Specify additional template tag definition in form of:\n\n    -T tagName%stagValue\n\nThis is an equivalent of applying both %s and %s\noptions at once", Character.valueOf('='), CRX2OakOption.TAG_NAME.dashedOption, CRX2OakOption.TAG_VALUE.dashedOption), CmdLineOptionCategory.PROFILES, CmdLineOptionArgSpec.ONE_STRING),
    REQUIRE_TAG("require-tag", "Specify the name of tag after that option to fail application\nin case when the tag value is not provided by user or any other\ntool option. Helpful to indicate important tags for custom profile\nwhere tag value needs to be provided at command line outside of profile.", CmdLineOptionCategory.PROFILES, CmdLineOptionArgSpec.ONE_STRING);

    private static final String OPTION_PREFIX = "--";
    private static final String SHORT_OPTION_PREFIX = "-";
    public static final int ONE_CHARACTER_LENGTH = 1;
    public static final String SINGLE_WHITESPACE = " ";
    public static final String EMPTY_STRING = "";
    private static Map<CmdLineOptionCategory, List<CRX2OakOption>> OPTIONS_PER_CATEGORY;
    public final String option;
    private final String longOption;
    private final String description;
    private final CmdLineOptionCategory category;
    private final CmdLineOptionArgSpec argument;
    public final String dashedOption;

    private CRX2OakOption(@Nonnull String longOption, @Nonnull String description, CmdLineOptionCategory category, CmdLineOptionArgSpec argument) {
        this.option = (String)Preconditions.checkNotNull((Object)longOption);
        this.dashedOption = CRX2OakOption.getDashedOptionFor(longOption);
        this.longOption = longOption;
        this.description = (String)Preconditions.checkNotNull((Object)description);
        this.category = (CmdLineOptionCategory)((Object)Preconditions.checkNotNull((Object)((Object)category)));
        this.argument = (CmdLineOptionArgSpec)((Object)Preconditions.checkNotNull((Object)((Object)argument)));
    }

    public static String getDashPrefixFor(@Nonnull String optionName) {
        Preconditions.checkArgument((boolean)org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)optionName));
        return CRX2OakOption.getStringWithoutSpaces(optionName).length() == 1 ? SHORT_OPTION_PREFIX : OPTION_PREFIX;
    }

    public static String getDashedOptionFor(@Nonnull String optionName) {
        Preconditions.checkArgument((boolean)org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)optionName));
        return CRX2OakOption.getDashPrefixFor(CRX2OakOption.getStringWithoutSpaces(optionName)) + CRX2OakOption.getStringWithoutSpaces(optionName);
    }

    private static String getStringWithoutSpaces(@Nonnull String optionName) {
        return optionName.replace(SINGLE_WHITESPACE, EMPTY_STRING);
    }

    public String optionName() {
        return this.longOption;
    }

    public CmdLineOptionCategory getCategory() {
        return this.category;
    }

    protected OptionSpecBuilder acceptThisOption(OptionParser optionParser) {
        return optionParser.accepts(this.longOption, this.description);
    }

    public void passOptionToParser(@Nonnull OptionParser optionParser) {
        Preconditions.checkNotNull((Object)optionParser);
        this.argument.specifyArgumentToBuilder(this.acceptThisOption(optionParser));
    }

    public void logWhenEnabled(Logger log, OptionSet optionSet) {
    }

    public static OptionParser passAllOptionsToParser(OptionParser optionParser) {
        for (CRX2OakOption option : CRX2OakOption.values()) {
            option.passOptionToParser(optionParser);
        }
        return optionParser;
    }

    public static void printOptionUsages(PrintStream outputStream, int indentLevel) {
        Preconditions.checkArgument((indentLevel >= 0 ? 1 : 0) != 0, (Object)"Indent level needs to be greater or equal to zero.");
        for (CmdLineOptionCategory category : CmdLineOptionCategory.values()) {
            CRX2OakOption.printCategorySection(outputStream, indentLevel, category);
        }
    }

    public static void logEnabledOptions(Logger log, OptionSet optionSet) {
        for (CRX2OakOption option : CRX2OakOption.values()) {
            if (!optionSet.has(option.optionName())) continue;
            option.logWhenEnabled(log, optionSet);
        }
    }

    private static List<CRX2OakOption> getOptionsForCategory(CmdLineOptionCategory category) {
        return Collections.unmodifiableList(OPTIONS_PER_CATEGORY.get((Object)category));
    }

    private static void printCategorySection(PrintStream outputStream, int indentLevel, CmdLineOptionCategory category) {
        List<CRX2OakOption> optionsForCategory = CRX2OakOption.getOptionsForCategory(category);
        if (!optionsForCategory.isEmpty()) {
            category.printAsHeader(outputStream);
            outputStream.println();
            CRX2OakOption.printOptions(outputStream, indentLevel, optionsForCategory);
            outputStream.println();
        }
    }

    private static void printOptions(PrintStream outputStream, int indentLevel, List<CRX2OakOption> options) {
        for (CRX2OakOption option : options) {
            option.printOptionUsage(outputStream, indentLevel);
        }
    }

    private void printOptionUsage(PrintStream outputStream, int indentLevel) {
        outputStream.println(String.format("%s%s%s", this.dashedOption, this.createIndentationString(indentLevel), this.getDescriptionWithAlignedEachAdditionalNewLine(indentLevel)));
    }

    private String getDescriptionWithAlignedEachAdditionalNewLine(int indentLevel) {
        return this.description.replace("\n", "\n" + this.createParagraphIndentationString(indentLevel));
    }

    private String createParagraphIndentationString(int indentLevel) {
        return StringUtils.repeat((String)SINGLE_WHITESPACE, (int)Math.max(0, indentLevel));
    }

    private String createIndentationString(int indentLevel) {
        return StringUtils.repeat((String)SINGLE_WHITESPACE, (int)Math.max(0, indentLevel - this.dashedOption.length()));
    }

    static {
        OPTIONS_PER_CATEGORY = new HashMap<CmdLineOptionCategory, List<CRX2OakOption>>();
        for (CmdLineOptionCategory cmdLineOptionCategory : CmdLineOptionCategory.values()) {
            OPTIONS_PER_CATEGORY.put(cmdLineOptionCategory, new ArrayList());
        }
        for (Enum enum_ : CRX2OakOption.values()) {
            OPTIONS_PER_CATEGORY.get((Object)((CRX2OakOption)enum_).category).add((CRX2OakOption)enum_);
        }
    }
}

