/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.crx2oak.cli;

import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;

public final class CmdLineOption {
    private final String option;
    private final String argument;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CmdLineOption that = (CmdLineOption)o;
        if (this.option != null ? !this.option.equals(that.option) : that.option != null) {
            return false;
        }
        return this.argument != null ? this.argument.equals(that.argument) : that.argument == null;
    }

    public int hashCode() {
        int result = this.option != null ? this.option.hashCode() : 0;
        result = 31 * result + (this.argument != null ? this.argument.hashCode() : 0);
        return result;
    }

    @Nonnull
    public static CmdLineOption withArgument(@Nonnull String option, @Nonnull String argument) {
        Preconditions.checkNotNull((Object)argument, (Object)"The argument cannot be null");
        return new CmdLineOption(option, argument);
    }

    public static CmdLineOption withoutArgument(String option) {
        return new CmdLineOption(option, null);
    }

    private CmdLineOption(String option, String argument) {
        this.option = option;
        this.argument = argument;
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)option), (Object)"The option cannot be null or empty or contain only whitespaces");
    }

    public String getOption() {
        return this.option;
    }

    public String getArgument() {
        if (StringUtils.isEmpty((String)this.argument)) {
            throw new IllegalStateException("Cannot get non-existent argument");
        }
        return this.argument;
    }

    public boolean hasArgument() {
        return StringUtils.isNotEmpty((String)this.argument);
    }
}

