/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.crx2oak.cli;

import com.google.common.base.Preconditions;
import java.io.PrintStream;
import org.apache.commons.lang.StringUtils;

enum CmdLineOptionCategory {
    GENERAL("general crx2oak options"),
    CRX_UPGRADE("CRX upgrade related options"),
    QUICKSTART_EXTENSION("quickstart extension"),
    PROFILES("profile handling options", "migration automation"),
    REPOSITORY_DETECTION("source and destination repository argument detection options", "useful for profiles\n  only if you provided one argument instead of two required ones"),
    PROFILE("profile options", "especially useful in quickstart mode");

    private final String category;
    private final String comment;

    private CmdLineOptionCategory(String category) {
        this(category, null);
    }

    private CmdLineOptionCategory(String category, String comment) {
        Preconditions.checkNotNull((Object)category, (Object)"Category cannot be null");
        this.category = category;
        this.comment = comment;
    }

    public String getCategory() {
        return this.category;
    }

    public String getCategorySectionText() {
        return StringUtils.isNotBlank((String)this.comment) ? String.format("# %s (%s)", this.category, this.comment) : String.format("# %s", this.category);
    }

    public void printAsHeader(PrintStream writer) {
        writer.println(this.getCategorySectionText());
    }
}

