/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.crx2oak.cli.transformer;

import com.adobe.granite.crx2oak.cli.CmdLineOption;
import com.adobe.granite.crx2oak.cli.transformer.CommandLineEventTransformer;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;

public class CommandLineOptionsTransformerEngine {
    private static final String STANDALONE_ARGUMENT_SPECIAL_OPTION_PLACEHOLDER = "[arguments]";

    Collection<CmdLineOption> transformOptions(OptionSet optionSet, CommandLineEventTransformer eventTransformer) {
        ArrayList<CmdLineOption> outputOptions = new ArrayList<CmdLineOption>();
        outputOptions.addAll(this.getMandatoryOptions(eventTransformer));
        outputOptions.addAll(this.getTransformedAndAdditionalOptions(optionSet, eventTransformer, outputOptions));
        return outputOptions;
    }

    private Collection<CmdLineOption> getTransformedAndAdditionalOptions(OptionSet optionSet, CommandLineEventTransformer eventTransformer, Collection<CmdLineOption> initialOptions) {
        ArrayList<CmdLineOption> outputOptionsLocal = new ArrayList<CmdLineOption>();
        HashSet<String> blacklistedOptions = new HashSet<String>(this.getOnlyOptions(initialOptions));
        Collection<CmdLineOption> transformedOptions = this.getTransformedCommandLineOptions(optionSet, eventTransformer, blacklistedOptions);
        blacklistedOptions.addAll(this.getOnlyOptions(transformedOptions));
        outputOptionsLocal.addAll(transformedOptions);
        outputOptionsLocal.addAll(this.getAdditionalOptions(eventTransformer, blacklistedOptions));
        return outputOptionsLocal;
    }

    private Collection<CmdLineOption> getTransformedCommandLineOptions(OptionSet optionSet, CommandLineEventTransformer eventTransformer, Collection<String> blacklistedOptions) {
        ArrayList<CmdLineOption> newOptions = new ArrayList<CmdLineOption>();
        for (String optionName : this.getDetectedOptions(optionSet)) {
            Collection<CmdLineOption> outputOptions = this.filterOptions(this.transformOptionToOptions(eventTransformer, optionSet, optionName), blacklistedOptions);
            newOptions.addAll(outputOptions);
        }
        return newOptions;
    }

    private Collection<CmdLineOption> filterOptions(Collection<CmdLineOption> cmdLineOptions, final Collection<String> blacklistedOptions) {
        return Collections2.filter(cmdLineOptions, (Predicate)new Predicate<CmdLineOption>(){

            public boolean apply(CmdLineOption option) {
                return !blacklistedOptions.contains(option.getOption());
            }
        });
    }

    private Collection<String> getDetectedOptions(OptionSet optionSet) {
        List specs = optionSet.specs();
        int numberOfArguments = optionSet.nonOptionArguments().size();
        ImmutableList<OptionSpec<?>> onlyOptionSpecs = this.getSpecsOnlyForOptions(specs.iterator(), numberOfArguments);
        Collection<String> detectedOptions = this.getDetectedOptions(this.getAllAcceptedOptions(onlyOptionSpecs), optionSet);
        return detectedOptions;
    }

    private Collection<String> getDetectedOptions(Collection<String> allOptions, OptionSet optionSet) {
        HashSet<String> detectedOptionsUnique = new HashSet<String>();
        ArrayList<String> detectedOptions = new ArrayList<String>();
        for (String optionName : allOptions) {
            if (!optionSet.has(optionName) || detectedOptionsUnique.contains(optionName)) continue;
            detectedOptions.add(optionName);
            detectedOptionsUnique.add(optionName);
        }
        return detectedOptions;
    }

    private Collection<String> getAllAcceptedOptions(ImmutableList<OptionSpec<?>> onlyOptionSpecs) {
        ArrayList<String> allOptions = new ArrayList<String>();
        HashSet<String> allOptionsUnique = new HashSet<String>();
        for (OptionSpec spec : onlyOptionSpecs) {
            for (Object option : spec.options()) {
                String optionName;
                if (!(option instanceof String) || allOptionsUnique.contains(optionName = option.toString())) continue;
                allOptions.add(optionName);
                allOptionsUnique.add(optionName);
            }
        }
        return allOptions;
    }

    private Collection<CmdLineOption> transformOptionToOptions(CommandLineEventTransformer eventTransformer, OptionSet optionSet, String optionName) {
        List values = optionSet.valuesOf(optionName);
        Collection<CmdLineOption> cmdLineOptions = values.isEmpty() ? eventTransformer.transformOption(CmdLineOption.withoutArgument(optionName)) : this.getMultiValueOptions(optionName, values, eventTransformer);
        Preconditions.checkState((cmdLineOptions != null ? 1 : 0) != 0);
        return cmdLineOptions;
    }

    private Collection<CmdLineOption> getAdditionalOptions(CommandLineEventTransformer eventTransformer, Collection<String> alreadyAddedOptions) {
        Collection<CmdLineOption> additionalOptions = eventTransformer.getAdditionalOptions();
        Preconditions.checkState((additionalOptions != null ? 1 : 0) != 0, (Object)"Additional options cannot be null (but can be empty)");
        ArrayList<CmdLineOption> filteredOptions = new ArrayList<CmdLineOption>();
        for (CmdLineOption compositeOption : additionalOptions) {
            if (alreadyAddedOptions.contains(compositeOption.getOption())) continue;
            filteredOptions.add(compositeOption);
        }
        return filteredOptions;
    }

    private Collection<String> getOnlyOptions(Collection<CmdLineOption> compositeOptions) {
        ArrayList<String> options = new ArrayList<String>();
        for (CmdLineOption compositeOption : compositeOptions) {
            options.add(compositeOption.getOption());
        }
        return options;
    }

    private Collection<CmdLineOption> getMandatoryOptions(CommandLineEventTransformer eventTransformer) {
        ArrayList<CmdLineOption> compositeOptions = new ArrayList<CmdLineOption>();
        Collection<CmdLineOption> mandatoryOptions = eventTransformer.getMandatoryOptions();
        Preconditions.checkState((mandatoryOptions != null ? 1 : 0) != 0, (Object)"Mandatory options needs to be not null (can be empty)");
        for (CmdLineOption o : mandatoryOptions) {
            compositeOptions.add(o);
        }
        return compositeOptions;
    }

    private ImmutableList<OptionSpec<?>> getSpecsOnlyForOptions(Iterator<OptionSpec<?>> specIterator, int numberOfArguments) {
        ImmutableList optionSpecs = ImmutableList.copyOf(specIterator);
        ArrayList filteredOptionSpecs = new ArrayList();
        for (OptionSpec optionSpec : optionSpecs) {
            filteredOptionSpecs.addAll(this.getOptionsIfValid(optionSpec));
        }
        return ImmutableList.copyOf(filteredOptionSpecs);
    }

    private Collection<OptionSpec<?>> getOptionsIfValid(OptionSpec<?> optionSpec) {
        return this.isNotANonOptionArgument(optionSpec) ? Collections.singleton(optionSpec) : Collections.emptyList();
    }

    private boolean isNotANonOptionArgument(OptionSpec optionSpec) {
        return !optionSpec.options().equals(Collections.singletonList(STANDALONE_ARGUMENT_SPECIAL_OPTION_PLACEHOLDER));
    }

    private Collection<CmdLineOption> getMultiValueOptions(String optionName, List<?> values, CommandLineEventTransformer eventTransformer) {
        ArrayList<CmdLineOption> list = new ArrayList<CmdLineOption>();
        for (Object value : values) {
            CmdLineOption inputOption = CmdLineOption.withArgument(optionName, value.toString());
            Collection<CmdLineOption> outputOptions = eventTransformer.transformOption(inputOption);
            Preconditions.checkState((outputOptions != null ? 1 : 0) != 0);
            list.addAll(outputOptions);
        }
        return list;
    }
}

