/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.crx2oak.cli.transformer;

import com.adobe.granite.crx2oak.cli.CRX2OakOption;
import com.adobe.granite.crx2oak.cli.CmdLineOption;
import com.adobe.granite.crx2oak.cli.transformer.CommandLineEventTransformer;
import com.adobe.granite.crx2oak.cli.transformer.CommandLineOptionsTransformerEngine;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import joptsimple.OptionSet;

public class CommandLineTransformerEngine {
    private final CommandLineOptionsTransformerEngine commandLineOptionsTransformerEngine;

    public CommandLineTransformerEngine(CommandLineOptionsTransformerEngine commandLineOptionsTransformerEngine) {
        Preconditions.checkNotNull((Object)commandLineOptionsTransformerEngine, (Object)"The CL option Transformer Engine cannot be null");
        this.commandLineOptionsTransformerEngine = commandLineOptionsTransformerEngine;
    }

    @Nonnull
    public String[] transformIntoCommandLine(@Nonnull OptionSet optionSet, @Nonnull CommandLineEventTransformer eventTransformer) {
        Preconditions.checkNotNull((Object)optionSet, (Object)"Option Set object cannot be null");
        Preconditions.checkNotNull((Object)eventTransformer, (Object)"The Command Line Event Transformer cannot be null");
        ArrayList<String> newCommandLineArgs = new ArrayList<String>();
        newCommandLineArgs.addAll(this.getTransformedOptionsAsStrings(optionSet, eventTransformer));
        newCommandLineArgs.addAll(this.getTransformedArgumentsAsStrings(optionSet, eventTransformer));
        return this.convertListToArray(newCommandLineArgs);
    }

    private String[] convertListToArray(List<String> newCommandLineArgs) {
        return newCommandLineArgs.toArray(new String[0]);
    }

    private Collection<String> getTransformedArgumentsAsStrings(OptionSet optionSet, CommandLineEventTransformer eventTransformer) {
        return eventTransformer.transformArguments(optionSet);
    }

    private List<String> getTransformedOptionsAsStrings(OptionSet optionSet, CommandLineEventTransformer eventTransformer) {
        Collection<CmdLineOption> outputOptions = this.commandLineOptionsTransformerEngine.transformOptions(optionSet, eventTransformer);
        return new ArrayList<String>(this.getCommandLineArgumentsAsStrings(outputOptions));
    }

    private Collection<String> getCommandLineArgumentsAsStrings(Collection<CmdLineOption> cmdLineOptions) {
        ArrayList<String> newCmdLineArgs = new ArrayList<String>();
        for (CmdLineOption transformedOption : cmdLineOptions) {
            newCmdLineArgs.add(CRX2OakOption.getDashedOptionFor(transformedOption.getOption()));
            if (!transformedOption.hasArgument()) continue;
            newCmdLineArgs.add(transformedOption.getArgument());
        }
        return newCmdLineArgs;
    }
}

