/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.crx2oak.core;

import com.adobe.granite.crx2oak.model.Topics;
import com.adobe.granite.crx2oak.oak.OakTopics;
import com.adobe.granite.crx2oak.pipeline.InputAggregatingComponent;
import com.adobe.granite.crx2oak.pipeline.PipeData;
import com.adobe.granite.crx2oak.pipeline.Pipeline;
import com.adobe.granite.crx2oak.pipeline.PipelineComponent;
import com.adobe.granite.crx2oak.util.FilesystemOps;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.jackrabbit.oak.upgrade.cli.parser.MigrationCliArguments;
import org.apache.jackrabbit.oak.upgrade.cli.parser.StoreArguments;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DestinationDirectoryCreator
extends InputAggregatingComponent {
    private static final Logger LOGGER = LoggerFactory.getLogger(DestinationDirectoryCreator.class);
    private static final int MIN_SRC_DST_ARGS_NUMBER = 2;
    private final FilesystemOps filesystemOps;

    public DestinationDirectoryCreator(@Nonnull FilesystemOps filesystemOps) {
        this.filesystemOps = (FilesystemOps)Preconditions.checkNotNull((Object)filesystemOps);
    }

    @Override
    protected PipeData preprocess(PipeData input) {
        return (PipeData)this.getDestinationDirectoryToCreate(input).transform(this.getDirectoryCreationSchedulerFunction(input)).or((Object)PipeData.EMPTY);
    }

    private Optional<String> getDestinationDirectoryToCreate(PipeData input) {
        return this.getQuickstartDirectoryToCreate(input.require(OakTopics.ARGS), input.require(OakTopics.STORE_ARGS));
    }

    private Optional<String> getQuickstartDirectoryToCreate(MigrationCliArguments cliArgs, StoreArguments stores) {
        return this.isDestinationDirectoryToBeCreated(stores) ? this.getLastArgumentIfMultipleOrNull(cliArgs) : Optional.absent();
    }

    private Function<String, PipeData> getDirectoryCreationSchedulerFunction(final PipeData input) {
        return new Function<String, PipeData>(){

            @Nullable
            public PipeData apply(@Nullable String path) {
                return DestinationDirectoryCreator.this.getDirectoryCreatorInPreUpgradeTasksOrCloseStream(input, path);
            }
        };
    }

    private PipeData getDirectoryCreatorInPreUpgradeTasksOrCloseStream(PipeData input, String destinationPath) {
        try {
            return this.getPipeDataWithDirectoryCreator(input, destinationPath);
        }
        catch (IOException e) {
            LOGGER.error("Could not schedule directory creation due to I/O error", (Throwable)e);
            return Pipeline.streamClosed();
        }
    }

    private PipeData getPipeDataWithDirectoryCreator(PipeData input, String destinationPath) throws IOException {
        LOGGER.debug("Scheduling creation of destination directory before migration: {}", (Object)destinationPath);
        PipelineComponent creator = this.filesystemOps.createSafeDirectoryCreator(new File(destinationPath));
        return PipeData.join(input, Topics.PRE_MIGRATION_ACTIONS, creator).toPipe();
    }

    private boolean isDestinationDirectoryToBeCreated(StoreArguments storeArguments) {
        return !storeArguments.isInPlaceUpgrade() && this.isDestinationRepositoryOnFilesystem(storeArguments);
    }

    private boolean isDestinationRepositoryOnFilesystem(StoreArguments storeArguments) {
        return storeArguments.getDstType().isSegment();
    }

    private Optional<String> getLastArgumentIfMultipleOrNull(MigrationCliArguments cliArgs) {
        List args = cliArgs.getArguments();
        return args.size() >= 2 ? Optional.of(args.get(args.size() - 1)) : Optional.absent();
    }
}

