/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.crx2oak.core;

import com.adobe.granite.crx2oak.cli.CRX2OakOption;
import com.adobe.granite.crx2oak.model.Topics;
import com.adobe.granite.crx2oak.oak.OakTopics;
import com.adobe.granite.crx2oak.oak.OakUtils;
import com.adobe.granite.crx2oak.pipeline.InputAggregatingComponent;
import com.adobe.granite.crx2oak.pipeline.PipeData;
import com.adobe.granite.crx2oak.pipeline.Pipeline;
import com.adobe.granite.crx2oak.pipeline.PipelineComponent;
import com.adobe.granite.crx2oak.pipeline.WrappingPipelineComponent;
import com.adobe.granite.crx2oak.util.FilesystemOps;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.jackrabbit.oak.upgrade.cli.parser.MigrationCliArguments;
import org.apache.jackrabbit.oak.upgrade.cli.parser.StoreArguments;
import org.apache.jackrabbit.oak.upgrade.cli.parser.StoreType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DestinationRepositoryActivator
extends InputAggregatingComponent {
    private static final Logger LOGGER = LoggerFactory.getLogger(DestinationRepositoryActivator.class);
    private static final String BACKUP_PARTIAL_SUFFIX = "crx2oak-";
    private static final int MIN_SRC_DST_ARGS_NUMBER = 2;
    private final FilesystemOps filesystemOps;

    public DestinationRepositoryActivator(@Nonnull FilesystemOps filesystemOps) {
        this.filesystemOps = (FilesystemOps)Preconditions.checkNotNull((Object)filesystemOps);
    }

    @Override
    protected PipeData preprocess(PipeData input) {
        return (PipeData)this.getRepositoriesToReplace(input).transform(this.getRepositoryReplaceSchedulerFunction(input)).or((Object)PipeData.EMPTY);
    }

    private Function<Pair<File, File>, PipeData> getRepositoryReplaceSchedulerFunction(final PipeData input) {
        return new Function<Pair<File, File>, PipeData>(){

            @Nullable
            public PipeData apply(@Nullable Pair<File, File> paths) {
                return DestinationRepositoryActivator.this.getDirectorySwitcherInPostUpgradeTasksOrCloseStream(input, (Pair<File, File>)paths);
            }
        };
    }

    private PipeData getDirectorySwitcherInPostUpgradeTasksOrCloseStream(PipeData input, Pair<File, File> paths) {
        try {
            return PipeData.join(input, Topics.POST_MIGRATION_ACTIONS, this.getDirectorySwitcherAction(paths)).toPipe();
        }
        catch (IOException e) {
            LOGGER.error("Cannot schedule repository replace process after migration", (Throwable)e);
            return Pipeline.streamClosed();
        }
    }

    private PipelineComponent getDirectorySwitcherAction(final Pair<File, File> paths) throws IOException {
        LOGGER.info("The current repository: {} will be replaced by migrated one: {}", paths.getLeft(), paths.getRight());
        return new WrappingPipelineComponent(this.filesystemOps.createDirectoryElementsSwitcher((File)paths.getLeft(), (File)paths.getRight(), BACKUP_PARTIAL_SUFFIX)){

            @Override
            @Nonnull
            public PipeData preprocess(@Nonnull PipeData input) {
                LOGGER.info("Activating: [{}] repository as: [{}]", paths.getRight(), paths.getLeft());
                return input;
            }
        };
    }

    private Optional<Pair<File, File>> getRepositoriesToReplace(PipeData input) {
        return input.require(Topics.OPTION_SET).has(CRX2OakOption.REPLACE.option) ? this.getRepositoriesToReplaceFromSpec(input.require(OakTopics.ARGS), input.require(OakTopics.STORE_ARGS)) : Optional.absent();
    }

    private Optional<Pair<File, File>> getRepositoriesToReplaceFromSpec(MigrationCliArguments cliArgs, StoreArguments storeArguments) {
        return this.isSourceDirectoryToBeReplaced(storeArguments) ? this.getRepositoryArguments(cliArgs, storeArguments) : Optional.absent();
    }

    private boolean isSourceDirectoryToBeReplaced(StoreArguments storeArguments) {
        return !storeArguments.isInPlaceUpgrade() && this.isDestinationRepositoryOnFilesystem(storeArguments) && this.isSourceRepositoryOnFilesystem(storeArguments);
    }

    private boolean isDestinationRepositoryOnFilesystem(StoreArguments storeArguments) {
        return storeArguments.getDstType().isSegment();
    }

    private boolean isSourceRepositoryOnFilesystem(StoreArguments storeArguments) {
        return storeArguments.getSrcType().isSegment() || storeArguments.getSrcType() == StoreType.JCR2_DIR_XML;
    }

    private Optional<Pair<File, File>> getRepositoryArguments(MigrationCliArguments cliArgs, StoreArguments storeArguments) {
        List args = cliArgs.getArguments();
        return args.size() >= 2 ? Optional.of(this.getSrcDstRepoPair(storeArguments, args)) : Optional.absent();
    }

    private Pair<File, File> getSrcDstRepoPair(StoreArguments storeArguments, List<String> args) {
        LOGGER.trace("Getting repository paths from: {}", args);
        return Pair.of((Object)new File(this.getSrcRepo(storeArguments)), (Object)new File(this.getDstRepo(args)));
    }

    private String getDstRepo(List<String> args) {
        return args.get(args.size() - 1);
    }

    private String getSrcRepo(StoreArguments storeArguments) {
        return OakUtils.normalizeArgumentToPath(storeArguments.getSrcPaths()[0]);
    }
}

