/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.crx2oak.core;

import com.adobe.granite.crx2oak.cli.CRX2OakOption;
import com.adobe.granite.crx2oak.model.MigrationMode;
import com.adobe.granite.crx2oak.model.Topics;
import com.adobe.granite.crx2oak.pipeline.PipeData;
import com.adobe.granite.crx2oak.pipeline.Pipeline;
import com.adobe.granite.crx2oak.pipeline.PipelineComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DryModeBreaker
implements PipelineComponent {
    private static final Logger LOGGER = LoggerFactory.getLogger(DryModeBreaker.class);

    @Override
    public PipeData process(PipeData input) {
        return this.shouldAppBeAborted(input) ? this.abortProcessing(input) : input;
    }

    private PipeData abortProcessing(PipeData input) {
        LOGGER.info("The tool is running in {} and real migration is skipped for this invocation.", (Object)this.getMigrationMode(input));
        LOGGER.info("If you have backup and you are sure what you are doing please remove: {} option", (Object)CRX2OakOption.DRY.dashedOption);
        LOGGER.info("or pass {} if you haven't specified any other command line argument to use default migration profile", (Object)CRX2OakOption.MIGRATE.dashedOption);
        return Pipeline.streamClosed(input);
    }

    private boolean shouldAppBeAborted(PipeData input) {
        return this.getMigrationMode(input) != MigrationMode.WET_MIGRATE_MIGRATION_MODE || input.require(Topics.OPTION_SET).has(CRX2OakOption.DRY.option);
    }

    private MigrationMode getMigrationMode(PipeData input) {
        return (MigrationMode)((Object)input.get(Topics.MIGRATION_MODE).or((Object)MigrationMode.DRY_PREPARE_MIGRATION_MODE));
    }
}

