/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.crx2oak.core;

import com.adobe.granite.crx2oak.cli.CRX2OakOption;
import com.adobe.granite.crx2oak.model.RunMode;
import com.adobe.granite.crx2oak.model.Topics;
import com.adobe.granite.crx2oak.pipeline.InputAggregatingComponent;
import com.adobe.granite.crx2oak.pipeline.PipeData;
import com.adobe.granite.crx2oak.pipeline.Pipeline;
import com.adobe.granite.crx2oak.pipeline.PipelineComponent;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nonnull;
import joptsimple.OptionSet;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.oak.upgrade.cli.CliUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HelpPrinter
extends InputAggregatingComponent {
    private static final Logger log = LoggerFactory.getLogger(HelpPrinter.class);
    private static final int DEFAULT_INDENT_LEVEL = 26;
    private static final String USAGE_TOKEN = "Usage: ";
    private static final String USAGE_SECTION_INDENT = StringUtils.repeat((String)" ", (int)"Usage: ".length());
    private static final String NEW_LINE = "\n";
    private final PipelineComponent versionDisplayProcessor;

    public HelpPrinter(@Nonnull PipelineComponent versionDisplayProcessor) {
        this.versionDisplayProcessor = Objects.requireNonNull(versionDisplayProcessor);
    }

    @Override
    public PipeData preprocess(PipeData input) {
        OptionSet options = input.require(Topics.OPTION_SET);
        RunMode runMode = (RunMode)((Object)input.get(Topics.RUN_MODE).or((Object)RunMode.STANDALONE));
        return this.isHelpOptionSet(options) || this.areOptionsOrArgumentsNotSufficient(options, runMode) ? this.displayUsage(input, runMode) : PipeData.EMPTY;
    }

    private PipeData displayUsage(PipeData input, RunMode runMode) {
        try {
            return Pipeline.streamClosed(this.displayUsageUnchecked(input, runMode));
        }
        catch (IOException e) {
            System.err.println("Cannot display usage");
            log.error("Cannot display tools usage: ", (Throwable)e);
            return Pipeline.streamClosed();
        }
    }

    private String getQuickstartExtensionUsage() {
        return "${command} [profile options and other options]\n" + USAGE_SECTION_INDENT + "(in quickstart extension mode source and destination are auto-detected hence optional)" + NEW_LINE;
    }

    private boolean isHelpOptionSet(OptionSet options) {
        return options.has("help");
    }

    private PipeData displayUsageUnchecked(PipeData input, RunMode runMode) throws IOException {
        PipeData output = this.versionDisplayProcessor.process(input);
        System.out.println(this.getPostProcessedOakUpgradeUsagePerRunMode(runMode));
        System.out.println();
        CRX2OakOption.printOptionUsages(System.out, 26);
        return output;
    }

    private String getPostProcessedOakUpgradeUsagePerRunMode(RunMode runMode) throws IOException {
        String builtInOakUpgradeUSage = CliUtils.getUsage();
        String usage = this.transformUsagePerRunMode(builtInOakUpgradeUSage, runMode);
        return usage.replace("${command}", "java -jar crx2oak.jar");
    }

    private String transformUsagePerRunMode(String usage, RunMode runMode) {
        return runMode == RunMode.QUICKSTART_EXTENSION ? usage.replace(USAGE_TOKEN, this.getUsagePrefixReplacementForQuickstartExtension()) : usage;
    }

    private String getUsagePrefixReplacementForQuickstartExtension() {
        return USAGE_TOKEN + this.getQuickstartExtensionUsage() + NEW_LINE + USAGE_SECTION_INDENT;
    }

    private boolean areOptionsOrArgumentsNotSufficient(OptionSet options, RunMode runMode) {
        return runMode != RunMode.QUICKSTART_EXTENSION && options.nonOptionArguments().isEmpty() && !options.has(CRX2OakOption.SAVE_PROFILE.option);
    }
}

