/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.crx2oak.core;

import com.adobe.granite.crx2oak.cli.CRX2OakOption;
import com.adobe.granite.crx2oak.model.Topics;
import com.adobe.granite.crx2oak.oak.OakTopics;
import com.adobe.granite.crx2oak.oak.OakUtils;
import com.adobe.granite.crx2oak.pipeline.InputAggregatingComponent;
import com.adobe.granite.crx2oak.pipeline.PipeData;
import com.adobe.granite.crx2oak.pipeline.Pipeline;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.jackrabbit.oak.upgrade.cli.parser.CliArgumentException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigrationSpecGenerator
extends InputAggregatingComponent {
    private static final String[] BLANK_CMD_LINE = new String[0];
    private static final Logger LOGGER = LoggerFactory.getLogger(MigrationSpecGenerator.class);

    @Override
    public PipeData preprocess(PipeData input) {
        List<Object> effectiveCmdLine = Arrays.asList((Object[])input.get(Topics.CMD_LINE_ARGS).or((Object)BLANK_CMD_LINE));
        LOGGER.info("The effective command line for migration: {}", effectiveCmdLine);
        try {
            return this.logEnabledOptions(OakUtils.updateAllOakTopics(input));
        }
        catch (CliArgumentException e) {
            return this.returnPipelineClosed((Exception)((Object)e), "detected");
        }
        catch (IOException e) {
            return this.returnPipelineClosed(e, "I/O");
        }
    }

    private PipeData returnPipelineClosed(Exception e, String errPrefix) {
        LOGGER.error(String.format("%s error during processing migration specification: %s", errPrefix, e.getMessage()));
        return Pipeline.streamClosed();
    }

    private PipeData logEnabledOptions(PipeData output) {
        CRX2OakOption.logEnabledOptions(LOGGER, output.require(Topics.OPTION_SET));
        output.require(OakTopics.OPTS).logOptions();
        output.require(OakTopics.STORE_ARGS).logOptions();
        return output;
    }
}

