/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.crx2oak.core;

import com.adobe.granite.crx2oak.cli.CRX2OakOption;
import com.adobe.granite.crx2oak.model.RunMode;
import com.adobe.granite.crx2oak.model.Topics;
import com.adobe.granite.crx2oak.pipeline.InputAggregatingComponent;
import com.adobe.granite.crx2oak.pipeline.PipeData;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreArgsProvider
extends InputAggregatingComponent {
    private static final Logger LOGGER = LoggerFactory.getLogger(StoreArgsProvider.class);
    private static final int ONE_ARGUMENT = 1;
    private static final int FIRST_ELEMENT_INDEX = 0;
    private static final int ONE_ELEMENT_OFFSET = 1;
    private static final String SLING_HOME_REPOSITORY_LOCATION = "repository";
    public static final String AUTO_COMPLETED_DESTINATION_ARGUMENT_SUFFIX = "";

    @Override
    protected PipeData preprocess(PipeData input) {
        PipeData output = this.processAutocompleteIfPossible(input);
        this.informUserIfOneArgumentAmbiguousAndNeedsToBeTaggedAsSourceOrDest(input);
        return output;
    }

    private void informUserIfOneArgumentAmbiguousAndNeedsToBeTaggedAsSourceOrDest(PipeData input) {
        if (this.isInQuickstartExtensionMode(input.require(Topics.RUN_MODE)) && this.isOneArgumentProvidedButIsNotMarkedAsEitherSourceOrDestination(input.require(Topics.OPTION_SET))) {
            this.reportAnErrorAboutMissingRoleIdentificationForAmbiguousArgument(input.require(Topics.CMD_LINE_ARGS));
        }
    }

    private PipeData processAutocompleteIfPossible(PipeData input) {
        OptionParser parser = input.require(Topics.OPTION_PARSER);
        return this.isAutocompletionNeededAndRequested(input.require(Topics.OPTION_SET), input.require(Topics.RUN_MODE)) ? this.outputNewStoreArguments(this.autocompleteCommandLineArguments(input), parser) : PipeData.EMPTY;
    }

    private PipeData outputNewStoreArguments(String[] autocompletedCommandLineArguments, OptionParser parser) {
        return PipeData.put(Topics.CMD_LINE_ARGS, autocompletedCommandLineArguments).put(Topics.OPTION_SET, parser.parse(autocompletedCommandLineArguments)).toPipe();
    }

    private boolean isAutocompletionNeededAndRequested(OptionSet options, RunMode runMode) {
        return this.isInQuickstartExtensionMode(runMode) && (this.destinationArgumentNeedsToBeProvided(options) || this.sourceArgumentNeedsToBeProvided(options));
    }

    private boolean isInQuickstartExtensionMode(RunMode runMode) {
        return runMode == RunMode.QUICKSTART_EXTENSION;
    }

    private boolean onlyOneArgumentIsProvided(OptionSet options) {
        return options.nonOptionArguments().size() == 1;
    }

    private boolean customSourceArgumentWasProvided(OptionSet options) {
        return options.has(CRX2OakOption.CUSTOM_SOURCE.option);
    }

    private boolean customDestinationArgumentWasProvided(OptionSet options) {
        return options.has(CRX2OakOption.CUSTOM_DESTINATION.option);
    }

    private boolean sourceArgumentNeedsToBeProvided(OptionSet optionSet) {
        return this.requiredArgumentsAreNotSpecified(optionSet) || this.onlySourceArgumentNeedsToBeProvided(optionSet);
    }

    private boolean onlySourceArgumentNeedsToBeProvided(OptionSet optionSet) {
        return this.onlyOneArgumentIsProvided(optionSet) && this.customDestinationArgumentWasProvided(optionSet) && !this.customSourceArgumentWasProvided(optionSet);
    }

    private boolean destinationArgumentNeedsToBeProvided(OptionSet optionSet) {
        return this.requiredArgumentsAreNotSpecified(optionSet) || this.onlyDestinationArgumentNeedsToBeProvided(optionSet);
    }

    private boolean onlyDestinationArgumentNeedsToBeProvided(OptionSet optionSet) {
        return this.onlyOneArgumentIsProvided(optionSet) && this.customSourceArgumentWasProvided(optionSet) && !this.customDestinationArgumentWasProvided(optionSet);
    }

    private boolean requiredArgumentsAreNotSpecified(OptionSet options) {
        return options.nonOptionArguments().isEmpty();
    }

    private String[] autocompleteCommandLineArguments(PipeData input) {
        Map<String, String> detectionOpts = input.require(Topics.SLING_HOME_DETECTION_OPTIONS);
        String[] cmdlineArgs = input.require(Topics.CMD_LINE_ARGS);
        return input.get(Topics.SLING_HOME).isPresent() ? this.autocompleteArguments(input) : this.doNotAutocompleteAndReportSlingHomeMissingError(detectionOpts.toString(), cmdlineArgs);
    }

    private boolean isOneArgumentProvidedButIsNotMarkedAsEitherSourceOrDestination(OptionSet parsedOptions) {
        return this.onlyOneArgumentIsProvided(parsedOptions) && !this.sourceOrDestinationOptionWasProvided(parsedOptions);
    }

    private boolean sourceOrDestinationOptionWasProvided(OptionSet parsedOptions) {
        return this.customSourceArgumentWasProvided(parsedOptions) || this.customDestinationArgumentWasProvided(parsedOptions);
    }

    private String[] autocompleteArguments(PipeData input) {
        OptionSet options = input.require(Topics.OPTION_SET);
        String[] cmdLineArgs = input.require(Topics.CMD_LINE_ARGS);
        String slingHome = input.require(Topics.SLING_HOME);
        List<String> argumentsToComplete = this.getArgumentsToComplete(options, cmdLineArgs);
        String sourceArgumentToAutocomplete = this.getStoreArgumentFromSlingHome(slingHome);
        LOGGER.debug("The auto-detected repository is: {}. Trying to apply it to source and/or destination argument.", (Object)sourceArgumentToAutocomplete);
        String source = this.getFinalSourceArgument(options, cmdLineArgs, sourceArgumentToAutocomplete);
        LOGGER.debug("The final source repository is set to: {}", (Object)source);
        String destination = this.getFinalDestinationArgument(options, cmdLineArgs, this.getDestinationArgumentToAutocomplete(options, sourceArgumentToAutocomplete));
        LOGGER.debug("The final destination repository is set to: {}", (Object)destination);
        Iterable finalArgumentsList = Iterables.concat(argumentsToComplete, Arrays.asList(source, destination));
        return (String[])Iterables.toArray((Iterable)finalArgumentsList, String.class);
    }

    private String getDestinationArgumentToAutocomplete(OptionSet parsedOptions, String sourceArgumentToAutocomplete) {
        return this.onlyDestinationArgumentNeedsToBeProvided(parsedOptions) ? sourceArgumentToAutocomplete : sourceArgumentToAutocomplete + AUTO_COMPLETED_DESTINATION_ARGUMENT_SUFFIX;
    }

    private String getFinalDestinationArgument(OptionSet parsedOptions, String[] commandLineArguments, String argumentToAutocomplete) {
        return this.destinationArgumentNeedsToBeProvided(parsedOptions) ? argumentToAutocomplete : this.alreadyProvidedArgument(commandLineArguments);
    }

    private String getFinalSourceArgument(OptionSet parsedOptions, String[] commandLineArguments, String argumentToAutocomplete) {
        return this.sourceArgumentNeedsToBeProvided(parsedOptions) ? argumentToAutocomplete : this.alreadyProvidedArgument(commandLineArguments);
    }

    private String alreadyProvidedArgument(String[] cmdLineArgs) {
        List<String> allGivenCommandLineOptionsAndArguments = Arrays.asList(cmdLineArgs);
        return allGivenCommandLineOptionsAndArguments.get(this.lastElementIndex(allGivenCommandLineOptionsAndArguments));
    }

    private int lastElementIndex(List<String> allGivenCommandLineOptionsAndArguments) {
        return allGivenCommandLineOptionsAndArguments.size() - 1;
    }

    private List<String> getArgumentsToComplete(OptionSet parsedOptions, String[] commandLineArguments) {
        List<String> allGivenCommandLineOptionsAndArguments = Arrays.asList(commandLineArguments);
        return this.onlyOneArgumentIsProvided(parsedOptions) ? this.withoutLastElement(allGivenCommandLineOptionsAndArguments) : allGivenCommandLineOptionsAndArguments;
    }

    private List<String> withoutLastElement(List<String> args) {
        Preconditions.checkArgument((!args.isEmpty() ? 1 : 0) != 0, (Object)"The list must have at least one element (it must not be empty)");
        return args.subList(0, this.lastElementIndex(args));
    }

    private String[] doNotAutocompleteAndReportSlingHomeMissingError(String slingDetectionOptions, String[] commandLineArguments) {
        return this.doNotAutocompleteAndReportAnError(String.format("Cannot detect Sling home automatically (via %s). Store arguments won't be auto-completed.", slingDetectionOptions), commandLineArguments);
    }

    private void reportAnErrorAboutMissingRoleIdentificationForAmbiguousArgument(String[] commandLineArguments) {
        this.logErrorAndPrintStdErr(String.format("One store argument was provided (%s) but you haven't added required option before this argument whether it is related to source (add option: %s) or destination (add in front option: %s).", this.alreadyProvidedArgument(commandLineArguments), CRX2OakOption.CUSTOM_SOURCE.dashedOption, CRX2OakOption.CUSTOM_DESTINATION.dashedOption));
    }

    private String[] doNotAutocompleteAndReportAnError(String errorMessage, String[] cmdlineArgs) {
        this.logErrorAndPrintStdErr(errorMessage);
        return cmdlineArgs;
    }

    private void logErrorAndPrintStdErr(String message) {
        LOGGER.error(message);
        System.err.println(message);
    }

    private String getStoreArgumentFromSlingHome(String slingHome) {
        return slingHome + File.separator + SLING_HOME_REPOSITORY_LOCATION;
    }
}

