/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.crx2oak.core;

import com.adobe.granite.crx2oak.cli.CRX2OakOption;
import com.adobe.granite.crx2oak.model.Topics;
import com.adobe.granite.crx2oak.pipeline.InputAggregatingComponent;
import com.adobe.granite.crx2oak.pipeline.PipeData;
import com.adobe.granite.crx2oak.pipeline.Pipeline;
import com.adobe.granite.crx2oak.pipeline.PipelineComponent;

public class VersionOptChecker
extends InputAggregatingComponent {
    private final PipelineComponent versionPrinter;

    public VersionOptChecker(PipelineComponent versionPrinter) {
        this.versionPrinter = versionPrinter;
    }

    @Override
    public PipeData preprocess(PipeData input) {
        return input.require(Topics.OPTION_SET).has(CRX2OakOption.VERSION.option) ? this.printVersionAndAbortExecution(input) : PipeData.EMPTY;
    }

    private PipeData printVersionAndAbortExecution(PipeData input) {
        return Pipeline.streamClosed(this.printVersionOnStdOut(input));
    }

    private PipeData printVersionOnStdOut(PipeData input) {
        return this.versionPrinter.process(PipeData.use(input).put(Topics.LOG_APP_VERSION_TO_STDOUT, true).toPipe());
    }
}

