/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.crx2oak.core;

import com.adobe.granite.crx2oak.model.Topics;
import com.adobe.granite.crx2oak.pipeline.PipeData;
import com.adobe.granite.crx2oak.pipeline.PipelineObserver;
import com.adobe.granite.crx2oak.util.CliUtils;
import com.adobe.granite.crx2oak.util.ExtensionInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionPrinter
extends PipelineObserver {
    private static final Logger LOGGER = LoggerFactory.getLogger(VersionPrinter.class);

    @Override
    protected void observe(PipeData input) {
        Boolean stdout = (Boolean)input.get(Topics.LOG_APP_VERSION_TO_STDOUT).or((Object)false);
        this.print(stdout, String.format("CRX2Oak version: %s (%s mode)", new Object[]{CliUtils.getVersion(), input.require(Topics.RUN_MODE)}));
        this.print(stdout, String.format("%s (version: %s, checksum: %s)", ExtensionInfo.getExtensionJarName(), ExtensionInfo.getExtensionVersion(), ExtensionInfo.getExtensionHexadecimalChecksum()));
    }

    private void print(boolean stdout, String msg) {
        if (stdout) {
            System.out.println(msg);
        } else {
            LOGGER.info(msg);
        }
    }
}

