/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.crx2oak.engine;

import com.adobe.granite.crx2oak.engine.crx.CrxUpgradeEngine;
import com.adobe.granite.crx2oak.model.Topics;
import com.adobe.granite.crx2oak.oak.OakTopics;
import com.adobe.granite.crx2oak.pipeline.PipeData;
import com.adobe.granite.crx2oak.pipeline.Pipeline;
import com.adobe.granite.crx2oak.pipeline.PipelineComponent;
import java.io.IOException;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.upgrade.cli.OakUpgrade;
import org.apache.jackrabbit.oak.upgrade.cli.parser.CliArgumentException;
import org.apache.jackrabbit.oak.upgrade.cli.parser.DatastoreArguments;
import org.apache.jackrabbit.oak.upgrade.cli.parser.MigrationOptions;
import org.apache.jackrabbit.oak.upgrade.cli.parser.StoreArguments;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum MigrationEngine implements PipelineComponent
{
    CRX_UPGRADE_ENGINE{

        @Override
        public void doMigration(PipeData input) throws IOException {
            CrxUpgradeEngine crxUpgradeEngine = new CrxUpgradeEngine();
            crxUpgradeEngine.migrateCrx2(input.require(OakTopics.ARGS), input.require(OakTopics.OPTS), input.require(OakTopics.STORE_ARGS), input.require(OakTopics.DATA_STORE_ARGS));
        }
    }
    ,
    OAK_ENGINE{

        @Override
        public void doMigration(PipeData input) throws IOException, CliArgumentException {
            OakUpgrade.migrate((MigrationOptions)input.require(OakTopics.OPTS), (StoreArguments)input.require(OakTopics.STORE_ARGS), (DatastoreArguments)input.require(OakTopics.DATA_STORE_ARGS));
        }
    };

    private static final Logger LOGGER;

    public abstract void doMigration(PipeData var1) throws IOException, CliArgumentException;

    @Override
    public PipeData process(PipeData input) {
        input.require(OakTopics.OPTS);
        input.require(OakTopics.STORE_ARGS);
        input.require(OakTopics.DATA_STORE_ARGS);
        try {
            LOGGER.info("Running migration now");
            Long start = System.currentTimeMillis();
            this.doMigration(input);
            LOGGER.info("Finished migration in {} seconds.", (Object)((System.currentTimeMillis() - start) / 1000L));
            return input;
        }
        catch (IOException e) {
            LOGGER.error("The I/O error occured during migration. The migration process has been aborted and it is not complete!", (Throwable)e);
            return this.abortPipelineWithExitCode(input, 2);
        }
        catch (CliArgumentException e) {
            LOGGER.error("The incorrect command line options error occurred during migration. The process has been aborted and it is not complete!", (Throwable)e);
            return this.abortPipelineWithExitCode(input, 1);
        }
        catch (RuntimeException e) {
            LOGGER.error("The internal error occurred during migration. The migration process has been aborted and it is not complete!", (Throwable)e);
            return this.abortPipelineWithExitCode(input, 3);
        }
    }

    private PipeData abortPipelineWithExitCode(PipeData input, int ioExceptionErrorExitCode) {
        return Pipeline.streamClosed(PipeData.use(input).put(Topics.EXIT_CODE, ioExceptionErrorExitCode).toPipe());
    }

    public static MigrationEngine getMigrationEngineBasedOnScope(@Nonnull StoreArguments storeArguments) {
        return storeArguments.getSrcStore().isJcr2() ? CRX_UPGRADE_ENGINE : OAK_ENGINE;
    }

    static {
        LOGGER = LoggerFactory.getLogger(MigrationEngine.class);
    }
}

