/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.crx2oak.engine;

import com.adobe.granite.crx2oak.engine.MigrationEngine;
import com.adobe.granite.crx2oak.model.Topics;
import com.adobe.granite.crx2oak.oak.OakTopics;
import com.adobe.granite.crx2oak.pipeline.PipeData;
import com.adobe.granite.crx2oak.pipeline.Pipeline;
import com.adobe.granite.crx2oak.pipeline.PipelineComponent;
import com.adobe.granite.crx2oak.pipeline.PipelineExecutor;
import com.adobe.granite.crx2oak.util.MapDBMapFactory;
import java.util.List;
import org.apache.jackrabbit.oak.plugins.document.util.MapFactory;
import org.apache.jackrabbit.oak.upgrade.cli.parser.StoreArguments;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigrationRunner
implements PipelineComponent {
    private static final Logger LOGGER = LoggerFactory.getLogger(MigrationRunner.class);
    private static final String MIGRATION_COMPLETED_NORMAL_MSG = "migration completed";
    private static final String MIGRATION_COMPLETED_MSG = " __   __         __        ___ ___  ___  __  \n/  ` /  \\  |\\/| |__) |    |__   |  |__  |  \\ \n\\__, \\__/  |  | |    |___ |___  |  |___ |__/ ";

    @Override
    public PipeData process(PipeData input) {
        PipeData finalMigrationInput = this.prepareMigrationInput(input);
        List<PipelineComponent> preList = finalMigrationInput.require(Topics.PRE_MIGRATION_ACTIONS);
        List<PipelineComponent> postList = finalMigrationInput.require(Topics.POST_MIGRATION_ACTIONS);
        StoreArguments stores = finalMigrationInput.require(OakTopics.STORE_ARGS);
        LOGGER.info("Starting migration phase with: {} prepare tasks and {} finalize tasks.", (Object)preList.size(), (Object)postList.size());
        return Pipeline.emitPipelineExtensionBy(new PipelineComponent[0]).extending(preList.toArray(new PipelineComponent[0])).extending(this.initializeMigrationEngine(stores)).extending(postList.toArray(new PipelineComponent[0])).outputting(finalMigrationInput).toPipe();
    }

    private MigrationEngine initializeMigrationEngine(StoreArguments stores) {
        MapFactory.setInstance((MapFactory)new MapDBMapFactory());
        return MigrationEngine.getMigrationEngineBasedOnScope(stores);
    }

    private PipeData prepareMigrationInput(PipeData input) {
        return PipeData.use(input).join(input, Topics.POST_MIGRATION_ACTIONS, this.getCompleteMessageComponent()).toPipe();
    }

    private PipelineComponent getCompleteMessageComponent() {
        return new PipelineExecutor(){

            @Override
            protected void run() {
                LOGGER.info(MigrationRunner.MIGRATION_COMPLETED_NORMAL_MSG);
                System.out.println(MigrationRunner.MIGRATION_COMPLETED_MSG);
            }
        };
    }
}

