/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.crx2oak.engine.crx;

import com.day.crx.core.CRXRepositoryImpl;
import com.day.crx.core.config.CRXClusterConfig;
import com.day.crx.persistence.tar.TarPersistenceManager;
import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import javax.jcr.RepositoryException;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.core.RepositoryContext;
import org.apache.jackrabbit.core.config.BeanConfig;
import org.apache.jackrabbit.core.config.ClusterConfig;
import org.apache.jackrabbit.core.fs.FileSystem;
import org.apache.jackrabbit.core.fs.FileSystemException;
import org.apache.jackrabbit.core.fs.FileSystemFactory;
import org.apache.jackrabbit.core.fs.local.LocalFileSystem;
import org.apache.jackrabbit.core.persistence.PersistenceManager;
import org.apache.jackrabbit.oak.upgrade.cli.node.Jackrabbit2Factory;

public class CRX2Factory {
    private final File repositoryDir;
    private final File repositoryFile;

    public CRX2Factory(String repositoryDir, String repositoryFile) {
        if (!Jackrabbit2Factory.isJcr2Repository((String)repositoryDir)) {
            throw new IllegalArgumentException("Repository directory not found: " + repositoryDir);
        }
        this.repositoryDir = new File(repositoryDir);
        this.repositoryFile = new File(repositoryFile);
        if (!Jackrabbit2Factory.isRepositoryXml((String)repositoryFile)) {
            throw new IllegalArgumentException("Repository configuration not found: " + repositoryFile);
        }
    }

    public RepositoryContext create(Closer closer) throws IOException, FileSystemException, RepositoryException {
        CRXClusterConfig ccc;
        ClusterConfig cc;
        String defaultWorkspace;
        RepositoryContext context = CRXRepositoryImpl.create((File)this.repositoryDir, (File)this.repositoryFile);
        PersistenceManager pm = context.getWorkspaceInfo(defaultWorkspace = context.getRepositoryConfig().getDefaultWorkspaceName()).getPersistenceManager();
        if (pm instanceof TarPersistenceManager) {
            ((TarPersistenceManager)pm).setAutoOptimizeAt(null);
        }
        closer.register(this.asCloseable(context));
        FileSystem fs = context.getFileSystem();
        if (!fs.isFolder("/namespaces") && (cc = context.getRepositoryConfig().getClusterConfig()) instanceof CRXClusterConfig && !(ccc = (CRXClusterConfig)cc).isSharedNothing()) {
            FileSystem sharedFS = null;
            String sharedPath = ccc.getSharedPath();
            FileSystemFactory fsf = ccc.getClusterFileSystemFactory();
            if (fsf != null) {
                sharedFS = fsf.getFileSystem();
            } else if (sharedPath != null) {
                Properties properties = new Properties();
                properties.setProperty("path", sharedPath);
                BeanConfig config = new BeanConfig(LocalFileSystem.class.getName(), properties);
                sharedFS = (FileSystem)config.newInstance(FileSystem.class);
                sharedFS.init();
            }
            if (sharedFS != null) {
                fs.createFolder("/namespaces");
                CRX2Factory.copy(sharedFS, fs, "/namespaces/ns_reg.properties");
                CRX2Factory.copy(sharedFS, fs, "/namespaces/ns_idx.properties");
            }
        }
        return context;
    }

    public File getRepositoryDir() {
        return this.repositoryDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copy(FileSystem source, FileSystem target, String path) throws IOException, FileSystemException {
        if (source.isFile(path) && !target.isFile(path)) {
            try (InputStream input = source.getInputStream(path);
                 OutputStream output = target.getOutputStream(path);){
                IOUtils.copy((InputStream)input, (OutputStream)output);
            }
        }
    }

    private Closeable asCloseable(final RepositoryContext context) {
        return new Closeable(){

            @Override
            public void close() throws IOException {
                context.getRepository().shutdown();
            }
        };
    }

    public String toString() {
        return String.format("CRX2[%s, %s]", this.repositoryDir, this.repositoryFile);
    }
}

