/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.crx2oak.engine.crx;

import com.adobe.granite.crx2oak.auth.UniquePrincipalNameHook;
import com.adobe.granite.crx2oak.cli.CRX2OakOption;
import com.adobe.granite.crx2oak.engine.crx.CRX2Factory;
import com.adobe.granite.crx2oak.ldap.LdapAuthorizableCommitHook;
import com.adobe.granite.crx2oak.ldap.LdapConfiguration;
import com.adobe.granite.crx2oak.sling.SlingFolderHook;
import com.google.common.io.Closer;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.jcr.RepositoryException;
import javax.naming.InvalidNameException;
import org.apache.jackrabbit.core.RepositoryContext;
import org.apache.jackrabbit.core.fs.FileSystemException;
import org.apache.jackrabbit.oak.plugins.blob.datastore.DataStoreBlobStore;
import org.apache.jackrabbit.oak.spi.blob.BlobStore;
import org.apache.jackrabbit.oak.spi.commit.CommitHook;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.apache.jackrabbit.oak.upgrade.RepositoryUpgrade;
import org.apache.jackrabbit.oak.upgrade.cli.MigrationFactory;
import org.apache.jackrabbit.oak.upgrade.cli.parser.DatastoreArguments;
import org.apache.jackrabbit.oak.upgrade.cli.parser.MigrationCliArguments;
import org.apache.jackrabbit.oak.upgrade.cli.parser.MigrationOptions;
import org.apache.jackrabbit.oak.upgrade.cli.parser.StoreArguments;
import org.osgi.framework.InvalidSyntaxException;

public class CRX2MigrationFactory
extends MigrationFactory {
    private final CommitHook ldapHook;

    public CRX2MigrationFactory(MigrationCliArguments args, MigrationOptions opts, StoreArguments stores, DatastoreArguments dataStores, Closer closer) throws IOException {
        super(opts, stores, dataStores, closer);
        this.ldapHook = this.createLdapHook(args.hasOption(CRX2OakOption.LDAP.option), args.getOption(CRX2OakOption.LDAP_CONFIG.option));
    }

    public RepositoryUpgrade createUpgrade() throws IOException, RepositoryException {
        RepositoryContext src;
        String[] paths = this.stores.getSrcPaths();
        try {
            src = new CRX2Factory(paths[0], paths[1]).create(this.closer);
        }
        catch (FileSystemException e) {
            throw new IOException(e);
        }
        DataStoreBlobStore srcBlobStore = new DataStoreBlobStore(src.getDataStore());
        NodeStore dstStore = this.createTarget(this.closer, (BlobStore)srcBlobStore);
        RepositoryUpgrade upgrade = this.createUpgrade(src, dstStore);
        ArrayList<Object> hooks = new ArrayList<Object>(upgrade.getCustomCommitHooks());
        if (this.ldapHook != null) {
            hooks.add(this.ldapHook);
        }
        hooks.add((Object)new SlingFolderHook());
        hooks.add((Object)new UniquePrincipalNameHook());
        upgrade.setCustomCommitHooks(hooks);
        return upgrade;
    }

    private LdapAuthorizableCommitHook createLdapHook(boolean ldap, String ldapConfig) throws IOException {
        LdapAuthorizableCommitHook ldapHook = null;
        if (ldapConfig != null) {
            LdapConfiguration config;
            try {
                config = new LdapConfiguration(new File(ldapConfig));
            }
            catch (InvalidNameException | InvalidSyntaxException e) {
                throw new IOException(e);
            }
            ldapHook = new LdapAuthorizableCommitHook(config);
        } else if (ldap) {
            ldapHook = new LdapAuthorizableCommitHook();
        }
        return ldapHook;
    }
}

