/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.crx2oak.engine.crx;

import com.adobe.granite.repository.impl.GraniteContent;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.spi.lifecycle.RepositoryInitializer;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;

final class ConfigurableGraniteContent
implements RepositoryInitializer {
    private static final String DISABLED_INDEX_TYPE = "disabled";
    private final String[] disabledIndexes;
    private final GraniteContent wrappedInitializer;

    public ConfigurableGraniteContent(String[] disabledIndexes) {
        this.disabledIndexes = disabledIndexes;
        this.wrappedInitializer = new GraniteContent();
    }

    public void initialize(NodeBuilder builder) {
        this.wrappedInitializer.initialize(builder);
        if (builder.hasChildNode("oak:index")) {
            NodeBuilder index = builder.child("oak:index");
            ConfigurableGraniteContent.disableAllIndexes(index, this.disabledIndexes);
        }
    }

    public static void disableAllIndexes(@Nonnull NodeBuilder index, @Nonnull String[] disabledIndexes) {
        if (disabledIndexes == null) {
            return;
        }
        for (String i : disabledIndexes) {
            ConfigurableGraniteContent.disableIndex(index, i);
        }
    }

    private static void disableIndex(@Nonnull NodeBuilder index, @Nonnull String indexNode) {
        NodeBuilder b;
        if (((NodeBuilder)Preconditions.checkNotNull((Object)index)).hasChildNode((String)Preconditions.checkNotNull((Object)indexNode))) {
            b = index.getChildNode(indexNode);
        } else {
            b = index.child(indexNode);
            b.setProperty("jcr:primaryType", (Object)"oak:QueryIndexDefinition", Type.NAME);
        }
        b.setProperty("type", (Object)DISABLED_INDEX_TYPE, Type.STRING);
    }
}

