/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.crx2oak.engine.crx;

import com.adobe.granite.crx2oak.cli.CRX2OakOption;
import com.adobe.granite.crx2oak.engine.crx.CRX2MigrationFactory;
import com.adobe.granite.crx2oak.engine.crx.ConfigurableGraniteContent;
import com.google.common.collect.Iterators;
import com.google.common.io.Closer;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.ServiceLoader;
import java.util.regex.Pattern;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.oak.spi.lifecycle.CompositeInitializer;
import org.apache.jackrabbit.oak.spi.lifecycle.RepositoryInitializer;
import org.apache.jackrabbit.oak.upgrade.RepositoryUpgrade;
import org.apache.jackrabbit.oak.upgrade.cli.CliUtils;
import org.apache.jackrabbit.oak.upgrade.cli.MigrationFactory;
import org.apache.jackrabbit.oak.upgrade.cli.parser.CliArgumentException;
import org.apache.jackrabbit.oak.upgrade.cli.parser.DatastoreArguments;
import org.apache.jackrabbit.oak.upgrade.cli.parser.MigrationCliArguments;
import org.apache.jackrabbit.oak.upgrade.cli.parser.MigrationOptions;
import org.apache.jackrabbit.oak.upgrade.cli.parser.StoreArguments;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrxUpgradeEngine {
    private static final Logger log = LoggerFactory.getLogger(CrxUpgradeEngine.class);

    public static void backupOldCrx2Files(String repositoryDirPath, boolean preserveDataStore) {
        File repositoryDir = new File(repositoryDirPath);
        File crx2 = new File(repositoryDir, "crx2");
        log.info("Moving existing repository under {}", (Object)crx2.getAbsolutePath());
        crx2.mkdir();
        File datastore = new File(repositoryDir, "repository/datastore");
        File tmpDatastore = new File(repositoryDir, "datastore");
        if (preserveDataStore && datastore.isDirectory()) {
            log.info("Preserving datastore under {}", (Object)datastore.toString());
            datastore.renameTo(tmpDatastore);
        }
        Pattern pattern = Pattern.compile("crx2|segmentstore|datastore");
        for (File file : repositoryDir.listFiles()) {
            String name = file.getName();
            if (pattern.matcher(name).matches()) continue;
            file.renameTo(new File(crx2, name));
        }
        if (preserveDataStore && tmpDatastore.isDirectory()) {
            new File(repositoryDir, "repository").mkdir();
            tmpDatastore.renameTo(datastore);
        }
    }

    private void upgradeFromCrx2(MigrationFactory factory, MigrationCliArguments args) throws IOException, RepositoryException, CliArgumentException {
        RepositoryUpgrade upgrade = factory.createUpgrade();
        upgrade.copy(this.createComponentInitializer(args.getOptionList(CRX2OakOption.DISABLE_INDEXES.option)));
    }

    private RepositoryInitializer createComponentInitializer(String[] disabledIndexes) {
        ServiceLoader<RepositoryInitializer> loader = ServiceLoader.load(RepositoryInitializer.class);
        ArrayList<ConfigurableGraniteContent> initializers = new ArrayList<ConfigurableGraniteContent>();
        initializers.add(new ConfigurableGraniteContent(disabledIndexes));
        Iterators.addAll(initializers, loader.iterator());
        return new CompositeInitializer(initializers);
    }

    public void migrateCrx2(MigrationCliArguments args, MigrationOptions opts, StoreArguments stores, DatastoreArguments dataStores) throws IOException {
        Closer closer = Closer.create();
        CliUtils.handleSigInt((Closer)closer);
        CRX2MigrationFactory migrationFactory = new CRX2MigrationFactory(args, opts, stores, dataStores, closer);
        try {
            this.upgradeFromCrx2(migrationFactory, args);
        }
        catch (Throwable t) {
            throw closer.rethrow(t);
        }
        finally {
            closer.close();
        }
        if (stores.isInPlaceUpgrade()) {
            CrxUpgradeEngine.backupOldCrx2Files(stores.getSrcPaths()[0], this.isPreserveDataStore(dataStores));
        }
    }

    private boolean isPreserveDataStore(DatastoreArguments datastoreArguments) {
        return datastoreArguments.getBlobMigrationCase() == DatastoreArguments.BlobMigrationCase.COPY_REFERENCES;
    }

    public void migrateCrx2() {
    }
}

