/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.crx2oak.ldap;

import com.adobe.granite.crx2oak.ldap.LdapConfiguration;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.plugins.nodetype.TypePredicate;
import org.apache.jackrabbit.oak.spi.commit.DefaultEditor;
import org.apache.jackrabbit.oak.spi.commit.Editor;
import org.apache.jackrabbit.oak.spi.security.user.UserConstants;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class LdapAuthorizableEditor
extends DefaultEditor
implements UserConstants {
    private static final Logger log = LoggerFactory.getLogger(LdapAuthorizableEditor.class);
    private static final String DEFAULT_SUFFIX = ";ldap";
    private static final String REP_EXT_ID = "rep:externalId";
    private final NodeBuilder builder;
    private final LdapConfiguration config;
    private final TypePredicate isGroup;
    private final TypePredicate isUser;

    public LdapAuthorizableEditor(LdapConfiguration config, NodeBuilder rootBuilder, NodeState rootState) {
        this.config = config;
        this.builder = rootBuilder;
        this.isUser = new TypePredicate(rootState, "rep:User");
        this.isGroup = new TypePredicate(rootState, "rep:Group");
    }

    private LdapAuthorizableEditor(LdapAuthorizableEditor editor, NodeBuilder builder) {
        this.config = editor.config;
        this.isGroup = editor.isGroup;
        this.isUser = editor.isUser;
        this.builder = builder;
    }

    public void propertyAdded(PropertyState after) throws CommitFailedException {
        String name = after.getName();
        if ("rep:lastsynced".equals(name)) {
            LdapConfiguration.PrincipalType type;
            NodeState state = this.builder.getNodeState();
            if (this.isGroup.apply(state)) {
                type = LdapConfiguration.PrincipalType.GROUP;
            } else if (this.isUser.apply(state)) {
                type = LdapConfiguration.PrincipalType.USER;
            } else {
                log.warn("Skipping node {}. It's neither group nor user.", (Object)state);
                return;
            }
            String principalName = this.builder.getString("rep:principalName");
            String suffix = this.getPrincipalSuffix(principalName, type);
            if (principalName == null) {
                this.builder.setProperty(REP_EXT_ID, (Object)suffix);
            } else {
                log.info("Using suffix '{}' for authorizable {}", (Object)suffix, (Object)principalName);
                this.builder.setProperty(REP_EXT_ID, (Object)(principalName + suffix));
            }
        }
    }

    public Editor childNodeAdded(String name, NodeState after) throws CommitFailedException {
        return new LdapAuthorizableEditor(this, this.builder.getChildNode(name));
    }

    private String getPrincipalSuffix(String dn, LdapConfiguration.PrincipalType type) {
        if (this.config == null) {
            return DEFAULT_SUFFIX;
        }
        return ';' + this.config.getProviderNameByDn(dn, type);
    }
}

