/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.crx2oak.ldap;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import org.apache.commons.lang.StringUtils;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapConfiguration {
    private static final Logger log = LoggerFactory.getLogger(LdapConfiguration.class);
    private static final Pattern KV = Pattern.compile("^([^=]+)=\"(.+)\"$");
    private final List<ConfigurationEntry> entries;

    public LdapConfiguration(File ldapConfig) throws IOException, InvalidNameException, InvalidSyntaxException {
        this.entries = this.loadConfig(ldapConfig);
        if (this.entries.isEmpty()) {
            throw new IOException("Can't find any LDAPLoginModule entry in the " + ldapConfig.getPath());
        }
    }

    public String getProviderNameByDn(String dn, PrincipalType type) {
        LdapName ldapName;
        ArrayList<String> matching = new ArrayList<String>();
        try {
            ldapName = new LdapName(dn);
        }
        catch (InvalidNameException e) {
            log.warn("Can't parse DN {}.", (Object)dn, (Object)e);
            return this.entries.get(0).getName();
        }
        for (ConfigurationEntry e : this.entries) {
            if (!e.matches(ldapName, type)) continue;
            matching.add(e.getName());
        }
        if (matching.isEmpty()) {
            String firstName = this.entries.get(0).getName();
            log.error("Can't find LDAP login module matching {}. Using first entry: {}", (Object)dn, (Object)firstName);
            return this.entries.get(0).getName();
        }
        if (matching.size() > 1) {
            log.warn("Multiple LDAP login modules matches {}: {}. Using first matching entry.", (Object)dn, matching);
        }
        return (String)matching.get(0);
    }

    public List<ConfigurationEntry> loadConfig(File ldapConfig) throws IOException, InvalidNameException, InvalidSyntaxException {
        try (BufferedReader reader = new BufferedReader(new FileReader(ldapConfig));){
            String line;
            ArrayList<ConfigurationEntry> entries = new ArrayList<ConfigurationEntry>();
            String name = null;
            String groupRoot = null;
            String userRoot = null;
            String groupFilter = null;
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).contains("LDAPLoginModule")) {
                    groupFilter = null;
                    groupRoot = null;
                    userRoot = null;
                    name = null;
                } else if (line.endsWith(";") && name != null) {
                    ConfigurationEntry entry = new ConfigurationEntry(name, userRoot, groupRoot, groupFilter);
                    log.info("Read configuration entry: {}", (Object)entry);
                    entries.add(entry);
                    groupFilter = null;
                    groupRoot = null;
                    userRoot = null;
                    name = null;
                }
                Matcher matcher = KV.matcher(line);
                if (!matcher.matches()) continue;
                String key = matcher.group(1);
                String value = matcher.group(2);
                if ("principal_provider.name".equals(key)) {
                    name = value;
                    continue;
                }
                if ("groupRoot".equals(key)) {
                    groupRoot = value;
                    continue;
                }
                if ("groupFilter".equals(key)) {
                    groupFilter = value;
                    continue;
                }
                if (!"userRoot".equals(key)) continue;
                userRoot = value;
            }
            ArrayList<ConfigurationEntry> arrayList = entries;
            return arrayList;
        }
    }

    public static class ConfigurationEntry {
        private final String name;
        private final LdapName userRoot;
        private final LdapName groupRoot;
        private final Filter groupFilter;

        public ConfigurationEntry(String name, String userRoot, String groupRoot, String groupFilter) throws InvalidSyntaxException, InvalidNameException {
            this.name = name;
            this.userRoot = new LdapName(StringUtils.defaultString((String)userRoot));
            this.groupRoot = new LdapName(StringUtils.defaultString((String)groupRoot));
            if (groupFilter == null) {
                this.groupFilter = null;
            } else {
                log.info("Parsing filter {}", (Object)groupFilter);
                this.groupFilter = FrameworkUtil.createFilter((String)groupFilter);
            }
        }

        public boolean matches(LdapName dn, PrincipalType type) {
            if (type == PrincipalType.USER) {
                return ConfigurationEntry.isAncestor(this.userRoot, dn);
            }
            return ConfigurationEntry.isAncestor(this.groupRoot, dn) && (this.groupFilter == null || this.groupFilter.match(ConfigurationEntry.parseDn(dn)));
        }

        private static boolean isAncestor(LdapName ancestor, LdapName name) {
            for (Rdn ancestorRdn : ancestor.getRdns()) {
                boolean found = false;
                for (Rdn testedRdn : name.getRdns()) {
                    if (!ancestorRdn.equals(testedRdn)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                return false;
            }
            return true;
        }

        private static Dictionary<String, Object> parseDn(LdapName dn) {
            Hashtable<String, Object> dictionary = new Hashtable<String, Object>();
            for (Rdn entry : dn.getRdns()) {
                ((Dictionary)dictionary).put(entry.getType(), entry.getValue());
            }
            ((Dictionary)dictionary).put("objectclass", "group");
            return dictionary;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return "LdapConfiguration[name=" + this.name + ", userRoot=" + this.userRoot + ", groupRoot=" + this.groupRoot + ", groupFilter=" + this.groupFilter + ']';
        }
    }

    public static enum PrincipalType {
        USER,
        GROUP;

    }
}

