/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.crx2oak.logging;

import ch.qos.logback.classic.Level;
import java.util.Arrays;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

enum DeclaredLogLevel {
    TRACE(Level.TRACE),
    DEBUG(Level.DEBUG),
    INFO(Level.INFO),
    WARN(Level.WARN),
    ERROR(Level.ERROR);

    private static final Logger LOGGER;
    private final Level logBackLevel;

    private DeclaredLogLevel(Level logBackLevel) {
        this.logBackLevel = logBackLevel;
    }

    public static DeclaredLogLevel getDeclaredLogLevelFromCommandLineOption(String commandLineOptionValue) {
        return StringUtils.isNotEmpty((String)commandLineOptionValue) ? DeclaredLogLevel.parseCommandLineOption(commandLineOptionValue) : INFO;
    }

    public Level getLogBackLevel() {
        return this.logBackLevel;
    }

    private static DeclaredLogLevel parseCommandLineOption(String commandLineOptionValue) {
        DeclaredLogLevel crx2OakLogDeclaredLogLevel;
        try {
            crx2OakLogDeclaredLogLevel = DeclaredLogLevel.valueOf(commandLineOptionValue.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            LOGGER.error("Incorrect logging level specified: {} (the possibilities are: {})", (Object)commandLineOptionValue.toUpperCase(), Arrays.asList(DeclaredLogLevel.values()));
            crx2OakLogDeclaredLogLevel = INFO;
        }
        return crx2OakLogDeclaredLogLevel;
    }

    static {
        LOGGER = LoggerFactory.getLogger(DeclaredLogLevel.class);
    }
}

