/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.crx2oak.logging;

import ch.qos.logback.classic.Level;
import com.adobe.granite.crx2oak.logging.SimpleLoggingFacade4JProvider;
import com.adobe.granite.crx2oak.pipeline.BlankComponent;
import com.adobe.granite.crx2oak.pipeline.PipelineComponent;
import com.adobe.granite.crx2oak.pipeline.PipelineExecutor;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingLevelControllerFactory {
    public static final PipelineComponent NOP_BLANK_COMPONENT = new BlankComponent();
    private static final Logger LOGGER = LoggerFactory.getLogger(LoggingLevelControllerFactory.class);
    private final SimpleLoggingFacade4JProvider simpleLoggingFacade4JProvider;

    public LoggingLevelControllerFactory(SimpleLoggingFacade4JProvider simpleLoggingFacade4JProvider) {
        this.simpleLoggingFacade4JProvider = (SimpleLoggingFacade4JProvider)Preconditions.checkNotNull((Object)simpleLoggingFacade4JProvider);
    }

    public PipelineComponent createMuteLoggingLevelProcessor(String loggerName) {
        return this.createLogLevelController((String)Preconditions.checkNotNull((Object)loggerName), LogOps.SET_TO_OFF);
    }

    public PipelineComponent createUnmuteLoggingLevelProcessor(String loggerName) {
        return this.createLogLevelController((String)Preconditions.checkNotNull((Object)loggerName), LogOps.RESTORE);
    }

    public PipelineComponent createLogLevelController(String loggerName, LogOperation logOp) {
        Preconditions.checkNotNull((Object)loggerName);
        Preconditions.checkNotNull((Object)logOp);
        ILoggerFactory loggerFactory = this.simpleLoggingFacade4JProvider.getLoggerFactory();
        return loggerFactory == null ? this.returnNullObjectAndReportLoggingFrameworkProblem() : this.createLogLevelController(loggerName, logOp, loggerFactory);
    }

    private PipelineComponent returnNullObjectAndReportLoggingFrameworkProblem() {
        LOGGER.debug("The logger factory seems to be null. Cannot control logs.");
        return NOP_BLANK_COMPONENT;
    }

    private PipelineComponent createLogLevelController(String loggerName, LogOperation logOp, ILoggerFactory loggerFactory) {
        Optional<Level> effectiveLevel = this.getEffectiveLevel(logOp, loggerName, loggerFactory);
        return effectiveLevel.isPresent() ? this.getLogLevelChanger(loggerName, loggerFactory, (Level)effectiveLevel.get()) : NOP_BLANK_COMPONENT;
    }

    private Optional<Level> getEffectiveLevel(LogOperation logOperation, String loggerName, ILoggerFactory loggerFactory) {
        Optional<Level> currentLevel = this.getLogLevel(loggerName, loggerFactory);
        Optional<Level> levelToSet = logOperation.getLogLevelToSet();
        return currentLevel.isPresent() ? Optional.of((Object)(levelToSet.isPresent() ? (Level)levelToSet.get() : (Level)currentLevel.get())) : Optional.absent();
    }

    private PipelineComponent getLogLevelChanger(final String loggerName, final ILoggerFactory loggerFactory, final Level level) {
        return new PipelineExecutor(){

            @Override
            protected void run() {
                LoggingLevelControllerFactory.this.changeLogLevel(loggerName, level, loggerFactory);
            }
        };
    }

    private void changeLogLevel(String loggerName, Level newLevel, ILoggerFactory loggerFactory) {
        Logger apiLogger = loggerFactory.getLogger(loggerName);
        if (apiLogger instanceof ch.qos.logback.classic.Logger) {
            ch.qos.logback.classic.Logger logger = (ch.qos.logback.classic.Logger)loggerFactory.getLogger(loggerName);
            logger.setLevel(newLevel);
        } else {
            LoggingLevelControllerFactory.logIncorrectLoggerImplementation(apiLogger);
        }
    }

    private Optional<Level> getLogLevel(String loggerName, ILoggerFactory loggerFactory) {
        Logger apiLogger = loggerFactory.getLogger(loggerName);
        return apiLogger instanceof ch.qos.logback.classic.Logger ? this.getOptionalLogLevelUnchecked(loggerName, loggerFactory) : this.getEmptyLogLevelAndReportAnIssue(apiLogger);
    }

    private Optional<Level> getOptionalLogLevelUnchecked(String loggerName, ILoggerFactory loggerFactory) {
        ch.qos.logback.classic.Logger logger = (ch.qos.logback.classic.Logger)loggerFactory.getLogger(loggerName);
        return logger != null ? Optional.of((Object)this.getLogLevelOrDefaultOne(logger)) : this.getEmptyLogLevelAndReportAnIssue((Logger)logger);
    }

    private Level getLogLevelOrDefaultOne(ch.qos.logback.classic.Logger logger) {
        return logger.getLevel() != null ? logger.getLevel() : Level.INFO;
    }

    private Optional<Level> getEmptyLogLevelAndReportAnIssue(Logger apiLogger) {
        LoggingLevelControllerFactory.logIncorrectLoggerImplementation(apiLogger);
        return Optional.absent();
    }

    private static void logIncorrectLoggerImplementation(Logger apiLogger) {
        LOGGER.debug("The logger is null or has different implementation: {} than expected: {}", (Object)LoggingLevelControllerFactory.getLoggerClassCanonicalName(apiLogger), (Object)ch.qos.logback.classic.Logger.class.getCanonicalName());
    }

    private static String getLoggerClassCanonicalName(Logger apiLogger) {
        return apiLogger == null ? null : apiLogger.getClass().getCanonicalName();
    }

    public static enum LogOps implements LogOperation
    {
        SET_TO_OFF(Level.OFF),
        RESTORE,
        SET_TO_TRACE(Level.TRACE);

        private final Level logLevel;

        private LogOps() {
            this.logLevel = null;
        }

        private LogOps(Level logLevel) {
            this.logLevel = logLevel;
        }

        @Override
        public Optional<Level> getLogLevelToSet() {
            return Optional.fromNullable((Object)this.logLevel);
        }
    }

    static interface LogOperation {
        public Optional<Level> getLogLevelToSet();
    }
}

