/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.crx2oak.logging;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.encoder.Encoder;
import com.adobe.granite.crx2oak.cli.CRX2OakOption;
import com.adobe.granite.crx2oak.logging.DeclaredLogLevel;
import com.adobe.granite.crx2oak.logging.SimpleLoggingFacade4JProvider;
import com.adobe.granite.crx2oak.model.RunMode;
import com.adobe.granite.crx2oak.model.Topics;
import com.adobe.granite.crx2oak.pipeline.PipeData;
import com.adobe.granite.crx2oak.pipeline.PipelineObserver;
import com.adobe.granite.crx2oak.util.CliUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.io.File;
import java.util.Set;
import javax.annotation.Nonnull;
import joptsimple.OptionSet;
import org.apache.commons.lang.StringUtils;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingRedirector
extends PipelineObserver {
    private static final String UPGRADE_LOG_FILE_PATH = File.separator + "logs" + File.separator + "upgrade.log";
    private static final Set<String> REDIRECTED_LOGGERS = ImmutableSet.of((Object)"com.adobe.granite.crx2oak", (Object)"com.day.crx", (Object)"com.day.io", (Object)"org.apache.jackrabbit");
    private static final Logger LOGGER = LoggerFactory.getLogger(LoggingRedirector.class);
    private static final String DEFAULT_LOGGER_PATTERN = "%date{dd.MM.yyyy HH:mm:ss.SSS} %-7(*%level*) %-40([%logger] %F:%-4L) %msg%n";
    private static final String DEFAULT_LOG_LEVEL_VALUE = "INFO";
    private SimpleLoggingFacade4JProvider simpleLoggingFacade4JProvider;

    public LoggingRedirector(@Nonnull SimpleLoggingFacade4JProvider simpleLoggingFacade4JProvider) {
        this.simpleLoggingFacade4JProvider = (SimpleLoggingFacade4JProvider)Preconditions.checkNotNull((Object)simpleLoggingFacade4JProvider);
    }

    @Override
    public void observe(PipeData input) {
        if (input.get(Topics.RUN_MODE).or((Object)RunMode.STANDALONE) == RunMode.QUICKSTART_EXTENSION) {
            this.redirectLogs(input);
        }
    }

    private void redirectLogs(PipeData input) {
        String logLevelOption = this.getLogLevelOption(input.require(Topics.OPTION_SET));
        DeclaredLogLevel logLevel = DeclaredLogLevel.getDeclaredLogLevelFromCommandLineOption(logLevelOption);
        this.validateSlingHomeAndRedirectLogs((String)input.get(Topics.SLING_HOME).or((Object)""), logLevel);
    }

    private void validateSlingHomeAndRedirectLogs(String slingHome, DeclaredLogLevel logLevel) {
        if (StringUtils.isNotBlank((String)slingHome)) {
            String logs = slingHome + UPGRADE_LOG_FILE_PATH;
            LOGGER.info("logs are going to be redirected to: {} file (using {} level)", (Object)logs, (Object)logLevel);
            this.validateAndRedirectLoggers(logs, logLevel);
        }
    }

    private String getLogLevelOption(OptionSet parsedOptions) {
        return parsedOptions.has(CRX2OakOption.LOG_LEVEL.option) ? (String)Iterables.getLast(CliUtils.getOptionValuesAsStrings(CRX2OakOption.LOG_LEVEL.option, parsedOptions), (Object)DEFAULT_LOG_LEVEL_VALUE) : DEFAULT_LOG_LEVEL_VALUE;
    }

    private void validateAndRedirectLoggers(String file, DeclaredLogLevel declaredLogLevel) {
        ILoggerFactory loggerFactory = this.simpleLoggingFacade4JProvider.getLoggerFactory();
        if (!this.isLogBackAvailable(loggerFactory)) {
            LOGGER.error("Possibly there might be a problem with log redirection to file: {}", (Object)file);
        }
        this.redirectLoggersUsingLoggerFactory(REDIRECTED_LOGGERS, file, declaredLogLevel, loggerFactory);
    }

    private boolean isLogBackAvailable(ILoggerFactory loggerFactory) {
        return loggerFactory instanceof LoggerContext;
    }

    private void redirectLoggersUsingLoggerFactory(Set<String> loggers, String file, DeclaredLogLevel declaredLogLevel, ILoggerFactory loggerFactory) {
        Logger rootApiLogger = this.getLoggerFromFactory(loggerFactory, "ROOT");
        if (rootApiLogger instanceof ch.qos.logback.classic.Logger) {
            this.redirectLogbackLogger(loggers, file, declaredLogLevel, loggerFactory, (ch.qos.logback.classic.Logger)rootApiLogger);
        } else {
            LoggingRedirector.logIncorrectLoggerImplementation("root logger", rootApiLogger);
        }
    }

    private Logger getLoggerFromFactory(ILoggerFactory loggerFactory, String rootLoggerName) {
        return loggerFactory == null ? null : loggerFactory.getLogger(rootLoggerName);
    }

    private void redirectLogbackLogger(Set<String> loggers, String file, DeclaredLogLevel declaredLogLevel, ILoggerFactory loggerContext, ch.qos.logback.classic.Logger rootApiLogger) {
        FileAppender<ILoggingEvent> fileAppender = this.getFileAppenderWithPatternLayoutEncoder(file, rootApiLogger);
        Level level = this.getLoggingLevel(declaredLogLevel);
        this.redirectLoggers(loggers, loggerContext, fileAppender, level);
    }

    private FileAppender<ILoggingEvent> getFileAppenderWithPatternLayoutEncoder(String file, ch.qos.logback.classic.Logger rootApiLogger) {
        return this.getFileAppender(file, rootApiLogger, this.getPatternLayoutEncoder(rootApiLogger));
    }

    private Level getLoggingLevel(DeclaredLogLevel declaredLogLevel) {
        return declaredLogLevel != null ? declaredLogLevel.getLogBackLevel() : Level.ALL;
    }

    private FileAppender<ILoggingEvent> getFileAppender(String file, ch.qos.logback.classic.Logger rootLogger, PatternLayoutEncoder encoder) {
        FileAppender fileAppender = new FileAppender();
        fileAppender.setContext((Context)rootLogger.getLoggerContext());
        fileAppender.setFile(file);
        fileAppender.setEncoder((Encoder)encoder);
        fileAppender.start();
        return fileAppender;
    }

    private PatternLayoutEncoder getPatternLayoutEncoder(ch.qos.logback.classic.Logger rootLogger) {
        PatternLayoutEncoder encoder = new PatternLayoutEncoder();
        encoder.setContext((Context)rootLogger.getLoggerContext());
        encoder.setPattern(DEFAULT_LOGGER_PATTERN);
        encoder.start();
        return encoder;
    }

    private void redirectLoggers(Set<String> loggers, ILoggerFactory loggerContext, FileAppender<ILoggingEvent> fileAppender, Level level) {
        for (String loggerName : loggers) {
            this.redirectLogger(loggerContext, fileAppender, level, loggerName);
        }
    }

    private void redirectLogger(ILoggerFactory loggerContext, FileAppender<ILoggingEvent> fileAppender, Level level, String loggerName) {
        Logger apiLogger = loggerContext.getLogger(loggerName);
        if (apiLogger instanceof ch.qos.logback.classic.Logger) {
            this.redirectLogBackLogger((ch.qos.logback.classic.Logger)loggerContext.getLogger(loggerName), fileAppender, level);
        } else {
            LoggingRedirector.logIncorrectLoggerImplementation("logger", apiLogger);
        }
    }

    private void redirectLogBackLogger(ch.qos.logback.classic.Logger logger, FileAppender<ILoggingEvent> fileAppender, Level level) {
        logger.setLevel(level);
        logger.addAppender(fileAppender);
    }

    private static void logIncorrectLoggerImplementation(String what, Logger apiLogger) {
        LOGGER.error("The {} has different implementation than expected: {}", (Object)what, (Object)LoggingRedirector.getLoggerClassCanonicalName(apiLogger));
    }

    private static String getLoggerClassCanonicalName(Logger apiLogger) {
        return apiLogger == null ? null : apiLogger.getClass().getCanonicalName();
    }
}

