/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.crx2oak.logging;

import com.adobe.granite.crx2oak.cli.CRX2OakOption;
import com.adobe.granite.crx2oak.logging.LoggingLevelControllerFactory;
import com.adobe.granite.crx2oak.model.Topics;
import com.adobe.granite.crx2oak.pipeline.PipeData;
import com.adobe.granite.crx2oak.pipeline.PipelineComponent;
import com.google.common.base.Preconditions;
import joptsimple.OptionSet;

public class TraceLogsEnabler
implements PipelineComponent {
    private static final String CRX2OAK_LOGGER_NAME = "com.adobe.granite.crx2oak";
    private final LoggingLevelControllerFactory loggingLevelControllerFactory;
    private final PipelineComponent nonTraceModeAlternativeComponent;

    public TraceLogsEnabler(LoggingLevelControllerFactory loggingLevelControllerFactory, PipelineComponent nonTraceModeAlternativeComponent) {
        this((PipelineComponent)Preconditions.checkNotNull((Object)nonTraceModeAlternativeComponent), loggingLevelControllerFactory);
    }

    public TraceLogsEnabler(LoggingLevelControllerFactory loggingLevelControllerFactory) {
        this(null, loggingLevelControllerFactory);
    }

    private TraceLogsEnabler(PipelineComponent nonTraceModeAlternativeComponent, LoggingLevelControllerFactory loggingLevelControllerFactory) {
        this.loggingLevelControllerFactory = (LoggingLevelControllerFactory)Preconditions.checkNotNull((Object)loggingLevelControllerFactory);
        this.nonTraceModeAlternativeComponent = nonTraceModeAlternativeComponent;
    }

    private PipelineComponent getProcessorThatSetupTraceLogging() {
        return this.loggingLevelControllerFactory.createLogLevelController(CRX2OAK_LOGGER_NAME, LoggingLevelControllerFactory.LogOps.SET_TO_TRACE);
    }

    @Override
    public PipeData process(PipeData input) {
        OptionSet optionSet = input.require(Topics.OPTION_SET);
        return optionSet.has(CRX2OakOption.TRACE_LOGGING.option) ? this.enableTrace(input) : this.doNotEnableTrace(input);
    }

    private PipeData enableTrace(PipeData input) {
        return this.getProcessorThatSetupTraceLogging().process(input);
    }

    private PipeData doNotEnableTrace(PipeData input) {
        return this.nonTraceModeAlternativeComponent != null ? this.nonTraceModeAlternativeComponent.process(input) : input;
    }
}

