/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.crx2oak.model;

import com.adobe.granite.crx2oak.cli.CRX2OakOption;
import com.adobe.granite.crx2oak.model.MigrationMode;
import com.adobe.granite.crx2oak.model.RunMode;
import com.adobe.granite.crx2oak.model.Topics;
import com.adobe.granite.crx2oak.pipeline.InputAggregatingComponent;
import com.adobe.granite.crx2oak.pipeline.PipeData;
import com.adobe.granite.crx2oak.pipeline.Pipeline;
import java.util.ArrayList;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelInitializer
extends InputAggregatingComponent {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModelInitializer.class);

    @Override
    public PipeData preprocess(PipeData input) {
        try {
            return this.initialize(input);
        }
        catch (RuntimeException e) {
            return this.abortInitialization(e);
        }
    }

    private PipeData abortInitialization(RuntimeException e) {
        String message = String.format("%s. Use %s option to see a full usage", e.getMessage(), CRX2OakOption.getDashedOptionFor("help"));
        LOGGER.error(message);
        return Pipeline.streamClosed(PipeData.put(Topics.EXIT_CODE, 1).toPipe());
    }

    private PipeData initialize(PipeData input) {
        OptionParser parser = input.require(Topics.OPTION_PARSER);
        String[] args = input.require(Topics.CMD_LINE_ARGS);
        OptionSet optionSet = parser.parse(args);
        return PipeData.put(Topics.RUN_MODE, RunMode.STANDALONE).put(Topics.MIGRATION_MODE, MigrationMode.DRY_PREPARE_MIGRATION_MODE).put(Topics.ORIGINAL_CMD_LINE_ARGS, args).put(Topics.INSTALLABLE_OSGI_CONFIGS, new ArrayList()).put(Topics.PRE_MIGRATION_ACTIONS, new ArrayList()).put(Topics.POST_MIGRATION_ACTIONS, new ArrayList()).put(Topics.OPTION_SET, optionSet).put(Topics.WARNINGS, new ArrayList()).toPipe();
    }
}

