/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.crx2oak.oak;

import com.adobe.granite.crx2oak.model.Topics;
import com.adobe.granite.crx2oak.oak.OakTopics;
import com.adobe.granite.crx2oak.pipeline.PipeData;
import java.io.IOException;
import joptsimple.OptionSet;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.oak.upgrade.cli.parser.CliArgumentException;
import org.apache.jackrabbit.oak.upgrade.cli.parser.DatastoreArguments;
import org.apache.jackrabbit.oak.upgrade.cli.parser.MigrationCliArguments;
import org.apache.jackrabbit.oak.upgrade.cli.parser.MigrationOptions;
import org.apache.jackrabbit.oak.upgrade.cli.parser.StoreArguments;

public class OakUtils {
    public static String normalizeArgumentToPath(String argument) {
        return argument.startsWith("segment-old:") ? StringUtils.removeStart((String)argument, (String)"segment-old:") : argument;
    }

    public static PipeData updateAllOakTopics(PipeData input) throws CliArgumentException, IOException {
        return OakUtils.updateSecondaryHeavyOakTopics(OakUtils.updatePrimaryLightOakTopics(input));
    }

    public static PipeData updatePrimaryLightOakTopics(PipeData input) throws CliArgumentException {
        OptionSet optionSet = input.require(Topics.OPTION_SET);
        MigrationCliArguments cliArgs = new MigrationCliArguments(optionSet);
        MigrationOptions opts = new MigrationOptions(cliArgs);
        StoreArguments storeArgs = new StoreArguments(opts, cliArgs.getArguments());
        PipeData oakTopics = PipeData.put(OakTopics.ARGS, cliArgs).put(OakTopics.OPTS, opts).put(OakTopics.STORE_ARGS, storeArgs).toPipe();
        return PipeData.use(input).apply(oakTopics).toPipe();
    }

    public static PipeData updateSecondaryHeavyOakTopics(PipeData input) throws IOException, CliArgumentException {
        MigrationOptions opts = input.require(OakTopics.OPTS);
        StoreArguments storeArgs = input.require(OakTopics.STORE_ARGS);
        boolean srcUsesEmbeddedDataStore = storeArgs.srcUsesEmbeddedDatastore();
        DatastoreArguments datastoreArgs = new DatastoreArguments(opts, storeArgs, srcUsesEmbeddedDataStore);
        PipeData oakTopics = PipeData.put(OakTopics.DATA_STORE_ARGS, datastoreArgs).put(OakTopics.EMBEDDED_DS_SRC_REPO, srcUsesEmbeddedDataStore).toPipe();
        return PipeData.use(input).apply(oakTopics).toPipe();
    }
}

