/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.crx2oak.oldsegment;

import com.adobe.granite.crx2oak.cli.CRX2OakOption;
import com.adobe.granite.crx2oak.model.RunMode;
import com.adobe.granite.crx2oak.model.Topics;
import com.adobe.granite.crx2oak.pipeline.PipeData;
import com.adobe.granite.crx2oak.pipeline.Pipeline;
import com.adobe.granite.crx2oak.pipeline.PipelineComponent;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import joptsimple.OptionSet;
import org.apache.jackrabbit.oak.upgrade.cli.parser.CliArgumentException;
import org.apache.jackrabbit.oak.upgrade.cli.parser.MigrationCliArguments;
import org.apache.jackrabbit.oak.upgrade.cli.parser.StoreType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigrationVerifier
implements PipelineComponent {
    private static final Logger LOGGER = LoggerFactory.getLogger(MigrationVerifier.class);
    private static Collection<StoreType> CRX2_STORE_TYPES = new HashSet<StoreType>(Arrays.asList(StoreType.JCR2_DIR, StoreType.JCR2_DIR_XML, StoreType.JCR2_XML));

    @Override
    public PipeData process(PipeData input) {
        OptionSet options = input.require(Topics.OPTION_SET);
        RunMode runMode = input.require(Topics.RUN_MODE);
        return options.has(CRX2OakOption.DETECT_OLD_SEGMENT.option) && runMode == RunMode.QUICKSTART_EXTENSION && this.verifyIfArgumentsAreTheSame(options) ? this.closePipelineAsTheStateIsIncorrect(input) : input;
    }

    private PipeData closePipelineAsTheStateIsIncorrect(PipeData input) {
        LOGGER.warn("Migration is not needed for this instance. Finishing.");
        return Pipeline.streamClosed(input);
    }

    private boolean verifyIfArgumentsAreTheSame(OptionSet options) {
        try {
            MigrationCliArguments migrationCliArguments = new MigrationCliArguments(options);
            List args = migrationCliArguments.getArguments();
            StoreType sourceStoreType = StoreType.getMatchingType((String)((String)args.get(0)));
            return !CRX2_STORE_TYPES.contains(sourceStoreType) && args.size() == 2 && Objects.equals(args.get(0), args.get(1));
        }
        catch (CliArgumentException e) {
            return false;
        }
    }
}

