/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.crx2oak.oldsegment;

import com.adobe.granite.crx2oak.cli.CRX2OakOption;
import com.adobe.granite.crx2oak.model.RunMode;
import com.adobe.granite.crx2oak.model.Topics;
import com.adobe.granite.crx2oak.oak.OakUtils;
import com.adobe.granite.crx2oak.pipeline.PipeData;
import com.adobe.granite.crx2oak.sling.SlingOptionsFileFinder;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import joptsimple.OptionSet;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.oak.segment.file.FileStoreBuilder;
import org.apache.jackrabbit.oak.segment.file.InvalidFileStoreVersionException;
import org.apache.jackrabbit.oak.upgrade.cli.parser.CliArgumentException;
import org.apache.jackrabbit.oak.upgrade.cli.parser.MigrationCliArguments;
import org.apache.jackrabbit.oak.upgrade.cli.parser.MigrationOptions;
import org.apache.jackrabbit.oak.upgrade.cli.parser.StoreArguments;
import org.apache.jackrabbit.oak.upgrade.cli.parser.StoreType;
import org.apache.sling.settings.impl.RunModes;
import org.apache.sling.settings.impl.SlingOptionsFileReader;
import org.apache.sling.settings.impl.SlingOptionsReadResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OldSegmentDetector {
    private static final Logger log = LoggerFactory.getLogger(OldSegmentDetector.class);
    private static final String OLD_SEGMENT_SLING_RUN_MODE = "crx3tar";
    private static final ImmutableList<StoreType> CRX2_STORE_TYPES = ImmutableList.of((Object)StoreType.JCR2_DIR, (Object)StoreType.JCR2_DIR_XML, (Object)StoreType.JCR2_XML);
    private static final String TEMPORARY_SUFFIX = "-crx2oak-dst-repo";
    private final SlingOptionsFileFinder slingOptionsFileFinder;
    private final SlingOptionsFileReader slingOptionsFileReader;

    public OldSegmentDetector(SlingOptionsFileFinder slingOptionsFileFinder, SlingOptionsFileReader slingOptionsFileReader) {
        this.slingOptionsFileFinder = (SlingOptionsFileFinder)Preconditions.checkNotNull((Object)slingOptionsFileFinder, (Object)"The Sling Options File Finder is mandatory but is null");
        this.slingOptionsFileReader = (SlingOptionsFileReader)Preconditions.checkNotNull((Object)slingOptionsFileReader, (Object)"The Sling Options File Reader is mandatory but is null");
    }

    public boolean detect(PipeData input) {
        OptionSet options = input.require(Topics.OPTION_SET);
        String slingHomeDetectionOptions = input.require(Topics.SLING_HOME_DETECTION_OPTIONS).toString();
        String slingHome = (String)input.get(Topics.SLING_HOME).or((Object)"");
        return options.has(CRX2OakOption.DETECT_OLD_SEGMENT.option) && this.deductOldSegmentFormatOfTarFiles(options, slingHomeDetectionOptions, slingHome);
    }

    private boolean deductOldSegmentFormatOfTarFiles(OptionSet options, String detectionOpts, String slingHome) {
        return this.isNotCrx2SrcRepo(options) && this.hasSrcRepoTarFiles(slingHome, detectionOpts) && this.isNotSegmentTarSrcRepo(options) && this.flagPositiveDetectionOfOldSegment();
    }

    private boolean isNotSegmentTarSrcRepo(OptionSet options) {
        log.debug("checking source repository");
        String srcPath = null;
        try {
            srcPath = OakUtils.normalizeArgumentToPath(this.getStoreArguments(options).getSrcPaths()[0]);
            this.openSegmentTarRepo(srcPath);
        }
        catch (CliArgumentException e) {
            log.debug("Unable to check if source repository is not of SEGMENT_TAR type", (Throwable)e);
            return true;
        }
        catch (InvalidFileStoreVersionException e) {
            log.debug("This is not a segment tar repo format.");
            return true;
        }
        catch (IOException e) {
            log.debug("Cannot open the source repository", (Throwable)e);
            return true;
        }
        catch (RuntimeException e) {
            log.debug("Unexpected exception during checking the SEGMENT_TAR type of source repository", (Throwable)e);
            log.error("Fatal problem checking the source repository: {}. Is the repository valid?", (Object)srcPath);
        }
        return false;
    }

    private void openSegmentTarRepo(String srcPath) throws InvalidFileStoreVersionException, IOException {
        FileStoreBuilder.fileStoreBuilder((File)new File(srcPath, "segmentstore")).withMaxFileSize(256).withMemoryMapping(false).buildReadOnly().close();
    }

    private boolean isNotCrx2SrcRepo(OptionSet parsedOptions) {
        try {
            return this.isTheSourceRepositoryNotOfCRX2TypeUnchecked(parsedOptions);
        }
        catch (CliArgumentException e) {
            return this.answerTrueToContinueDetectionAsRepositoryCannotBeDetected(e);
        }
    }

    private boolean answerTrueToContinueDetectionAsRepositoryCannotBeDetected(CliArgumentException e) {
        log.debug("Unable to check if source repository is not of CRX2 type", (Throwable)e);
        return true;
    }

    private boolean isTheSourceRepositoryNotOfCRX2TypeUnchecked(OptionSet parsedOptions) throws CliArgumentException {
        StoreType sourceStoreType = this.getStoreType(parsedOptions);
        boolean isSourceRepoOfCRX2Type = CRX2_STORE_TYPES.contains((Object)sourceStoreType);
        if (isSourceRepoOfCRX2Type) {
            log.debug("The CRX2 repository is detected as source. Skipping detection of the old tar segment format.");
        }
        return !isSourceRepoOfCRX2Type;
    }

    private StoreType getStoreType(OptionSet parsedOptions) throws CliArgumentException {
        StoreArguments storeArguments = this.getStoreArguments(parsedOptions);
        return storeArguments.getSrcType();
    }

    private StoreArguments getStoreArguments(OptionSet parsedOptions) throws CliArgumentException {
        MigrationCliArguments migrationCliArguments = new MigrationCliArguments(parsedOptions);
        MigrationOptions migrationOptions = new MigrationOptions(migrationCliArguments);
        List<String> args = this.postfixLastArgWhenManyArgs(migrationCliArguments.getArguments());
        return new StoreArguments(migrationOptions, args);
    }

    private List<String> postfixLastArgWhenManyArgs(List<String> arguments) {
        return arguments.size() > 1 ? this.appendSuffixForLastArgument(arguments) : arguments;
    }

    private List<String> appendSuffixForLastArgument(List<String> arguments) {
        int lastIdx = arguments.size() - 1;
        String suffixedArg = arguments.get(lastIdx) + TEMPORARY_SUFFIX;
        return Lists.newArrayList((Iterable)Iterables.concat(arguments.subList(0, lastIdx), Collections.singletonList(suffixedArg)));
    }

    private boolean hasSrcRepoTarFiles(String detectedSlingHomePath, String slingHomeDetectionOptions) {
        return StringUtils.isEmpty((String)detectedSlingHomePath) ? this.falseDetectionOfOldSegmentDueToMissingSlingHomePath(slingHomeDetectionOptions) : this.isOldSegmentDetected(detectedSlingHomePath);
    }

    private boolean falseDetectionOfOldSegmentDueToMissingSlingHomePath(String slingHomeDetectionOptions) {
        log.warn("The old segment detection option can be used in {} mode.", (Object)RunMode.QUICKSTART_EXTENSION);
        log.warn("You can activate {} mode yourself by providing Sling home variable ({})", (Object)RunMode.QUICKSTART_EXTENSION, (Object)slingHomeDetectionOptions);
        return false;
    }

    private boolean isOldSegmentDetected(String slingHome) {
        Collection<File> slingOptionsFilesCollection = this.slingOptionsFileFinder.getSlingOptionsFiles(slingHome);
        return this.detectOldSegmentUsingSlingOptionsFiles(slingOptionsFilesCollection);
    }

    private boolean detectOldSegmentUsingSlingOptionsFiles(Collection<File> slingOptionsFilesCollection) {
        return slingOptionsFilesCollection.isEmpty() ? this.falseDetectionOfOldSegmentDueToEmptySetOfSlingOptionFiles() : this.detectOldSegmentUsingNonEmptySlingOptionsFiles(slingOptionsFilesCollection);
    }

    private boolean falseDetectionOfOldSegmentDueToEmptySetOfSlingOptionFiles() {
        log.warn("The option: {} was specified but sling options file cannot be found", (Object)CRX2OakOption.DETECT_OLD_SEGMENT.dashedOption);
        return false;
    }

    private boolean detectOldSegmentUsingNonEmptySlingOptionsFiles(Collection<File> slingOptionsFiles) {
        for (File slingOptionFile : slingOptionsFiles) {
            if (!this.detectOldSegmentRunModeInSlingOptionFile(slingOptionFile)) continue;
            return true;
        }
        return false;
    }

    private boolean detectOldSegmentRunModeInSlingOptionFile(File slingOptionFile) {
        return slingOptionFile.canRead() ? this.checkCrx3TarSelectedRunModeInSlingOptionFile(slingOptionFile) : this.falseDetectionOfOldSegmentDueToUnreadableFile(slingOptionFile);
    }

    private boolean falseDetectionOfOldSegmentDueToUnreadableFile(File slingOptionFile) {
        log.debug("Cannot read file: {}. Cannot detect old segment format properly.", (Object)slingOptionFile.getAbsolutePath());
        return false;
    }

    private boolean falseDetectionOfOldSegmentDueToUnprocessableFile(File slingOptionFile) {
        log.debug("Cannot process file: {}. Cannot detect old segment format properly.", (Object)slingOptionFile.getAbsolutePath());
        return false;
    }

    private boolean checkCrx3TarSelectedRunModeInSlingOptionFile(File slingOptionFile) {
        SlingOptionsReadResult slingOptionsReadResult = this.slingOptionsFileReader.readOptions(slingOptionFile);
        return slingOptionsReadResult.isSuccessful() ? this.checkForCrx3TarInSlingOptions(slingOptionsReadResult) : this.falseDetectionOfOldSegmentDueToUnprocessableFile(slingOptionFile);
    }

    private boolean checkForCrx3TarInSlingOptions(SlingOptionsReadResult slingOptionsReadResult) {
        RunModes runModes = slingOptionsReadResult.getRunModes();
        List<String> listOfSelectedRunModes = this.getListOfSelectedRunModes(runModes);
        return listOfSelectedRunModes.contains(OLD_SEGMENT_SLING_RUN_MODE) || this.falseDetectionDueToMissingOldSegmentSlingRunMode(listOfSelectedRunModes);
    }

    private boolean falseDetectionDueToMissingOldSegmentSlingRunMode(List<String> listOfSelectedRunModes) {
        log.debug("{} runmode not found amongst: {}", (Object)OLD_SEGMENT_SLING_RUN_MODE, listOfSelectedRunModes);
        return false;
    }

    private List<String> getListOfSelectedRunModes(RunModes runModes) {
        return Lists.newArrayList((Iterable)Iterables.transform(runModes.getGroups(), (Function)new Function<RunModes.Group, String>(){

            @Nullable
            public String apply(@Nullable RunModes.Group group) {
                assert (group != null);
                return group.getSelectedMode();
            }
        }));
    }

    private boolean flagPositiveDetectionOfOldSegment() {
        log.info("The old segment-tar format was found in source instance. Including necessary steps into migration.");
        return true;
    }
}

