/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.crx2oak.oldsegment;

import com.adobe.granite.crx2oak.cli.CRX2OakOption;
import com.adobe.granite.crx2oak.cli.CmdLineOption;
import com.adobe.granite.crx2oak.cli.transformer.TransparentCommandLineEventTransformer;
import com.adobe.granite.crx2oak.model.CliModelTransformer;
import com.adobe.granite.crx2oak.model.Topics;
import com.adobe.granite.crx2oak.oldsegment.OldSegmentDetector;
import com.adobe.granite.crx2oak.pipeline.InputAggregatingComponent;
import com.adobe.granite.crx2oak.pipeline.PipeData;
import com.adobe.granite.crx2oak.pipeline.Pipeline;
import com.adobe.granite.crx2oak.util.FilesystemUtils;
import com.google.common.base.Optional;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import javax.annotation.Nonnull;
import joptsimple.OptionSet;
import org.apache.jackrabbit.oak.upgrade.cli.parser.CliArgumentException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OldSegmentMigrationPlanner
extends InputAggregatingComponent {
    private static final String NEW_SEGMENT_TAR_REPOSITORY = File.separator + "repository-segment-tar-";
    private static final String REPOSITORY = File.separator + "repository";
    private static final Logger log = LoggerFactory.getLogger(OldSegmentMigrationPlanner.class);
    private final CliModelTransformer cliModelTransformer;
    private final OldSegmentDetector oldSegmentDetector;

    public OldSegmentMigrationPlanner(@Nonnull OldSegmentDetector oldSegmentDetector, @Nonnull CliModelTransformer cliModelTransformer) {
        this.oldSegmentDetector = Objects.requireNonNull(oldSegmentDetector, "The Old Segment Detector is mandatory and cannot be null");
        this.cliModelTransformer = Objects.requireNonNull(cliModelTransformer);
    }

    @Override
    protected PipeData preprocess(PipeData input) {
        Optional<String> slingHomeOptional = input.get(Topics.SLING_HOME);
        return slingHomeOptional.isPresent() ? this.scheduleMigrationIfOldSegmentPresent((String)slingHomeOptional.get(), input) : PipeData.EMPTY;
    }

    private PipeData scheduleMigrationIfOldSegmentPresent(String slingHome, PipeData input) {
        return this.oldSegmentDetector.detect(input) ? this.scheduleMigration(slingHome, input) : PipeData.EMPTY;
    }

    private PipeData scheduleMigration(String slingHome, PipeData input) {
        try {
            return this.scheduleMigrationUnchecked(slingHome, input);
        }
        catch (IOException e) {
            log.error("Cannot delegate tasks to migration as I/O exception occurred. Aborting the whole migration.", (Throwable)e);
            return Pipeline.streamClosed(input);
        }
    }

    private PipeData scheduleMigrationUnchecked(String slingHome, PipeData input) throws IOException {
        File newSegmentTarRepositoryDirectory = new File(slingHome + NEW_SEGMENT_TAR_REPOSITORY + FilesystemUtils.getCurrentTimestampFilenameSuffix()).getCanonicalFile();
        File oldSegmentRepositoryDirectory = new File(slingHome + REPOSITORY).getCanonicalFile();
        return PipeData.use(this.changeCommandLineOptions(input, newSegmentTarRepositoryDirectory, oldSegmentRepositoryDirectory)).toPipe();
    }

    private PipeData changeCommandLineOptions(PipeData input, File newSegmentTarRepositoryDirectory, File oldSegmentTarRepositoryDirectory) {
        try {
            return this.changeCommandLineOptionsUnchecked(input, newSegmentTarRepositoryDirectory, oldSegmentTarRepositoryDirectory);
        }
        catch (CliArgumentException e) {
            log.error("Cannot invoke migration. Automatic transformation of migration options failed", (Throwable)e);
            return Pipeline.streamClosed(input);
        }
    }

    private PipeData changeCommandLineOptionsUnchecked(PipeData input, File newSegmentTarRepositoryDirectory, File oldSegmentTarRepositoryDirectory) throws CliArgumentException {
        TransparentCommandLineEventTransformer transformer = this.getOldSegmentCommandLineEventTransformer(newSegmentTarRepositoryDirectory, oldSegmentTarRepositoryDirectory);
        return this.cliModelTransformer.transformCommandLine(input, transformer);
    }

    private TransparentCommandLineEventTransformer getOldSegmentCommandLineEventTransformer(final File newSegmentTarRepositoryDirectory, final File oldSegmentTarRepositoryDirectory) {
        return new TransparentCommandLineEventTransformer(){

            @Override
            @Nonnull
            public Collection<String> transformArguments(@Nonnull OptionSet optionSet) {
                String sourceArgument = "segment-old:" + oldSegmentTarRepositoryDirectory.getAbsolutePath();
                String destinationArgument = newSegmentTarRepositoryDirectory.getAbsolutePath();
                return Arrays.asList(sourceArgument, destinationArgument);
            }

            @Override
            @Nonnull
            public Collection<CmdLineOption> getAdditionalOptions() {
                return Collections.singleton(CmdLineOption.withoutArgument(CRX2OakOption.REPLACE.option));
            }
        };
    }
}

