/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.crx2oak.pipeline;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class PipeData {
    public static final PipeData EMPTY = new PipeData(Collections.emptyMap());
    private Map<String, Object> map;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PipeData pipeData = (PipeData)o;
        return Objects.equals(this.map, pipeData.map);
    }

    public int hashCode() {
        return Objects.hash(this.map);
    }

    public static PipeDataBuilder use(PipeData pipeData) {
        return new PipeDataBuilder(pipeData.map);
    }

    private PipeData(Map<String, Object> map) {
        this.map = Objects.requireNonNull(map);
    }

    public static PipeDataBuilder empty() {
        return new PipeDataBuilder(Collections.emptyMap());
    }

    public static <T> PipeDataBuilder put(Topic<T> topic, @Nonnull T value) {
        return PipeData.empty().put(topic, value);
    }

    public static <T> PipeDataBuilder putOptionally(Topic<T> topic, @Nullable T value) {
        return PipeData.empty().putOptionally(topic, value);
    }

    public static <V, T extends List<V>> PipeDataBuilder join(PipeData input, Topic<T> topic, V ... newjoiners) {
        return PipeData.empty().join(input, topic, newjoiners);
    }

    public static <V, T extends List<V>> PipeDataBuilder join(PipeData input, Topic<T> topic, List<V> newjoiners) {
        return PipeData.empty().join(input, topic, newjoiners);
    }

    public static <V, T extends List<V>> PipeDataBuilder join(PipeData input, Topic<T> topic, PipeData inputToJoin) {
        return PipeData.empty().join(input, topic, inputToJoin);
    }

    public <T> Optional<T> get(Topic<T> topic) {
        return Optional.fromNullable((Object)this.map.get(topic.getName()));
    }

    public <T> T require(Topic<T> topic) {
        Optional<T> optionalValue = this.get(topic);
        if (optionalValue.isPresent()) {
            return (T)optionalValue.get();
        }
        throw new IllegalStateException(String.format("The value of %s is required", topic.getName()));
    }

    public String toString() {
        return "PipeData" + this.map;
    }

    public static final class PipeDataBuilder {
        private Map<String, Object> map;

        private PipeDataBuilder(Map<String, Object> pipeData) {
            this.map = new HashMap<String, Object>(pipeData);
        }

        public <T> PipeDataBuilder put(Topic<T> topic, @Nonnull T value) {
            this.map.put(topic.getName(), Objects.requireNonNull(value));
            return this;
        }

        public PipeDataBuilder drop(Topic<?> topic) {
            this.map.remove(topic.getName());
            return this;
        }

        public PipeData toPipe() {
            return new PipeData((Map)ImmutableMap.copyOf(this.map));
        }

        public PipeDataBuilder apply(PipeData input) {
            this.map.putAll(input.map);
            return this;
        }

        public <T> PipeDataBuilder putOptionally(Topic<T> topic, @Nullable T value) {
            if (value != null) {
                this.put(topic, value);
            }
            return this;
        }

        public <V, T extends List<V>> PipeDataBuilder join(PipeData input, Topic<T> topic, V ... newjoiners) {
            this.join(input, topic, Arrays.asList(newjoiners));
            return this;
        }

        public <V, T extends List<V>> PipeDataBuilder join(PipeData input, Topic<T> topic, PipeData inputToJoin) {
            List<V> existingValues = this.getTopicValueAsList(inputToJoin, topic);
            this.join(input, topic, existingValues);
            return this;
        }

        public <V, T extends List<V>> PipeDataBuilder join(PipeData input, Topic<T> topic, List<V> newjoiners) {
            List<V> existingValues = this.getTopicValueAsList(input, topic);
            ArrayList<V> newList = new ArrayList<V>(existingValues);
            newList.addAll(newjoiners);
            this.put(topic, newList);
            return this;
        }

        private <V, T extends List<V>> List<V> getTopicValueAsList(PipeData input, Topic<List<V>> topic) {
            return (List)input.get(topic).or(Collections.emptyList());
        }
    }

    public static final class Topic<T> {
        private final String name;

        public Topic(String name) {
            this.name = Objects.requireNonNull(name);
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return "Topic{name='" + this.name + '\'' + '}';
        }
    }
}

